/*
 * Decompiled with CFR 0.152.
 */
package com.bigstep.datalake;

import java.io.File;
import java.io.IOException;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.authentication.util.KerberosUtil;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.PlatformName;

public class KerberosIdentity {
    public static final Log LOG = LogFactory.getLog(KerberosIdentity.class);
    private final long DEFAULT_RELOGIN_TIME = 18000000L;
    private long reloginTime;
    private Subject subject;
    private String kerberosPrincipal;
    private String kerberosKeytab;
    private String kerberosRealm;
    private Date lastLogin;

    public KerberosIdentity(long reloginTime) {
        this.reloginTime = reloginTime;
    }

    public KerberosIdentity() {
        this.reloginTime = 18000000L;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public String getRealm() {
        return this.kerberosRealm;
    }

    public void login(String kerberosPrincipal, String kerberosKeytab, String kerberosRealm) throws IOException {
        File kerberosKeytabFile = new File(kerberosKeytab);
        if (!kerberosKeytabFile.exists()) {
            throw new IOException("Kerberos keytab file " + kerberosKeytab + " not found");
        }
        if (!kerberosKeytabFile.canRead()) {
            throw new IOException("Kerberos keytab file " + kerberosKeytab + " cannot be accessed");
        }
        try {
            KerberosConfiguration loginContextConfiguration = new KerberosConfiguration(kerberosKeytab, kerberosPrincipal, kerberosRealm);
            LoginContext lc = new LoginContext("", null, null, loginContextConfiguration);
            LOG.debug((Object)("Attempting login as " + kerberosPrincipal + " using " + kerberosKeytab));
            lc.login();
            this.subject = lc.getSubject();
            this.lastLogin = new Date();
        }
        catch (LoginException le) {
            throw new IOException(le);
        }
    }

    public Date getLastLogin() {
        return this.lastLogin;
    }

    public boolean isLoginNecessary() {
        long lastLoginTime = this.getLastLogin().getTime();
        long currentTime = new Date().getTime();
        return currentTime - lastLoginTime > this.reloginTime;
    }

    public void relogin() throws IOException {
        this.login(this.kerberosPrincipal, this.kerberosKeytab, this.kerberosRealm);
    }

    public void reloginIfNecessary() throws IOException {
        if (this.isLoginNecessary()) {
            this.relogin();
        }
    }

    public <T> T doAsPrivileged(PrivilegedAction<T> action) {
        this.logPrivilegedAction(this.subject, action);
        return Subject.doAsPrivileged(this.subject, action, null);
    }

    public <T> T doAsPriviledged(PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        this.logPrivilegedAction(this.subject, action);
        return Subject.doAsPrivileged(this.subject, action, null);
    }

    public <T> T doAs(PrivilegedAction<T> action) {
        this.logPrivilegedAction(this.subject, action);
        return Subject.doAs(this.subject, action);
    }

    public <T> T doAs(PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        this.logPrivilegedAction(this.subject, action);
        return Subject.doAs(this.subject, action);
    }

    private void logPrivilegedAction(Subject subject, Object action) {
        if (LOG.isDebugEnabled()) {
            String where = new Throwable().getStackTrace()[2].toString();
            LOG.debug((Object)("PrivilegedAction as:" + this + " from:" + where));
        }
    }

    public Principal getPrincipal() {
        Set<Principal> principals = this.subject.getPrincipals();
        if (principals == null) {
            return null;
        }
        Iterator<Principal> iter = principals.iterator();
        if (iter.hasNext()) {
            return iter.next();
        }
        return null;
    }

    public String getPrincipalShortName() {
        Principal principal = this.getPrincipal();
        String fullUserName = principal.getName();
        Pattern r = Pattern.compile("(.*)(\\/(.*))?\\@(.*)");
        Matcher m = r.matcher(fullUserName);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    public String getPrincipalName() {
        Principal principal = this.getPrincipal();
        return principal.getName();
    }

    private synchronized Credentials getCredentialsInternal() {
        Credentials credentials;
        Set<Credentials> credentialsSet = this.subject.getPrivateCredentials(Credentials.class);
        if (!credentialsSet.isEmpty()) {
            credentials = credentialsSet.iterator().next();
        } else {
            credentials = new Credentials();
            this.subject.getPrivateCredentials().add(credentials);
        }
        return credentials;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Token<? extends TokenIdentifier>> getTokens() {
        Subject subject = this.subject;
        synchronized (subject) {
            return Collections.unmodifiableCollection(new ArrayList(this.getCredentialsInternal().getAllTokens()));
        }
    }

    public String toString() {
        return "KerberosIdentity (" + this.getPrincipalName() + "[" + this.getPrincipalShortName() + "])";
    }

    private static class KerberosConfiguration
    extends Configuration {
        private String keytab;
        private String principal;
        private String realm;

        public KerberosConfiguration(String keytab, String principal, String realm) {
            this.keytab = keytab;
            this.principal = principal;
            this.realm = realm;
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            HashMap<String, String> options = new HashMap<String, String>();
            if (PlatformName.IBM_JAVA) {
                options.put("useKeytab", this.keytab.startsWith("file://") ? this.keytab : "file://" + this.keytab);
                options.put("principal", this.principal);
                options.put("credsType", "acceptor");
            } else {
                options.put("keyTab", this.keytab);
                options.put("realm", this.realm);
                options.put("principal", this.principal);
                options.put("useKeyTab", "true");
                options.put("storeKey", "true");
                options.put("doNotPrompt", "true");
                options.put("useTicketCache", "false");
                options.put("renewTGT", "false");
                options.put("isInitiator", "true");
                if (LOG.isDebugEnabled()) {
                    options.put("debug", "true");
                }
            }
            options.put("refreshKrb5Config", "true");
            return new AppConfigurationEntry[]{new AppConfigurationEntry(KerberosUtil.getKrb5LoginModuleName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
        }
    }
}

