/*
 * Decompiled with CFR 0.152.
 */
package com.bigstep.datalake;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public class DLEncryptionUtils {
    private static DLEncryptionUtils instance = null;
    private String strName = "DLENCRYPTION";
    private String strVersion = "1.0";
    private String strCipher = "AES/CTR/NoPadding";
    private final int nHeaderDetailLength = 128;
    private final int nIVLength = 16;
    private final int nAesKeyLength = 16;
    private boolean _isInitialised = false;
    private String _aesKeyPath;
    private byte[] _aesKey;
    private SecureRandom secureRandom = null;

    private DLEncryptionUtils() {
    }

    public static DLEncryptionUtils getInstance() {
        if (instance == null) {
            instance = new DLEncryptionUtils();
        }
        return instance;
    }

    public String getTransform() {
        return this.strCipher;
    }

    public void loadAesKeyFromStringPath(String aesKeyPath) throws IOException {
        int size;
        File file;
        this._aesKeyPath = aesKeyPath;
        if (!this._isInitialised) {
            File aesKeyFile = new File(this._aesKeyPath);
            if (!aesKeyFile.exists()) {
                throw new IOException("AES key file " + this._aesKeyPath + " not found");
            }
            if (!aesKeyFile.canRead()) {
                throw new IOException("AES key file " + this._aesKeyPath + " cannot be accessed");
            }
            file = new File(this._aesKeyPath);
            size = (int)file.length();
            assert (size == 16);
        } else {
            throw new IOException("DLEncryption already initialized.");
        }
        this._aesKey = new byte[size];
        BufferedInputStream buf = new BufferedInputStream(new FileInputStream(file));
        buf.read(this._aesKey, 0, this._aesKey.length);
        buf.close();
        this._isInitialised = true;
    }

    public boolean isInitialised() {
        return this._isInitialised;
    }

    public int getHeaderDetailLength() {
        return 128;
    }

    public int getIVLength() {
        return 16;
    }

    public byte[] getHeaderDetail() throws UnsupportedEncodingException {
        String headerDetail = this.strName + ";" + this.strVersion + ";" + this.strCipher;
        String headerDetailPadded = String.format("%1$-128s", headerDetail).replace(' ', '#');
        return headerDetailPadded.getBytes("UTF-8");
    }

    public byte[] getSecretKey() {
        return this._aesKey;
    }

    public byte[] generateRandomIV() throws NoSuchAlgorithmException {
        if (this.secureRandom == null) {
            this.secureRandom = SecureRandom.getInstance("SHA1PRNG");
        }
        byte[] initVector = new byte[16];
        this.secureRandom.nextBytes(initVector);
        return initVector;
    }
}

