/*
 * Decompiled with CFR 0.152.
 */
package zmq;

public class YQueue<T> {
    private Chunk<T> beginChunk;
    private int beginPos;
    private Chunk<T> backChunk;
    private int backPos;
    private Chunk<T> endChunk;
    private int endPos;
    private volatile Chunk<T> spareChunk;
    private final int size;
    private int memoryPtr;

    public YQueue(int size2) {
        this.size = size2;
        this.memoryPtr = 0;
        this.beginChunk = new Chunk(size2, this.memoryPtr);
        this.memoryPtr += size2;
        this.beginPos = 0;
        this.backPos = 0;
        this.backChunk = this.beginChunk;
        this.spareChunk = this.beginChunk;
        this.endChunk = this.beginChunk;
        this.endPos = 1;
    }

    public int frontPos() {
        return this.beginChunk.pos[this.beginPos];
    }

    public T front() {
        return this.beginChunk.values[this.beginPos];
    }

    public int backPos() {
        return this.backChunk.pos[this.backPos];
    }

    public T back() {
        return this.backChunk.values[this.backPos];
    }

    public T pop() {
        Object val = this.beginChunk.values[this.beginPos];
        this.beginChunk.values[this.beginPos] = null;
        ++this.beginPos;
        if (this.beginPos == this.size) {
            this.beginChunk = this.beginChunk.next;
            this.beginChunk.prev = null;
            this.beginPos = 0;
        }
        return val;
    }

    public void push(T val) {
        this.backChunk.values[this.backPos] = val;
        this.backChunk = this.endChunk;
        this.backPos = this.endPos++;
        if (this.endPos != this.size) {
            return;
        }
        Chunk<T> sc = this.spareChunk;
        if (sc != this.beginChunk) {
            this.spareChunk = this.spareChunk.next;
            this.endChunk.next = sc;
            sc.prev = this.endChunk;
        } else {
            this.endChunk.next = new Chunk(this.size, this.memoryPtr);
            this.memoryPtr += this.size;
            this.endChunk.next.prev = this.endChunk;
        }
        this.endChunk = this.endChunk.next;
        this.endPos = 0;
    }

    public void unpush() {
        if (this.backPos > 0) {
            --this.backPos;
        } else {
            this.backPos = this.size - 1;
            this.backChunk = this.backChunk.prev;
        }
        if (this.endPos > 0) {
            --this.endPos;
        } else {
            this.endPos = this.size - 1;
            this.endChunk = this.endChunk.prev;
            this.endChunk.next = null;
        }
    }

    private static class Chunk<T> {
        final T[] values;
        final int[] pos;
        Chunk<T> prev;
        Chunk<T> next;

        public Chunk(int size2, int memoryPtr) {
            this.values = new Object[size2];
            this.pos = new int[size2];
            for (int i = 0; i != this.values.length; ++i) {
                this.pos[i] = memoryPtr++;
            }
        }
    }
}

