/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.channels.SocketChannel;
import zmq.Address;
import zmq.IOObject;
import zmq.IOThread;
import zmq.IPollEvents;
import zmq.Options;
import zmq.Own;
import zmq.SessionBase;
import zmq.SocketBase;
import zmq.StreamEngine;
import zmq.Utils;
import zmq.ZError;

public class TcpConnecter
extends Own
implements IPollEvents {
    private static final int RECONNECT_TIMER_ID = 1;
    private final IOObject ioObject;
    private final Address addr;
    private SocketChannel handle;
    private boolean handleValid;
    private final boolean delayedStart;
    private boolean timerStarted;
    private final SessionBase session;
    private int currentReconnectIvl;
    private final Address address;
    private final SocketBase socket;

    public TcpConnecter(IOThread ioThread, SessionBase session, Options options2, Address addr, boolean delayedStart) {
        super(ioThread, options2);
        this.ioObject = new IOObject(ioThread);
        this.addr = addr;
        this.handle = null;
        this.handleValid = false;
        this.delayedStart = delayedStart;
        this.timerStarted = false;
        this.session = session;
        this.currentReconnectIvl = this.options.reconnectIvl;
        assert (this.addr != null);
        this.address = this.addr;
        this.socket = session.getSocket();
    }

    @Override
    public void destroy() {
        assert (!this.timerStarted);
        assert (!this.handleValid);
        assert (this.handle == null);
    }

    @Override
    protected void processPlug() {
        this.ioObject.setHandler(this);
        if (this.delayedStart) {
            this.addreconnectTimer();
        } else {
            this.startConnecting();
        }
    }

    @Override
    protected void processTerm(int linger) {
        if (this.timerStarted) {
            this.ioObject.cancelTimer(1);
            this.timerStarted = false;
        }
        if (this.handleValid) {
            this.ioObject.removeHandle(this.handle);
            this.handleValid = false;
        }
        if (this.handle != null) {
            this.close();
        }
        super.processTerm(linger);
    }

    @Override
    public void inEvent() {
    }

    @Override
    public void outEvent() {
    }

    @Override
    public void acceptEvent() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void connectEvent() {
        boolean err2 = false;
        SocketChannel fd = null;
        try {
            fd = this.connect();
        }
        catch (ConnectException e) {
            err2 = true;
        }
        catch (SocketException e) {
            err2 = true;
        }
        catch (SocketTimeoutException e) {
            err2 = true;
        }
        catch (IOException e) {
            throw new ZError.IOException(e);
        }
        this.ioObject.removeHandle(this.handle);
        this.handleValid = false;
        if (err2) {
            this.close();
            this.addreconnectTimer();
            return;
        }
        this.handle = null;
        try {
            Utils.tuneTcpSocket(fd);
            Utils.tuneTcpKeepalives(fd, this.options.tcpKeepAlive, this.options.tcpKeepAliveCnt, this.options.tcpKeepAliveIdle, this.options.tcpKeepAliveIntvl);
        }
        catch (SocketException e) {
            throw new RuntimeException(e);
        }
        StreamEngine engine = null;
        try {
            engine = new StreamEngine(fd, this.options, this.address.toString());
        }
        catch (ZError.InstantiationException e) {
            this.socket.eventConnectDelayed(this.address.toString(), -1);
            return;
        }
        this.sendAttach(this.session, engine);
        this.terminate();
        this.socket.eventConnected(this.address.toString(), fd);
    }

    @Override
    public void timerEvent(int id2) {
        this.timerStarted = false;
        this.startConnecting();
    }

    private void startConnecting() {
        try {
            boolean rc = this.open();
            if (rc) {
                this.ioObject.addHandle(this.handle);
                this.handleValid = true;
                this.ioObject.connectEvent();
            } else {
                this.ioObject.addHandle(this.handle);
                this.handleValid = true;
                this.ioObject.setPollConnect(this.handle);
                this.socket.eventConnectDelayed(this.address.toString(), -1);
            }
        }
        catch (IOException e) {
            if (this.handle != null) {
                this.close();
            }
            this.addreconnectTimer();
        }
    }

    private void addreconnectTimer() {
        int rcIvl = this.getNewReconnectIvl();
        this.ioObject.addTimer(rcIvl, 1);
        try {
            this.address.resolve();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.socket.eventConnectRetried(this.address.toString(), rcIvl);
        this.timerStarted = true;
    }

    private int getNewReconnectIvl() {
        int thisInterval = this.currentReconnectIvl + Utils.generateRandom() % this.options.reconnectIvl;
        if (this.options.reconnectIvlMax > 0 && this.options.reconnectIvlMax > this.options.reconnectIvl) {
            this.currentReconnectIvl *= 2;
            if (this.currentReconnectIvl >= this.options.reconnectIvlMax) {
                this.currentReconnectIvl = this.options.reconnectIvlMax;
            }
        }
        return thisInterval;
    }

    private boolean open() throws IOException {
        assert (this.handle == null);
        this.handle = SocketChannel.open();
        Utils.unblockSocket(this.handle);
        if (this.addr == null) {
            throw new IOException("Null address");
        }
        Address.IZAddress resolved = this.addr.resolved();
        if (resolved == null) {
            throw new IOException("Address not resolved");
        }
        SocketAddress sa = resolved.address();
        if (sa == null) {
            throw new IOException("Socket address not resolved");
        }
        boolean rc = false;
        try {
            rc = this.handle.connect(sa);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e.getMessage(), e);
        }
        return rc;
    }

    private SocketChannel connect() throws IOException {
        boolean finished = this.handle.finishConnect();
        assert (finished);
        SocketChannel ret = this.handle;
        return ret;
    }

    private void close() {
        assert (this.handle != null);
        try {
            this.handle.close();
            this.socket.eventClosed(this.address.toString(), this.handle);
        }
        catch (IOException e) {
            this.socket.eventCloseFailed(this.address.toString(), ZError.exccode(e));
        }
        this.handle = null;
    }

    public String toString() {
        return super.toString() + "[" + this.options.socketId + "]";
    }
}

