/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import zmq.Address;
import zmq.Ctx;
import zmq.Dealer;
import zmq.IOThread;
import zmq.Msg;
import zmq.Options;
import zmq.SocketBase;

public class Req
extends Dealer {
    private boolean receivingReply = false;
    private boolean messageBegins = true;

    public Req(Ctx parent2, int tid, int sid) {
        super(parent2, tid, sid);
        this.options.type = 3;
    }

    @Override
    public boolean xsend(Msg msg) {
        boolean rc;
        if (this.receivingReply) {
            this.errno.set(156384763);
            return false;
        }
        if (this.messageBegins) {
            Msg bottom = new Msg();
            bottom.setFlags(1);
            rc = super.xsend(bottom);
            if (!rc) {
                return rc;
            }
            this.messageBegins = false;
        }
        boolean more = msg.hasMore();
        rc = super.xsend(msg);
        if (!rc) {
            return rc;
        }
        if (!more) {
            this.receivingReply = true;
            this.messageBegins = true;
        }
        return true;
    }

    @Override
    protected Msg xrecv() {
        if (!this.receivingReply) {
            this.errno.set(156384763);
            return null;
        }
        Msg msg = null;
        if (this.messageBegins) {
            msg = super.xrecv();
            if (msg == null) {
                return null;
            }
            if (!msg.hasMore() || msg.size() != 0) {
                do {
                    msg = super.xrecv();
                    assert (msg != null);
                } while (msg.hasMore());
                this.errno.set(35);
                return null;
            }
            this.messageBegins = false;
        }
        if ((msg = super.xrecv()) == null) {
            return null;
        }
        if (!msg.hasMore()) {
            this.receivingReply = false;
            this.messageBegins = true;
        }
        return msg;
    }

    @Override
    public boolean xhasIn() {
        return this.receivingReply && super.xhasIn();
    }

    @Override
    public boolean xhasOut() {
        return !this.receivingReply && super.xhasOut();
    }

    public static class ReqSession
    extends Dealer.DealerSession {
        private State state = State.IDENTITY;

        public ReqSession(IOThread ioThread, boolean connect, SocketBase socket, Options options2, Address addr) {
            super(ioThread, connect, socket, options2, addr);
        }

        @Override
        public int pushMsg(Msg msg) {
            switch (this.state) {
                case BOTTOM: {
                    if (!msg.hasMore() || msg.size() != 0) break;
                    this.state = State.BODY;
                    return super.pushMsg(msg);
                }
                case BODY: {
                    if (msg.hasMore()) {
                        return super.pushMsg(msg);
                    }
                    if (msg.flags() != 0) break;
                    this.state = State.BOTTOM;
                    return super.pushMsg(msg);
                }
                case IDENTITY: {
                    if (msg.flags() != 0) break;
                    this.state = State.BOTTOM;
                    return super.pushMsg(msg);
                }
            }
            this.socket.errno.set(14);
            return -1;
        }

        @Override
        public void reset() {
            super.reset();
            this.state = State.IDENTITY;
        }

        static enum State {
            IDENTITY,
            BOTTOM,
            BODY;

        }
    }
}

