/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import zmq.Address;

public class IpcAddress
implements Address.IZAddress {
    private String name;
    private InetSocketAddress address;

    @Override
    public String toString() {
        if (this.name == null) {
            return "";
        }
        return "ipc://" + this.name;
    }

    @Override
    public void resolve(String name, boolean ip4only) {
        this.name = name;
        int hash2 = name.hashCode();
        if (hash2 < 0) {
            hash2 = -hash2;
        }
        hash2 %= 55536;
        hash2 += 10000;
        try {
            this.address = new InetSocketAddress(InetAddress.getByName(null), hash2);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public SocketAddress address() {
        return this.address;
    }
}

