/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.nio.channels.SelectableChannel;
import zmq.IOThread;
import zmq.IPollEvents;
import zmq.Poller;

public class IOObject
implements IPollEvents {
    private Poller poller;
    private IPollEvents handler;

    public IOObject(IOThread ioThread) {
        if (ioThread != null) {
            this.plug(ioThread);
        }
    }

    public void plug(IOThread ioThread) {
        assert (ioThread != null);
        assert (this.poller == null);
        this.poller = ioThread.getPoller();
    }

    public void unplug() {
        assert (this.poller != null);
        this.poller = null;
        this.handler = null;
    }

    public final void addHandle(SelectableChannel handle2) {
        this.poller.addHandle(handle2, this);
    }

    public final void removeHandle(SelectableChannel handle2) {
        this.poller.removeHandle(handle2);
    }

    public final void setPollIn(SelectableChannel handle2) {
        this.poller.setPollIn(handle2);
    }

    public final void setPollOut(SelectableChannel handle2) {
        this.poller.setPollOut(handle2);
    }

    public final void setPollConnect(SelectableChannel handle2) {
        this.poller.setPollConnect(handle2);
    }

    public final void setPollAccept(SelectableChannel handle2) {
        this.poller.setPollAccept(handle2);
    }

    public final void resetPollIn(SelectableChannel handle2) {
        this.poller.resetPollOn(handle2);
    }

    public final void resetPollOut(SelectableChannel handle2) {
        this.poller.resetPollOut(handle2);
    }

    @Override
    public final void inEvent() {
        this.handler.inEvent();
    }

    @Override
    public final void outEvent() {
        this.handler.outEvent();
    }

    @Override
    public final void connectEvent() {
        this.handler.connectEvent();
    }

    @Override
    public final void acceptEvent() {
        this.handler.acceptEvent();
    }

    @Override
    public final void timerEvent(int id2) {
        this.handler.timerEvent(id2);
    }

    public final void addTimer(long timeout, int id2) {
        this.poller.addTimer(timeout, this, id2);
    }

    public final void setHandler(IPollEvents handler) {
        this.handler = handler;
    }

    public void cancelTimer(int id2) {
        this.poller.cancelTimer(this, id2);
    }
}

