/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import zmq.IEncoder;
import zmq.Msg;
import zmq.Transfer;

public abstract class EncoderBase
implements IEncoder {
    private ByteBuffer writeBuf;
    private FileChannel writeChannel;
    private int writePos;
    private int next;
    private boolean beginning;
    private int toWrite;
    private ByteBuffer buffer;
    private int bufferSize;
    private boolean error;

    protected EncoderBase(int bufferSize) {
        this.bufferSize = bufferSize;
        this.buffer = ByteBuffer.allocateDirect(bufferSize);
        this.error = false;
    }

    @Override
    public Transfer getData(ByteBuffer buffer2) {
        if (buffer2 == null) {
            buffer2 = this.buffer;
        }
        buffer2.clear();
        while (buffer2.hasRemaining() && (this.toWrite != 0 || this.next())) {
            if (this.writeChannel != null) {
                buffer2.flip();
                Transfer.FileChannelTransfer t = new Transfer.FileChannelTransfer(buffer2, this.writeChannel, this.writePos, this.toWrite);
                this.writePos = 0;
                this.toWrite = 0;
                return t;
            }
            if (this.buffer.position() == 0 && this.toWrite >= this.bufferSize) {
                Transfer.ByteBufferTransfer t = new Transfer.ByteBufferTransfer(this.writeBuf);
                this.writePos = 0;
                this.toWrite = 0;
                return t;
            }
            int remaining = buffer2.remaining();
            if (this.toWrite <= remaining) {
                buffer2.put(this.writeBuf);
                this.writePos = 0;
                this.toWrite = 0;
                continue;
            }
            this.writeBuf.limit(this.writePos + remaining);
            buffer2.put(this.writeBuf);
            this.writePos += remaining;
            this.toWrite -= remaining;
            this.writeBuf.limit(this.writePos + this.toWrite);
        }
        buffer2.flip();
        return new Transfer.ByteBufferTransfer(buffer2);
    }

    @Override
    public boolean hasData() {
        return this.toWrite > 0;
    }

    protected int state() {
        return this.next;
    }

    protected void state(int state2) {
        this.next = state2;
    }

    protected void encodingError() {
        this.error = true;
    }

    public final boolean isError() {
        return this.error;
    }

    protected abstract boolean next();

    protected void nextStep(Msg msg, int state2, boolean beginning) {
        if (msg == null) {
            this.nextStep(null, 0, state2, beginning);
        } else {
            this.nextStep(msg.buf(), state2, beginning);
        }
    }

    protected void nextStep(byte[] buf, int toWrite, int next2, boolean beginning) {
        if (buf != null) {
            this.writeBuf = ByteBuffer.wrap(buf);
            this.writeBuf.limit(toWrite);
        } else {
            this.writeBuf = null;
        }
        this.writeChannel = null;
        this.writePos = 0;
        this.toWrite = toWrite;
        this.next = next2;
        this.beginning = beginning;
    }

    protected void nextStep(ByteBuffer buf, int next2, boolean beginning) {
        this.writeBuf = buf;
        this.writeChannel = null;
        this.writePos = buf.position();
        this.toWrite = buf.remaining();
        this.next = next2;
        this.beginning = beginning;
    }

    protected void nextStep(FileChannel ch, long pos, long toWrite, int next2, boolean beginning) {
        this.writeBuf = null;
        this.writeChannel = ch;
        this.writePos = (int)pos;
        this.toWrite = (int)toWrite;
        this.next = next2;
        this.beginning = beginning;
    }
}

