/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.nio.ByteBuffer;
import zmq.IDecoder;
import zmq.Msg;
import zmq.MsgAllocator;
import zmq.MsgAllocatorHeap;

public abstract class DecoderBase
implements IDecoder {
    private ByteBuffer readBuf;
    private MsgAllocator msgAllocator = new MsgAllocatorHeap();
    private int bufsize;
    private ByteBuffer buf;
    private int state = -1;
    boolean zeroCopy;

    public DecoderBase(int bufsize) {
        this.bufsize = bufsize;
        if (bufsize > 0) {
            this.buf = ByteBuffer.allocateDirect(bufsize);
        }
        this.readBuf = null;
        this.zeroCopy = false;
    }

    @Override
    public ByteBuffer getBuffer() {
        if (this.readBuf.remaining() >= this.bufsize) {
            this.zeroCopy = true;
            return this.readBuf.duplicate();
        }
        this.zeroCopy = false;
        this.buf.clear();
        return this.buf;
    }

    @Override
    public int processBuffer(ByteBuffer buf, int size2) {
        if (this.state() < 0) {
            return -1;
        }
        if (this.zeroCopy) {
            this.readBuf.position(this.readBuf.position() + size2);
            while (this.readBuf.remaining() == 0) {
                if (this.next()) continue;
                if (this.state() < 0) {
                    return -1;
                }
                return size2;
            }
            return size2;
        }
        int pos = 0;
        while (true) {
            if (this.readBuf.remaining() == 0) {
                if (this.next()) continue;
                if (this.state() < 0) {
                    return -1;
                }
                return pos;
            }
            if (pos == size2) {
                return pos;
            }
            int toCopy = Math.min(this.readBuf.remaining(), size2 - pos);
            int limit2 = buf.limit();
            buf.limit(buf.position() + toCopy);
            this.readBuf.put(buf);
            buf.limit(limit2);
            pos += toCopy;
        }
    }

    protected void nextStep(Msg msg, int state2) {
        this.nextStep(msg.buf(), state2);
    }

    protected void nextStep(byte[] buf, int toRead, int state2) {
        this.readBuf = ByteBuffer.wrap(buf);
        this.readBuf.limit(toRead);
        this.state = state2;
    }

    protected void nextStep(ByteBuffer buf, int state2) {
        this.readBuf = buf;
        this.state = state2;
    }

    protected int state() {
        return this.state;
    }

    protected void state(int state2) {
        this.state = state2;
    }

    protected void decodingError() {
        this.state(-1);
    }

    @Override
    public boolean stalled() {
        if (!this.next()) {
            return false;
        }
        while (this.readBuf.remaining() == 0) {
            if (this.next()) continue;
            return this.next();
        }
        return false;
    }

    public MsgAllocator getMsgAllocator() {
        return this.msgAllocator;
    }

    public void setMsgAllocator(MsgAllocator msgAllocator) {
        this.msgAllocator = msgAllocator;
    }

    protected abstract boolean next();
}

