/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import java.io.Closeable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.zeromq.ZMQ;
import zmq.ZError;

public class ZContext
implements Closeable {
    private volatile ZMQ.Context context;
    private List<ZMQ.Socket> sockets = new CopyOnWriteArrayList<ZMQ.Socket>();
    private int ioThreads;
    private int linger;
    private int hwm;
    private boolean main;

    public ZContext() {
        this(1);
    }

    public ZContext(int ioThreads) {
        this.ioThreads = ioThreads;
        this.linger = 0;
        this.main = true;
    }

    public void destroy() {
        for (ZMQ.Socket socket : this.sockets) {
            try {
                socket.setLinger(this.linger);
            }
            catch (ZError.CtxTerminatedException ctxTerminatedException) {
                // empty catch block
            }
            socket.close();
        }
        this.sockets.clear();
        if (this.isMain() && this.context != null) {
            this.context.term();
        }
        this.context = null;
    }

    public ZMQ.Socket createSocket(int type) {
        ZMQ.Socket socket = this.getContext().socket(type);
        this.sockets.add(socket);
        return socket;
    }

    public void destroySocket(ZMQ.Socket s) {
        if (s == null) {
            return;
        }
        if (this.sockets.remove(s)) {
            try {
                s.setLinger(this.linger);
            }
            catch (ZError.CtxTerminatedException ctxTerminatedException) {
                // empty catch block
            }
            s.close();
        }
    }

    public static ZContext shadow(ZContext ctx) {
        ZContext shadow = new ZContext();
        shadow.setContext(ctx.getContext());
        shadow.setMain(false);
        return shadow;
    }

    public int getIoThreads() {
        return this.ioThreads;
    }

    public void setIoThreads(int ioThreads) {
        this.ioThreads = ioThreads;
    }

    public int getLinger() {
        return this.linger;
    }

    public void setLinger(int linger) {
        this.linger = linger;
    }

    public int getHWM() {
        return this.hwm;
    }

    public void setHWM(int hwm) {
        this.hwm = hwm;
    }

    public boolean isMain() {
        return this.main;
    }

    public void setMain(boolean main) {
        this.main = main;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZMQ.Context getContext() {
        ZMQ.Context result2 = this.context;
        if (result2 == null) {
            ZContext zContext = this;
            synchronized (zContext) {
                result2 = this.context;
                if (result2 == null) {
                    this.context = result2 = ZMQ.context(this.ioThreads);
                }
            }
        }
        return result2;
    }

    public void setContext(ZMQ.Context ctx) {
        this.context = ctx;
    }

    public List<ZMQ.Socket> getSockets() {
        return this.sockets;
    }

    @Override
    public void close() {
        this.destroy();
    }
}

