/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.xml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.util.Assert;
import org.springframework.util.xml.DomContentHandler;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;

public abstract class DomUtils {
    public static List<Element> getChildElementsByTagName(Element ele, String ... childEleNames) {
        Assert.notNull(ele, "Element must not be null");
        Assert.notNull(childEleNames, "Element names collection must not be null");
        List<String> childEleNameList = Arrays.asList(childEleNames);
        NodeList nl = ele.getChildNodes();
        ArrayList<Element> childEles = new ArrayList<Element>();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node4 = nl.item(i);
            if (!(node4 instanceof Element) || !DomUtils.nodeNameMatch(node4, childEleNameList)) continue;
            childEles.add((Element)node4);
        }
        return childEles;
    }

    public static List<Element> getChildElementsByTagName(Element ele, String childEleName) {
        return DomUtils.getChildElementsByTagName(ele, new String[]{childEleName});
    }

    public static Element getChildElementByTagName(Element ele, String childEleName) {
        Assert.notNull(ele, "Element must not be null");
        Assert.notNull(childEleName, "Element name must not be null");
        NodeList nl = ele.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node4 = nl.item(i);
            if (!(node4 instanceof Element) || !DomUtils.nodeNameMatch(node4, childEleName)) continue;
            return (Element)node4;
        }
        return null;
    }

    public static String getChildElementValueByTagName(Element ele, String childEleName) {
        Element child = DomUtils.getChildElementByTagName(ele, childEleName);
        return child != null ? DomUtils.getTextValue(child) : null;
    }

    public static List<Element> getChildElements(Element ele) {
        Assert.notNull(ele, "Element must not be null");
        NodeList nl = ele.getChildNodes();
        ArrayList<Element> childEles = new ArrayList<Element>();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node4 = nl.item(i);
            if (!(node4 instanceof Element)) continue;
            childEles.add((Element)node4);
        }
        return childEles;
    }

    public static String getTextValue(Element valueEle) {
        Assert.notNull(valueEle, "Element must not be null");
        StringBuilder sb = new StringBuilder();
        NodeList nl = valueEle.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node item = nl.item(i);
            if ((!(item instanceof CharacterData) || item instanceof Comment) && !(item instanceof EntityReference)) continue;
            sb.append(item.getNodeValue());
        }
        return sb.toString();
    }

    public static boolean nodeNameEquals(Node node4, String desiredName) {
        Assert.notNull(node4, "Node must not be null");
        Assert.notNull(desiredName, "Desired name must not be null");
        return DomUtils.nodeNameMatch(node4, desiredName);
    }

    public static ContentHandler createContentHandler(Node node4) {
        return new DomContentHandler(node4);
    }

    private static boolean nodeNameMatch(Node node4, String desiredName) {
        return desiredName.equals(node4.getNodeName()) || desiredName.equals(node4.getLocalName());
    }

    private static boolean nodeNameMatch(Node node4, Collection<?> desiredNames) {
        return desiredNames.contains(node4.getNodeName()) || desiredNames.contains(node4.getLocalName());
    }
}

