/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.util.Assert;
import org.springframework.util.concurrent.FailureCallback;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;
import org.springframework.util.concurrent.ListenableFutureTask;
import org.springframework.util.concurrent.SuccessCallback;

public class SettableListenableFuture<T>
implements ListenableFuture<T> {
    private final SettableTask<T> settableTask = new SettableTask();
    private final ListenableFutureTask<T> listenableFuture = new ListenableFutureTask<T>(this.settableTask);

    public boolean set(T value2) {
        boolean success2 = this.settableTask.setValue(value2);
        if (success2) {
            this.listenableFuture.run();
        }
        return success2;
    }

    public boolean setException(Throwable exception) {
        Assert.notNull(exception, "'exception' must not be null");
        boolean success2 = this.settableTask.setException(exception);
        if (success2) {
            this.listenableFuture.run();
        }
        return success2;
    }

    @Override
    public void addCallback(ListenableFutureCallback<? super T> callback) {
        this.listenableFuture.addCallback(callback);
    }

    @Override
    public void addCallback(SuccessCallback<? super T> successCallback, FailureCallback failureCallback) {
        this.listenableFuture.addCallback(successCallback, failureCallback);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.settableTask.setCancelled();
        boolean cancelled = this.listenableFuture.cancel(mayInterruptIfRunning);
        if (cancelled && mayInterruptIfRunning) {
            this.interruptTask();
        }
        return cancelled;
    }

    @Override
    public boolean isCancelled() {
        return this.listenableFuture.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.listenableFuture.isDone();
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        return (T)this.listenableFuture.get();
    }

    @Override
    public T get(long timeout, TimeUnit unit2) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)this.listenableFuture.get(timeout, unit2);
    }

    protected void interruptTask() {
    }

    private static class SettableTask<T>
    implements Callable<T> {
        private static final String NO_VALUE = SettableListenableFuture.class.getName() + ".NO_VALUE";
        private final AtomicReference<Object> value = new AtomicReference<String>(NO_VALUE);
        private volatile boolean cancelled = false;

        private SettableTask() {
        }

        public boolean setValue(T value2) {
            if (this.cancelled) {
                return false;
            }
            return this.value.compareAndSet(NO_VALUE, value2);
        }

        public boolean setException(Throwable exception) {
            if (this.cancelled) {
                return false;
            }
            return this.value.compareAndSet(NO_VALUE, exception);
        }

        public void setCancelled() {
            this.cancelled = true;
        }

        @Override
        public T call() throws Exception {
            if (this.value.get() instanceof Exception) {
                throw (Exception)this.value.get();
            }
            return (T)this.value.get();
        }
    }
}

