/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.concurrent;

import java.util.LinkedList;
import java.util.Queue;
import org.springframework.util.Assert;
import org.springframework.util.concurrent.FailureCallback;
import org.springframework.util.concurrent.ListenableFutureCallback;
import org.springframework.util.concurrent.SuccessCallback;

public class ListenableFutureCallbackRegistry<T> {
    private final Queue<SuccessCallback<? super T>> successCallbacks = new LinkedList<SuccessCallback<? super T>>();
    private final Queue<FailureCallback> failureCallbacks = new LinkedList<FailureCallback>();
    private State state = State.NEW;
    private Object result = null;
    private final Object mutex = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCallback(ListenableFutureCallback<? super T> callback) {
        Assert.notNull(callback, "'callback' must not be null");
        Object object = this.mutex;
        synchronized (object) {
            switch (this.state) {
                case NEW: {
                    this.successCallbacks.add(callback);
                    this.failureCallbacks.add(callback);
                    break;
                }
                case SUCCESS: {
                    callback.onSuccess(this.result);
                    break;
                }
                case FAILURE: {
                    callback.onFailure((Throwable)this.result);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSuccessCallback(SuccessCallback<? super T> callback) {
        Assert.notNull(callback, "'callback' must not be null");
        Object object = this.mutex;
        synchronized (object) {
            switch (this.state) {
                case NEW: {
                    this.successCallbacks.add(callback);
                    break;
                }
                case SUCCESS: {
                    callback.onSuccess(this.result);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFailureCallback(FailureCallback callback) {
        Assert.notNull(callback, "'callback' must not be null");
        Object object = this.mutex;
        synchronized (object) {
            switch (this.state) {
                case NEW: {
                    this.failureCallbacks.add(callback);
                    break;
                }
                case FAILURE: {
                    callback.onFailure((Throwable)this.result);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void success(T result2) {
        Object object = this.mutex;
        synchronized (object) {
            this.state = State.SUCCESS;
            this.result = result2;
            while (!this.successCallbacks.isEmpty()) {
                this.successCallbacks.poll().onSuccess(result2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failure(Throwable ex) {
        Object object = this.mutex;
        synchronized (object) {
            this.state = State.FAILURE;
            this.result = ex;
            while (!this.failureCallbacks.isEmpty()) {
                this.failureCallbacks.poll().onFailure(ex);
            }
        }
    }

    private static enum State {
        NEW,
        SUCCESS,
        FAILURE;

    }
}

