/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.concurrent;

import java.util.concurrent.ExecutionException;
import org.springframework.util.concurrent.FailureCallback;
import org.springframework.util.concurrent.FutureAdapter;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;
import org.springframework.util.concurrent.SuccessCallback;

public abstract class ListenableFutureAdapter<T, S>
extends FutureAdapter<T, S>
implements ListenableFuture<T> {
    protected ListenableFutureAdapter(ListenableFuture<S> adaptee) {
        super(adaptee);
    }

    @Override
    public void addCallback(ListenableFutureCallback<? super T> callback) {
        this.addCallback(callback, callback);
    }

    @Override
    public void addCallback(final SuccessCallback<? super T> successCallback, final FailureCallback failureCallback) {
        ListenableFuture listenableAdaptee = (ListenableFuture)this.getAdaptee();
        listenableAdaptee.addCallback(new ListenableFutureCallback<S>(){

            @Override
            public void onSuccess(S result2) {
                try {
                    successCallback.onSuccess(ListenableFutureAdapter.this.adaptInternal(result2));
                }
                catch (ExecutionException ex) {
                    Throwable cause = ex.getCause();
                    this.onFailure(cause != null ? cause : ex);
                }
                catch (Throwable t) {
                    this.onFailure(t);
                }
            }

            @Override
            public void onFailure(Throwable ex) {
                failureCallback.onFailure(ex);
            }
        });
    }
}

