/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.springframework.util.Assert;

public abstract class StreamUtils {
    public static final int BUFFER_SIZE = 4096;

    public static byte[] copyToByteArray(InputStream in2) throws IOException {
        ByteArrayOutputStream out2 = new ByteArrayOutputStream(4096);
        StreamUtils.copy(in2, (OutputStream)out2);
        return out2.toByteArray();
    }

    public static String copyToString(InputStream in2, Charset charset) throws IOException {
        Assert.notNull(in2, "No InputStream specified");
        StringBuilder out2 = new StringBuilder();
        InputStreamReader reader = new InputStreamReader(in2, charset);
        char[] buffer2 = new char[4096];
        int bytesRead = -1;
        while ((bytesRead = reader.read(buffer2)) != -1) {
            out2.append(buffer2, 0, bytesRead);
        }
        return out2.toString();
    }

    public static void copy(byte[] in2, OutputStream out2) throws IOException {
        Assert.notNull(in2, "No input byte array specified");
        Assert.notNull(out2, "No OutputStream specified");
        out2.write(in2);
    }

    public static void copy(String in2, Charset charset, OutputStream out2) throws IOException {
        Assert.notNull(in2, "No input String specified");
        Assert.notNull(charset, "No charset specified");
        Assert.notNull(out2, "No OutputStream specified");
        OutputStreamWriter writer2 = new OutputStreamWriter(out2, charset);
        writer2.write(in2);
        ((Writer)writer2).flush();
    }

    public static int copy(InputStream in2, OutputStream out2) throws IOException {
        Assert.notNull(in2, "No InputStream specified");
        Assert.notNull(out2, "No OutputStream specified");
        int byteCount = 0;
        byte[] buffer2 = new byte[4096];
        int bytesRead = -1;
        while ((bytesRead = in2.read(buffer2)) != -1) {
            out2.write(buffer2, 0, bytesRead);
            byteCount += bytesRead;
        }
        out2.flush();
        return byteCount;
    }

    public static InputStream nonClosing(InputStream in2) {
        Assert.notNull(in2, "No InputStream specified");
        return new NonClosingInputStream(in2);
    }

    public static OutputStream nonClosing(OutputStream out2) {
        Assert.notNull(out2, "No OutputStream specified");
        return new NonClosingOutputStream(out2);
    }

    private static class NonClosingOutputStream
    extends FilterOutputStream {
        public NonClosingOutputStream(OutputStream out2) {
            super(out2);
        }

        @Override
        public void write(byte[] b2, int off, int let) throws IOException {
            this.out.write(b2, off, let);
        }

        @Override
        public void close() throws IOException {
        }
    }

    private static class NonClosingInputStream
    extends FilterInputStream {
        public NonClosingInputStream(InputStream in2) {
            super(in2);
        }

        @Override
        public void close() throws IOException {
        }
    }
}

