/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;

public abstract class FileCopyUtils {
    public static final int BUFFER_SIZE = 4096;

    public static int copy(File in2, File out2) throws IOException {
        Assert.notNull(in2, "No input File specified");
        Assert.notNull(out2, "No output File specified");
        return FileCopyUtils.copy(new BufferedInputStream(new FileInputStream(in2)), (OutputStream)new BufferedOutputStream(new FileOutputStream(out2)));
    }

    public static void copy(byte[] in2, File out2) throws IOException {
        Assert.notNull(in2, "No input byte array specified");
        Assert.notNull(out2, "No output File specified");
        ByteArrayInputStream inStream = new ByteArrayInputStream(in2);
        BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(out2));
        FileCopyUtils.copy(inStream, (OutputStream)outStream);
    }

    public static byte[] copyToByteArray(File in2) throws IOException {
        Assert.notNull(in2, "No input File specified");
        return FileCopyUtils.copyToByteArray(new BufferedInputStream(new FileInputStream(in2)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(InputStream in2, OutputStream out2) throws IOException {
        Assert.notNull(in2, "No InputStream specified");
        Assert.notNull(out2, "No OutputStream specified");
        try {
            int n = StreamUtils.copy(in2, out2);
            return n;
        }
        finally {
            try {
                in2.close();
            }
            catch (IOException ex) {}
            try {
                out2.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void copy(byte[] in2, OutputStream out2) throws IOException {
        Assert.notNull(in2, "No input byte array specified");
        Assert.notNull(out2, "No OutputStream specified");
        try {
            out2.write(in2);
        }
        finally {
            try {
                out2.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static byte[] copyToByteArray(InputStream in2) throws IOException {
        ByteArrayOutputStream out2 = new ByteArrayOutputStream(4096);
        FileCopyUtils.copy(in2, (OutputStream)out2);
        return out2.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(Reader in2, Writer out2) throws IOException {
        Assert.notNull(in2, "No Reader specified");
        Assert.notNull(out2, "No Writer specified");
        try {
            int byteCount = 0;
            char[] buffer2 = new char[4096];
            int bytesRead = -1;
            while ((bytesRead = in2.read(buffer2)) != -1) {
                out2.write(buffer2, 0, bytesRead);
                byteCount += bytesRead;
            }
            out2.flush();
            int n = byteCount;
            return n;
        }
        finally {
            try {
                in2.close();
            }
            catch (IOException ex) {}
            try {
                out2.close();
            }
            catch (IOException ex) {}
        }
    }

    public static void copy(String in2, Writer out2) throws IOException {
        Assert.notNull(in2, "No input String specified");
        Assert.notNull(out2, "No Writer specified");
        try {
            out2.write(in2);
        }
        finally {
            try {
                out2.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static String copyToString(Reader in2) throws IOException {
        StringWriter out2 = new StringWriter();
        FileCopyUtils.copy(in2, (Writer)out2);
        return out2.toString();
    }
}

