/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type.classreading;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.asm.Type;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.util.LinkedMultiValueMap;

abstract class AnnotationReadingVisitorUtils {
    AnnotationReadingVisitorUtils() {
    }

    public static AnnotationAttributes convertClassValues(ClassLoader classLoader, AnnotationAttributes original, boolean classValuesAsString) {
        if (original == null) {
            return null;
        }
        AnnotationAttributes result2 = new AnnotationAttributes(original.size());
        for (Map.Entry entry : original.entrySet()) {
            try {
                int i;
                Object value2 = entry.getValue();
                if (value2 instanceof AnnotationAttributes) {
                    value2 = AnnotationReadingVisitorUtils.convertClassValues(classLoader, (AnnotationAttributes)value2, classValuesAsString);
                } else if (value2 instanceof AnnotationAttributes[]) {
                    AnnotationAttributes[] values2 = (AnnotationAttributes[])value2;
                    for (int i2 = 0; i2 < values2.length; ++i2) {
                        values2[i2] = AnnotationReadingVisitorUtils.convertClassValues(classLoader, values2[i2], classValuesAsString);
                    }
                } else if (value2 instanceof Type) {
                    value2 = classValuesAsString ? ((Type)value2).getClassName() : classLoader.loadClass(((Type)value2).getClassName());
                } else if (value2 instanceof Type[]) {
                    Type[] array = (Type[])value2;
                    Object[] convArray = classValuesAsString ? new String[array.length] : new Class[array.length];
                    for (i = 0; i < array.length; ++i) {
                        convArray[i] = classValuesAsString ? array[i].getClassName() : classLoader.loadClass(array[i].getClassName());
                    }
                    value2 = convArray;
                } else if (classValuesAsString) {
                    if (value2 instanceof Class) {
                        value2 = ((Class)value2).getName();
                    } else if (value2 instanceof Class[]) {
                        Class[] clazzArray = (Class[])value2;
                        String[] newValue = new String[clazzArray.length];
                        for (i = 0; i < clazzArray.length; ++i) {
                            newValue[i] = clazzArray[i].getName();
                        }
                        value2 = newValue;
                    }
                }
                result2.put(entry.getKey(), value2);
            }
            catch (Exception ex) {}
        }
        return result2;
    }

    public static AnnotationAttributes getMergedAnnotationAttributes(LinkedMultiValueMap<String, AnnotationAttributes> attributesMap2, Map<String, Set<String>> metaAnnotationMap, String annotationType) {
        Object attributesList = attributesMap2.get(annotationType);
        if (attributesList == null || attributesList.isEmpty()) {
            return null;
        }
        AnnotationAttributes results = new AnnotationAttributes((Map)attributesList.get(0));
        HashSet overridableAttributeNames = new HashSet(results.keySet());
        overridableAttributeNames.remove("value");
        ArrayList<String> annotationTypes = new ArrayList<String>(attributesMap2.keySet());
        Collections.reverse(annotationTypes);
        annotationTypes.remove(annotationType);
        for (String currentAnnotationType : annotationTypes) {
            Set<String> metaAnns;
            Object currentAttributesList = attributesMap2.get(currentAnnotationType);
            if (currentAttributesList == null || currentAttributesList.isEmpty() || (metaAnns = metaAnnotationMap.get(currentAnnotationType)) == null || !metaAnns.contains(annotationType)) continue;
            AnnotationAttributes currentAttributes = (AnnotationAttributes)currentAttributesList.get(0);
            for (String overridableAttributeName : overridableAttributeNames) {
                Object value2 = currentAttributes.get(overridableAttributeName);
                if (value2 == null) continue;
                results.put(overridableAttributeName, value2);
            }
        }
        return results;
    }
}

