/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type.classreading;

import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.type.classreading.RecursiveAnnotationAttributesVisitor;
import org.springframework.util.MultiValueMap;

final class AnnotationAttributesReadingVisitor
extends RecursiveAnnotationAttributesVisitor {
    private final String annotationType;
    private final MultiValueMap<String, AnnotationAttributes> attributesMap;
    private final Map<String, Set<String>> metaAnnotationMap;

    public AnnotationAttributesReadingVisitor(String annotationType, MultiValueMap<String, AnnotationAttributes> attributesMap2, Map<String, Set<String>> metaAnnotationMap, ClassLoader classLoader) {
        super(annotationType, new AnnotationAttributes(), classLoader);
        this.annotationType = annotationType;
        this.attributesMap = attributesMap2;
        this.metaAnnotationMap = metaAnnotationMap;
    }

    @Override
    public void doVisitEnd(Class<?> annotationClass) {
        super.doVisitEnd(annotationClass);
        List attributes = (List)this.attributesMap.get(this.annotationType);
        if (attributes == null) {
            this.attributesMap.add(this.annotationType, this.attributes);
        } else {
            attributes.add(0, this.attributes);
        }
        LinkedHashSet<String> metaAnnotationTypeNames = new LinkedHashSet<String>();
        for (Annotation metaAnnotation : annotationClass.getAnnotations()) {
            if (AnnotationUtils.isInJavaLangAnnotationPackage(metaAnnotation)) continue;
            this.recursivelyCollectMetaAnnotations(metaAnnotationTypeNames, metaAnnotation);
        }
        if (this.metaAnnotationMap != null) {
            this.metaAnnotationMap.put(annotationClass.getName(), metaAnnotationTypeNames);
        }
    }

    private void recursivelyCollectMetaAnnotations(Set<String> visited, Annotation annotation) {
        String annotationName = annotation.annotationType().getName();
        if (!AnnotationUtils.isInJavaLangAnnotationPackage(annotation) && visited.add(annotationName) && Modifier.isPublic(annotation.annotationType().getModifiers())) {
            this.attributesMap.add(annotationName, AnnotationUtils.getAnnotationAttributes(annotation, false, true));
            for (Annotation metaMetaAnnotation : annotation.annotationType().getAnnotations()) {
                this.recursivelyCollectMetaAnnotations(visited, metaMetaAnnotation);
            }
        }
    }
}

