/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.style;

import org.springframework.core.style.DefaultToStringStyler;
import org.springframework.core.style.StylerUtils;
import org.springframework.core.style.ToStringStyler;
import org.springframework.core.style.ValueStyler;
import org.springframework.util.Assert;

public class ToStringCreator {
    private static final ToStringStyler DEFAULT_TO_STRING_STYLER = new DefaultToStringStyler(StylerUtils.DEFAULT_VALUE_STYLER);
    private final StringBuilder buffer = new StringBuilder(256);
    private final ToStringStyler styler;
    private final Object object;
    private boolean styledFirstField;

    public ToStringCreator(Object obj2) {
        this(obj2, (ToStringStyler)null);
    }

    public ToStringCreator(Object obj2, ValueStyler styler) {
        this(obj2, new DefaultToStringStyler(styler != null ? styler : StylerUtils.DEFAULT_VALUE_STYLER));
    }

    public ToStringCreator(Object obj2, ToStringStyler styler) {
        Assert.notNull(obj2, "The object to be styled must not be null");
        this.object = obj2;
        this.styler = styler != null ? styler : DEFAULT_TO_STRING_STYLER;
        this.styler.styleStart(this.buffer, this.object);
    }

    public ToStringCreator append(String fieldName, byte value2) {
        return this.append(fieldName, new Byte(value2));
    }

    public ToStringCreator append(String fieldName, short value2) {
        return this.append(fieldName, new Short(value2));
    }

    public ToStringCreator append(String fieldName, int value2) {
        return this.append(fieldName, new Integer(value2));
    }

    public ToStringCreator append(String fieldName, long value2) {
        return this.append(fieldName, new Long(value2));
    }

    public ToStringCreator append(String fieldName, float value2) {
        return this.append(fieldName, new Float(value2));
    }

    public ToStringCreator append(String fieldName, double value2) {
        return this.append(fieldName, new Double(value2));
    }

    public ToStringCreator append(String fieldName, boolean value2) {
        return this.append(fieldName, (Object)value2);
    }

    public ToStringCreator append(String fieldName, Object value2) {
        this.printFieldSeparatorIfNecessary();
        this.styler.styleField(this.buffer, fieldName, value2);
        return this;
    }

    private void printFieldSeparatorIfNecessary() {
        if (this.styledFirstField) {
            this.styler.styleFieldSeparator(this.buffer);
        } else {
            this.styledFirstField = true;
        }
    }

    public ToStringCreator append(Object value2) {
        this.styler.styleValue(this.buffer, value2);
        return this;
    }

    public String toString() {
        this.styler.styleEnd(this.buffer, this.object);
        return this.buffer.toString();
    }
}

