/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io.support;

import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.Assert;

public class ResourceArrayPropertyEditor
extends PropertyEditorSupport {
    private static final Log logger = LogFactory.getLog(ResourceArrayPropertyEditor.class);
    private final ResourcePatternResolver resourcePatternResolver;
    private PropertyResolver propertyResolver;
    private final boolean ignoreUnresolvablePlaceholders;

    public ResourceArrayPropertyEditor() {
        this(new PathMatchingResourcePatternResolver(), null, true);
    }

    @Deprecated
    public ResourceArrayPropertyEditor(ResourcePatternResolver resourcePatternResolver) {
        this(resourcePatternResolver, null, true);
    }

    @Deprecated
    public ResourceArrayPropertyEditor(ResourcePatternResolver resourcePatternResolver, boolean ignoreUnresolvablePlaceholders) {
        this(resourcePatternResolver, null, ignoreUnresolvablePlaceholders);
    }

    public ResourceArrayPropertyEditor(ResourcePatternResolver resourcePatternResolver, PropertyResolver propertyResolver) {
        this(resourcePatternResolver, propertyResolver, true);
    }

    public ResourceArrayPropertyEditor(ResourcePatternResolver resourcePatternResolver, PropertyResolver propertyResolver, boolean ignoreUnresolvablePlaceholders) {
        Assert.notNull(resourcePatternResolver, "ResourcePatternResolver must not be null");
        this.resourcePatternResolver = resourcePatternResolver;
        this.propertyResolver = propertyResolver;
        this.ignoreUnresolvablePlaceholders = ignoreUnresolvablePlaceholders;
    }

    @Override
    public void setAsText(String text2) {
        String pattern2 = this.resolvePath(text2).trim();
        try {
            this.setValue(this.resourcePatternResolver.getResources(pattern2));
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Could not resolve resource location pattern [" + pattern2 + "]: " + ex.getMessage());
        }
    }

    @Override
    public void setValue(Object value2) throws IllegalArgumentException {
        if (value2 instanceof Collection || value2 instanceof Object[] && !(value2 instanceof Resource[])) {
            List<Object> input = value2 instanceof Collection ? (List<Object>)value2 : Arrays.asList((Object[])value2);
            ArrayList<Resource> merged = new ArrayList<Resource>();
            for (Object e : input) {
                if (e instanceof String) {
                    String pattern2 = this.resolvePath((String)e).trim();
                    try {
                        Resource[] resources;
                        for (Resource resource : resources = this.resourcePatternResolver.getResources(pattern2)) {
                            if (merged.contains(resource)) continue;
                            merged.add(resource);
                        }
                        continue;
                    }
                    catch (IOException ex) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("Could not retrieve resources for pattern '" + pattern2 + "'", ex);
                        continue;
                    }
                }
                if (e instanceof Resource) {
                    Resource resource = (Resource)e;
                    if (merged.contains(resource)) continue;
                    merged.add(resource);
                    continue;
                }
                throw new IllegalArgumentException("Cannot convert element [" + e + "] to [" + Resource.class.getName() + "]: only location String and Resource object supported");
            }
            super.setValue(merged.toArray(new Resource[merged.size()]));
        } else {
            super.setValue(value2);
        }
    }

    protected String resolvePath(String path2) {
        if (this.propertyResolver == null) {
            this.propertyResolver = new StandardEnvironment();
        }
        return this.ignoreUnresolvablePlaceholders ? this.propertyResolver.resolvePlaceholders(path2) : this.propertyResolver.resolveRequiredPlaceholders(path2);
    }
}

