/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.util.ClassUtils;

public abstract class OrderUtils {
    private static final String PRIORITY_ANNOTATION_CLASS_NAME = "javax.annotation.Priority";
    private static final boolean priorityPresent = ClassUtils.isPresent("javax.annotation.Priority", OrderUtils.class.getClassLoader());

    public static Integer getOrder(Class<?> type) {
        return OrderUtils.getOrder(type, null);
    }

    public static Integer getOrder(Class<?> type, Integer defaultOrder) {
        Order order2 = AnnotationUtils.findAnnotation(type, Order.class);
        if (order2 != null) {
            return order2.value();
        }
        Integer priorityOrder = OrderUtils.getPriority(type);
        if (priorityOrder != null) {
            return priorityOrder;
        }
        return defaultOrder;
    }

    public static Integer getPriority(Class<?> type) {
        if (priorityPresent) {
            for (Annotation annotation : type.getAnnotations()) {
                if (!PRIORITY_ANNOTATION_CLASS_NAME.equals(annotation.annotationType().getName())) continue;
                return (Integer)AnnotationUtils.getValue(annotation);
            }
        }
        return null;
    }
}

