/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class AnnotationAttributes
extends LinkedHashMap<String, Object> {
    public AnnotationAttributes() {
    }

    public AnnotationAttributes(int initialCapacity) {
        super(initialCapacity);
    }

    public AnnotationAttributes(Map<String, Object> map2) {
        super(map2);
    }

    public String getString(String attributeName) {
        return this.doGet(attributeName, String.class);
    }

    public String[] getStringArray(String attributeName) {
        return this.doGet(attributeName, String[].class);
    }

    public boolean getBoolean(String attributeName) {
        return this.doGet(attributeName, Boolean.class);
    }

    public <N extends Number> N getNumber(String attributeName) {
        return (N)this.doGet(attributeName, Number.class);
    }

    public <E extends Enum<?>> E getEnum(String attributeName) {
        return (E)this.doGet(attributeName, Enum.class);
    }

    public <T> Class<? extends T> getClass(String attributeName) {
        return this.doGet(attributeName, Class.class);
    }

    public Class<?>[] getClassArray(String attributeName) {
        return this.doGet(attributeName, Class[].class);
    }

    public AnnotationAttributes getAnnotation(String attributeName) {
        return this.doGet(attributeName, AnnotationAttributes.class);
    }

    public AnnotationAttributes[] getAnnotationArray(String attributeName) {
        return this.doGet(attributeName, AnnotationAttributes[].class);
    }

    private <T> T doGet(String attributeName, Class<T> expectedType) {
        Assert.hasText(attributeName, "attributeName must not be null or empty");
        Object value2 = this.get(attributeName);
        Assert.notNull(value2, String.format("Attribute '%s' not found", attributeName));
        if (!expectedType.isInstance(value2)) {
            if (expectedType.isArray() && expectedType.getComponentType().isInstance(value2)) {
                Object arrayValue = Array.newInstance(expectedType.getComponentType(), 1);
                Array.set(arrayValue, 0, value2);
                value2 = arrayValue;
            } else {
                throw new IllegalArgumentException(String.format("Attribute '%s' is of type [%s], but [%s] was expected. Cause: ", attributeName, value2.getClass().getSimpleName(), expectedType.getSimpleName()));
            }
        }
        return (T)value2;
    }

    @Override
    public String toString() {
        Iterator entries = this.entrySet().iterator();
        StringBuilder sb = new StringBuilder("{");
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            sb.append((String)entry.getKey());
            sb.append('=');
            sb.append(this.valueToString(entry.getValue()));
            sb.append(entries.hasNext() ? ", " : "");
        }
        sb.append("}");
        return sb.toString();
    }

    private String valueToString(Object value2) {
        if (value2 == this) {
            return "(this Map)";
        }
        if (value2 instanceof Object[]) {
            return "[" + StringUtils.arrayToCommaDelimitedString((Object[])value2) + "]";
        }
        return String.valueOf(value2);
    }

    public static AnnotationAttributes fromMap(Map<String, Object> map2) {
        if (map2 == null) {
            return null;
        }
        if (map2 instanceof AnnotationAttributes) {
            return (AnnotationAttributes)map2;
        }
        return new AnnotationAttributes(map2);
    }
}

