/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.transform;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.springframework.asm.Attribute;
import org.springframework.asm.ClassReader;
import org.springframework.cglib.core.ClassNameReader;
import org.springframework.cglib.core.DebuggingClassWriter;
import org.springframework.cglib.transform.AbstractProcessTask;
import org.springframework.cglib.transform.ClassReaderGenerator;
import org.springframework.cglib.transform.ClassTransformer;
import org.springframework.cglib.transform.TransformingClassGenerator;

public abstract class AbstractTransformTask
extends AbstractProcessTask {
    private static final int ZIP_MAGIC = 1347093252;
    private static final int CLASS_MAGIC = -889275714;
    private boolean verbose;

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    protected abstract ClassTransformer getClassTransformer(String[] var1);

    protected Attribute[] attributes() {
        return null;
    }

    protected void processFile(File file2) throws Exception {
        if (this.isClassFile(file2)) {
            this.processClassFile(file2);
        } else if (this.isJarFile(file2)) {
            this.processJarFile(file2);
        } else {
            this.log("ignoring " + file2.toURI(), 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processClassFile(File file2) throws Exception, FileNotFoundException, IOException, MalformedURLException {
        ClassReader reader = AbstractTransformTask.getClassReader(file2);
        String[] name = ClassNameReader.getClassInfo(reader);
        DebuggingClassWriter w = new DebuggingClassWriter(1);
        ClassTransformer t = this.getClassTransformer(name);
        if (t != null) {
            if (this.verbose) {
                this.log("processing " + file2.toURI());
            }
            new TransformingClassGenerator(new ClassReaderGenerator(AbstractTransformTask.getClassReader(file2), this.attributes(), this.getFlags()), t).generateClass(w);
            FileOutputStream fos = new FileOutputStream(file2);
            try {
                fos.write(w.toByteArray());
            }
            finally {
                fos.close();
            }
        }
    }

    protected int getFlags() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClassReader getClassReader(File file2) throws Exception {
        BufferedInputStream in2 = new BufferedInputStream(new FileInputStream(file2));
        try {
            ClassReader r;
            ClassReader classReader = r = new ClassReader(in2);
            return classReader;
        }
        finally {
            ((InputStream)in2).close();
        }
    }

    protected boolean isClassFile(File file2) throws IOException {
        return this.checkMagic(file2, -889275714L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processJarFile(File file2) throws Exception {
        block19: {
            if (this.verbose) {
                this.log("processing " + file2.toURI());
            }
            File tempFile = File.createTempFile(file2.getName(), null, new File(file2.getAbsoluteFile().getParent()));
            try {
                ZipInputStream zip2 = new ZipInputStream(new FileInputStream(file2));
                try {
                    FileOutputStream fout = new FileOutputStream(tempFile);
                    try {
                        ZipEntry entry;
                        ZipOutputStream out2 = new ZipOutputStream(fout);
                        while ((entry = zip2.getNextEntry()) != null) {
                            byte[] bytes = this.getBytes(zip2);
                            if (!entry.isDirectory()) {
                                DataInputStream din = new DataInputStream(new ByteArrayInputStream(bytes));
                                if (din.readInt() == -889275714) {
                                    bytes = this.process(bytes);
                                } else if (this.verbose) {
                                    this.log("ignoring " + entry.toString());
                                }
                            }
                            ZipEntry outEntry = new ZipEntry(entry.getName());
                            outEntry.setMethod(entry.getMethod());
                            outEntry.setComment(entry.getComment());
                            outEntry.setSize(bytes.length);
                            if (outEntry.getMethod() == 0) {
                                CRC32 crc = new CRC32();
                                crc.update(bytes);
                                outEntry.setCrc(crc.getValue());
                                outEntry.setCompressedSize(bytes.length);
                            }
                            out2.putNextEntry(outEntry);
                            out2.write(bytes);
                            out2.closeEntry();
                            zip2.closeEntry();
                        }
                        out2.close();
                    }
                    finally {
                        fout.close();
                    }
                }
                finally {
                    zip2.close();
                }
                if (file2.delete()) {
                    File newFile = new File(tempFile.getAbsolutePath());
                    if (!newFile.renameTo(file2)) {
                        throw new IOException("can not rename " + tempFile + " to " + file2);
                    }
                    break block19;
                }
                throw new IOException("can not delete " + file2);
            }
            finally {
                tempFile.delete();
            }
        }
    }

    private byte[] process(byte[] bytes) throws Exception {
        ClassReader reader = new ClassReader(new ByteArrayInputStream(bytes));
        String[] name = ClassNameReader.getClassInfo(reader);
        DebuggingClassWriter w = new DebuggingClassWriter(1);
        ClassTransformer t = this.getClassTransformer(name);
        if (t != null) {
            if (this.verbose) {
                this.log("processing " + name[0]);
            }
            new TransformingClassGenerator(new ClassReaderGenerator(new ClassReader(new ByteArrayInputStream(bytes)), this.attributes(), this.getFlags()), t).generateClass(w);
            ByteArrayOutputStream out2 = new ByteArrayOutputStream();
            out2.write(w.toByteArray());
            return out2.toByteArray();
        }
        return bytes;
    }

    private byte[] getBytes(ZipInputStream zip2) throws IOException {
        int b2;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        BufferedInputStream in2 = new BufferedInputStream(zip2);
        while ((b2 = ((InputStream)in2).read()) != -1) {
            bout.write(b2);
        }
        return bout.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkMagic(File file2, long magic) throws IOException {
        DataInputStream in2 = new DataInputStream(new FileInputStream(file2));
        try {
            int m = in2.readInt();
            boolean bl = magic == (long)m;
            return bl;
        }
        finally {
            in2.close();
        }
    }

    protected boolean isJarFile(File file2) throws IOException {
        return this.checkMagic(file2, 1347093252L);
    }
}

