/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.asm;

public class ByteVector {
    byte[] data;
    int length;

    public ByteVector() {
        this.data = new byte[64];
    }

    public ByteVector(int initialSize) {
        this.data = new byte[initialSize];
    }

    public ByteVector putByte(int b2) {
        int length2 = this.length;
        if (length2 + 1 > this.data.length) {
            this.enlarge(1);
        }
        this.data[length2++] = (byte)b2;
        this.length = length2;
        return this;
    }

    ByteVector put11(int b1, int b2) {
        int length2 = this.length;
        if (length2 + 2 > this.data.length) {
            this.enlarge(2);
        }
        byte[] data = this.data;
        data[length2++] = (byte)b1;
        data[length2++] = (byte)b2;
        this.length = length2;
        return this;
    }

    public ByteVector putShort(int s) {
        int length2 = this.length;
        if (length2 + 2 > this.data.length) {
            this.enlarge(2);
        }
        byte[] data = this.data;
        data[length2++] = (byte)(s >>> 8);
        data[length2++] = (byte)s;
        this.length = length2;
        return this;
    }

    ByteVector put12(int b2, int s) {
        int length2 = this.length;
        if (length2 + 3 > this.data.length) {
            this.enlarge(3);
        }
        byte[] data = this.data;
        data[length2++] = (byte)b2;
        data[length2++] = (byte)(s >>> 8);
        data[length2++] = (byte)s;
        this.length = length2;
        return this;
    }

    public ByteVector putInt(int i) {
        int length2 = this.length;
        if (length2 + 4 > this.data.length) {
            this.enlarge(4);
        }
        byte[] data = this.data;
        data[length2++] = (byte)(i >>> 24);
        data[length2++] = (byte)(i >>> 16);
        data[length2++] = (byte)(i >>> 8);
        data[length2++] = (byte)i;
        this.length = length2;
        return this;
    }

    public ByteVector putLong(long l) {
        int length2 = this.length;
        if (length2 + 8 > this.data.length) {
            this.enlarge(8);
        }
        byte[] data = this.data;
        int i = (int)(l >>> 32);
        data[length2++] = (byte)(i >>> 24);
        data[length2++] = (byte)(i >>> 16);
        data[length2++] = (byte)(i >>> 8);
        data[length2++] = (byte)i;
        i = (int)l;
        data[length2++] = (byte)(i >>> 24);
        data[length2++] = (byte)(i >>> 16);
        data[length2++] = (byte)(i >>> 8);
        data[length2++] = (byte)i;
        this.length = length2;
        return this;
    }

    public ByteVector putUTF8(String s) {
        int charLength = s.length();
        if (charLength > 65535) {
            throw new IllegalArgumentException();
        }
        int len2 = this.length;
        if (len2 + 2 + charLength > this.data.length) {
            this.enlarge(2 + charLength);
        }
        byte[] data = this.data;
        data[len2++] = (byte)(charLength >>> 8);
        data[len2++] = (byte)charLength;
        for (int i = 0; i < charLength; ++i) {
            char c = s.charAt(i);
            if (c < '\u0001' || c > '\u007f') {
                this.length = len2;
                return this.encodeUTF8(s, i, 65535);
            }
            data[len2++] = (byte)c;
        }
        this.length = len2;
        return this;
    }

    ByteVector encodeUTF8(String s, int i, int maxByteLength) {
        char c;
        int charLength = s.length();
        int byteLength = i;
        for (int j = i; j < charLength; ++j) {
            c = s.charAt(j);
            if (c >= '\u0001' && c <= '\u007f') {
                ++byteLength;
                continue;
            }
            if (c > '\u07ff') {
                byteLength += 3;
                continue;
            }
            byteLength += 2;
        }
        if (byteLength > maxByteLength) {
            throw new IllegalArgumentException();
        }
        int start2 = this.length - i - 2;
        if (start2 >= 0) {
            this.data[start2] = (byte)(byteLength >>> 8);
            this.data[start2 + 1] = (byte)byteLength;
        }
        if (this.length + byteLength - i > this.data.length) {
            this.enlarge(byteLength - i);
        }
        int len2 = this.length;
        for (int j = i; j < charLength; ++j) {
            c = s.charAt(j);
            if (c >= '\u0001' && c <= '\u007f') {
                this.data[len2++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                this.data[len2++] = (byte)(0xE0 | c >> 12 & 0xF);
                this.data[len2++] = (byte)(0x80 | c >> 6 & 0x3F);
                this.data[len2++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            this.data[len2++] = (byte)(0xC0 | c >> 6 & 0x1F);
            this.data[len2++] = (byte)(0x80 | c & 0x3F);
        }
        this.length = len2;
        return this;
    }

    public ByteVector putByteArray(byte[] b2, int off, int len2) {
        if (this.length + len2 > this.data.length) {
            this.enlarge(len2);
        }
        if (b2 != null) {
            System.arraycopy(b2, off, this.data, this.length, len2);
        }
        this.length += len2;
        return this;
    }

    private void enlarge(int size2) {
        int length1 = 2 * this.data.length;
        int length2 = this.length + size2;
        byte[] newData = new byte[length1 > length2 ? length1 : length2];
        System.arraycopy(this.data, 0, newData, 0, this.length);
        this.data = newData;
    }
}

