/*
 * Decompiled with CFR 0.152.
 */
package coursier.shaded.org.jsoup.helper;

import coursier.shaded.org.jsoup.helper.Validate;
import coursier.shaded.org.jsoup.nodes.Document;
import coursier.shaded.org.jsoup.nodes.Element;
import coursier.shaded.org.jsoup.nodes.XmlDeclaration;
import coursier.shaded.org.jsoup.parser.Parser;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.Locale;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DataUtil {
    private static final Pattern charsetPattern = Pattern.compile("(?i)\\bcharset=\\s*(?:\"|')?([^\\s,;\"']*)");
    static final String defaultCharset = "UTF-8";
    private static final int bufferSize = 60000;
    private static final char[] mimeBoundaryChars = "-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    static final int boundaryLength = 32;

    private DataUtil() {
    }

    public static Document load(File in2, String charsetName, String baseUri) throws IOException {
        ByteBuffer byteData = DataUtil.readFileToByteBuffer(in2);
        return DataUtil.parseByteData(byteData, charsetName, baseUri, Parser.htmlParser());
    }

    public static Document load(InputStream in2, String charsetName, String baseUri) throws IOException {
        ByteBuffer byteData = DataUtil.readToByteBuffer(in2);
        return DataUtil.parseByteData(byteData, charsetName, baseUri, Parser.htmlParser());
    }

    public static Document load(InputStream in2, String charsetName, String baseUri, Parser parser) throws IOException {
        ByteBuffer byteData = DataUtil.readToByteBuffer(in2);
        return DataUtil.parseByteData(byteData, charsetName, baseUri, parser);
    }

    static void crossStreams(InputStream in2, OutputStream out2) throws IOException {
        int len2;
        byte[] buffer2 = new byte[60000];
        while ((len2 = in2.read(buffer2)) != -1) {
            out2.write(buffer2, 0, len2);
        }
    }

    static Document parseByteData(ByteBuffer byteData, String charsetName, String baseUri, Parser parser) {
        String docData;
        Document doc = null;
        if ((charsetName = DataUtil.detectCharsetFromBom(byteData, charsetName)) == null) {
            XmlDeclaration prolog;
            docData = Charset.forName(defaultCharset).decode(byteData).toString();
            doc = parser.parseInput(docData, baseUri);
            Element meta = doc.select("meta[http-equiv=content-type], meta[charset]").first();
            String foundCharset = null;
            if (meta != null) {
                if (meta.hasAttr("http-equiv")) {
                    foundCharset = DataUtil.getCharsetFromContentType(meta.attr("content"));
                }
                if (foundCharset == null && meta.hasAttr("charset")) {
                    foundCharset = meta.attr("charset");
                }
            }
            if (foundCharset == null && doc.childNodeSize() > 0 && doc.childNode(0) instanceof XmlDeclaration && (prolog = (XmlDeclaration)doc.childNode(0)).name().equals("xml")) {
                foundCharset = prolog.attr("encoding");
            }
            if ((foundCharset = DataUtil.validateCharset(foundCharset)) != null && !foundCharset.equals(defaultCharset)) {
                charsetName = foundCharset = foundCharset.trim().replaceAll("[\"']", "");
                byteData.rewind();
                docData = Charset.forName(foundCharset).decode(byteData).toString();
                doc = null;
            }
        } else {
            Validate.notEmpty(charsetName, "Must set charset arg to character set of file to parse. Set to null to attempt to detect from HTML");
            docData = Charset.forName(charsetName).decode(byteData).toString();
        }
        if (doc == null) {
            doc = parser.parseInput(docData, baseUri);
            doc.outputSettings().charset(charsetName);
        }
        return doc;
    }

    public static ByteBuffer readToByteBuffer(InputStream inStream, int maxSize) throws IOException {
        int read2;
        Validate.isTrue(maxSize >= 0, "maxSize must be 0 (unlimited) or larger");
        boolean capped = maxSize > 0;
        byte[] buffer2 = new byte[capped && maxSize < 60000 ? maxSize : 60000];
        ByteArrayOutputStream outStream = new ByteArrayOutputStream(capped ? maxSize : 60000);
        int remaining = maxSize;
        while (!Thread.interrupted() && (read2 = inStream.read(buffer2)) != -1) {
            if (capped) {
                if (read2 > remaining) {
                    outStream.write(buffer2, 0, remaining);
                    break;
                }
                remaining -= read2;
            }
            outStream.write(buffer2, 0, read2);
        }
        return ByteBuffer.wrap(outStream.toByteArray());
    }

    static ByteBuffer readToByteBuffer(InputStream inStream) throws IOException {
        return DataUtil.readToByteBuffer(inStream, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ByteBuffer readFileToByteBuffer(File file2) throws IOException {
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file2, "r");
            byte[] bytes = new byte[(int)randomAccessFile.length()];
            randomAccessFile.readFully(bytes);
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
            return byteBuffer;
        }
        finally {
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
        }
    }

    static ByteBuffer emptyByteBuffer() {
        return ByteBuffer.allocate(0);
    }

    static String getCharsetFromContentType(String contentType) {
        if (contentType == null) {
            return null;
        }
        Matcher m = charsetPattern.matcher(contentType);
        if (m.find()) {
            String charset = m.group(1).trim();
            charset = charset.replace("charset=", "");
            return DataUtil.validateCharset(charset);
        }
        return null;
    }

    private static String validateCharset(String cs) {
        if (cs == null || cs.length() == 0) {
            return null;
        }
        cs = cs.trim().replaceAll("[\"']", "");
        try {
            if (Charset.isSupported(cs)) {
                return cs;
            }
            if (Charset.isSupported(cs = cs.toUpperCase(Locale.ENGLISH))) {
                return cs;
            }
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            // empty catch block
        }
        return null;
    }

    static String mimeBoundary() {
        StringBuilder mime = new StringBuilder(32);
        Random rand = new Random();
        for (int i = 0; i < 32; ++i) {
            mime.append(mimeBoundaryChars[rand.nextInt(mimeBoundaryChars.length)]);
        }
        return mime.toString();
    }

    private static String detectCharsetFromBom(ByteBuffer byteData, String charsetName) {
        byteData.mark();
        byte[] bom = new byte[4];
        if (byteData.remaining() >= bom.length) {
            byteData.get(bom);
            byteData.rewind();
        }
        if (bom[0] == 0 && bom[1] == 0 && bom[2] == -2 && bom[3] == -1 || bom[0] == -1 && bom[1] == -2 && bom[2] == 0 && bom[3] == 0) {
            charsetName = "UTF-32";
        } else if (bom[0] == -2 && bom[1] == -1 || bom[0] == -1 && bom[1] == -2) {
            charsetName = "UTF-16";
        } else if (bom[0] == -17 && bom[1] == -69 && bom[2] == -65) {
            charsetName = defaultCharset;
            byteData.position(3);
        }
        return charsetName;
    }
}

