/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.ConfigBoolean;
import com.typesafe.config.impl.ConfigDouble;
import com.typesafe.config.impl.ConfigInt;
import com.typesafe.config.impl.ConfigLong;
import com.typesafe.config.impl.ConfigNull;
import com.typesafe.config.impl.ConfigNumber;
import com.typesafe.config.impl.ConfigString;
import com.typesafe.config.impl.ResolveStatus;
import com.typesafe.config.impl.SimpleConfigList;
import com.typesafe.config.impl.SimpleConfigObject;
import com.typesafe.config.impl.SimpleConfigOrigin;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class SerializedConfigValue
extends AbstractConfigValue
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private ConfigValue value;
    private boolean wasConfig;

    public SerializedConfigValue() {
        super(null);
    }

    SerializedConfigValue(ConfigValue value2) {
        this();
        this.value = value2;
        this.wasConfig = false;
    }

    SerializedConfigValue(Config conf) {
        this(conf.root());
        this.wasConfig = true;
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.wasConfig) {
            return ((ConfigObject)this.value).toConfig();
        }
        return this.value;
    }

    private static void writeOriginField(DataOutput out2, SerializedField code, Object v) throws IOException {
        switch (code) {
            case ORIGIN_DESCRIPTION: {
                out2.writeUTF((String)v);
                break;
            }
            case ORIGIN_LINE_NUMBER: {
                out2.writeInt((Integer)v);
                break;
            }
            case ORIGIN_END_LINE_NUMBER: {
                out2.writeInt((Integer)v);
                break;
            }
            case ORIGIN_TYPE: {
                out2.writeByte((Integer)v);
                break;
            }
            case ORIGIN_URL: {
                out2.writeUTF((String)v);
                break;
            }
            case ORIGIN_RESOURCE: {
                out2.writeUTF((String)v);
                break;
            }
            case ORIGIN_COMMENTS: {
                List list2 = (List)v;
                int size2 = list2.size();
                out2.writeInt(size2);
                for (String s : list2) {
                    out2.writeUTF(s);
                }
                break;
            }
            case ORIGIN_NULL_URL: 
            case ORIGIN_NULL_RESOURCE: 
            case ORIGIN_NULL_COMMENTS: {
                break;
            }
            default: {
                throw new IOException("Unhandled field from origin: " + (Object)((Object)code));
            }
        }
    }

    static void writeOrigin(DataOutput out2, SimpleConfigOrigin origin, SimpleConfigOrigin baseOrigin) throws IOException {
        Map<Object, Object> m = origin != null ? origin.toFieldsDelta(baseOrigin) : Collections.emptyMap();
        for (Map.Entry e : m.entrySet()) {
            FieldOut field = new FieldOut((SerializedField)((Object)e.getKey()));
            Object v = e.getValue();
            SerializedConfigValue.writeOriginField(field.data, field.code, v);
            SerializedConfigValue.writeField(out2, field);
        }
        SerializedConfigValue.writeEndMarker(out2);
    }

    static SimpleConfigOrigin readOrigin(DataInput in2, SimpleConfigOrigin baseOrigin) throws IOException {
        EnumMap<SerializedField, Object> m = new EnumMap<SerializedField, Object>(SerializedField.class);
        while (true) {
            ArrayList<String> v = null;
            SerializedField field = SerializedConfigValue.readCode(in2);
            switch (field) {
                case END_MARKER: {
                    return SimpleConfigOrigin.fromBase(baseOrigin, m);
                }
                case ORIGIN_DESCRIPTION: {
                    in2.readInt();
                    v = in2.readUTF();
                    break;
                }
                case ORIGIN_LINE_NUMBER: {
                    in2.readInt();
                    v = in2.readInt();
                    break;
                }
                case ORIGIN_END_LINE_NUMBER: {
                    in2.readInt();
                    v = in2.readInt();
                    break;
                }
                case ORIGIN_TYPE: {
                    in2.readInt();
                    v = in2.readUnsignedByte();
                    break;
                }
                case ORIGIN_URL: {
                    in2.readInt();
                    v = in2.readUTF();
                    break;
                }
                case ORIGIN_RESOURCE: {
                    in2.readInt();
                    v = in2.readUTF();
                    break;
                }
                case ORIGIN_COMMENTS: {
                    in2.readInt();
                    int size2 = in2.readInt();
                    ArrayList<String> list2 = new ArrayList<String>(size2);
                    for (int i = 0; i < size2; ++i) {
                        list2.add(in2.readUTF());
                    }
                    v = list2;
                    break;
                }
                case ORIGIN_NULL_URL: 
                case ORIGIN_NULL_RESOURCE: 
                case ORIGIN_NULL_COMMENTS: {
                    in2.readInt();
                    v = "";
                    break;
                }
                case ROOT_VALUE: 
                case ROOT_WAS_CONFIG: 
                case VALUE_DATA: 
                case VALUE_ORIGIN: {
                    throw new IOException("Not expecting this field here: " + (Object)((Object)field));
                }
                case UNKNOWN: {
                    SerializedConfigValue.skipField(in2);
                }
            }
            if (v == null) continue;
            m.put(field, (Object)v);
        }
    }

    private static void writeValueData(DataOutput out2, ConfigValue value2) throws IOException {
        SerializedValueType st2 = SerializedValueType.forValue(value2);
        out2.writeByte(st2.ordinal());
        switch (st2) {
            case BOOLEAN: {
                out2.writeBoolean(((ConfigBoolean)value2).unwrapped());
                break;
            }
            case NULL: {
                break;
            }
            case INT: {
                out2.writeInt(((ConfigInt)value2).unwrapped());
                out2.writeUTF(((ConfigNumber)value2).transformToString());
                break;
            }
            case LONG: {
                out2.writeLong(((ConfigLong)value2).unwrapped());
                out2.writeUTF(((ConfigNumber)value2).transformToString());
                break;
            }
            case DOUBLE: {
                out2.writeDouble(((ConfigDouble)value2).unwrapped());
                out2.writeUTF(((ConfigNumber)value2).transformToString());
                break;
            }
            case STRING: {
                out2.writeUTF(((ConfigString)value2).unwrapped());
                break;
            }
            case LIST: {
                ConfigList list2 = (ConfigList)value2;
                out2.writeInt(list2.size());
                for (ConfigValue v : list2) {
                    SerializedConfigValue.writeValue(out2, v, (SimpleConfigOrigin)list2.origin());
                }
                break;
            }
            case OBJECT: {
                ConfigObject obj2 = (ConfigObject)value2;
                out2.writeInt(obj2.size());
                for (Map.Entry e : obj2.entrySet()) {
                    out2.writeUTF((String)e.getKey());
                    SerializedConfigValue.writeValue(out2, (ConfigValue)e.getValue(), (SimpleConfigOrigin)obj2.origin());
                }
                break;
            }
        }
    }

    private static AbstractConfigValue readValueData(DataInput in2, SimpleConfigOrigin origin) throws IOException {
        int stb = in2.readUnsignedByte();
        SerializedValueType st2 = SerializedValueType.forInt(stb);
        if (st2 == null) {
            throw new IOException("Unknown serialized value type: " + stb);
        }
        switch (st2) {
            case BOOLEAN: {
                return new ConfigBoolean(origin, in2.readBoolean());
            }
            case NULL: {
                return new ConfigNull(origin);
            }
            case INT: {
                int vi = in2.readInt();
                String si = in2.readUTF();
                return new ConfigInt(origin, vi, si);
            }
            case LONG: {
                long vl = in2.readLong();
                String sl = in2.readUTF();
                return new ConfigLong(origin, vl, sl);
            }
            case DOUBLE: {
                double vd = in2.readDouble();
                String sd = in2.readUTF();
                return new ConfigDouble(origin, vd, sd);
            }
            case STRING: {
                return new ConfigString.Quoted(origin, in2.readUTF());
            }
            case LIST: {
                int listSize = in2.readInt();
                ArrayList<AbstractConfigValue> list2 = new ArrayList<AbstractConfigValue>(listSize);
                for (int i = 0; i < listSize; ++i) {
                    AbstractConfigValue v = SerializedConfigValue.readValue(in2, origin);
                    list2.add(v);
                }
                return new SimpleConfigList(origin, list2);
            }
            case OBJECT: {
                int mapSize = in2.readInt();
                HashMap<String, AbstractConfigValue> map2 = new HashMap<String, AbstractConfigValue>(mapSize);
                for (int i = 0; i < mapSize; ++i) {
                    String key = in2.readUTF();
                    AbstractConfigValue v = SerializedConfigValue.readValue(in2, origin);
                    map2.put(key, v);
                }
                return new SimpleConfigObject(origin, map2);
            }
        }
        throw new IOException("Unhandled serialized value type: " + (Object)((Object)st2));
    }

    private static void writeValue(DataOutput out2, ConfigValue value2, SimpleConfigOrigin baseOrigin) throws IOException {
        FieldOut origin = new FieldOut(SerializedField.VALUE_ORIGIN);
        SerializedConfigValue.writeOrigin(origin.data, (SimpleConfigOrigin)value2.origin(), baseOrigin);
        SerializedConfigValue.writeField(out2, origin);
        FieldOut data = new FieldOut(SerializedField.VALUE_DATA);
        SerializedConfigValue.writeValueData(data.data, value2);
        SerializedConfigValue.writeField(out2, data);
        SerializedConfigValue.writeEndMarker(out2);
    }

    private static AbstractConfigValue readValue(DataInput in2, SimpleConfigOrigin baseOrigin) throws IOException {
        AbstractConfigValue value2 = null;
        SimpleConfigOrigin origin = null;
        while (true) {
            SerializedField code;
            if ((code = SerializedConfigValue.readCode(in2)) == SerializedField.END_MARKER) {
                if (value2 == null) {
                    throw new IOException("No value data found in serialization of value");
                }
                return value2;
            }
            if (code == SerializedField.VALUE_DATA) {
                if (origin == null) {
                    throw new IOException("Origin must be stored before value data");
                }
                in2.readInt();
                value2 = SerializedConfigValue.readValueData(in2, origin);
                continue;
            }
            if (code == SerializedField.VALUE_ORIGIN) {
                in2.readInt();
                origin = SerializedConfigValue.readOrigin(in2, baseOrigin);
                continue;
            }
            SerializedConfigValue.skipField(in2);
        }
    }

    private static void writeField(DataOutput out2, FieldOut field) throws IOException {
        byte[] bytes = field.bytes.toByteArray();
        out2.writeByte(field.code.ordinal());
        out2.writeInt(bytes.length);
        out2.write(bytes);
    }

    private static void writeEndMarker(DataOutput out2) throws IOException {
        out2.writeByte(SerializedField.END_MARKER.ordinal());
    }

    private static SerializedField readCode(DataInput in2) throws IOException {
        int c = in2.readUnsignedByte();
        if (c == SerializedField.UNKNOWN.ordinal()) {
            throw new IOException("field code " + c + " is not supposed to be on the wire");
        }
        return SerializedField.forInt(c);
    }

    private static void skipField(DataInput in2) throws IOException {
        int len2 = in2.readInt();
        int skipped = in2.skipBytes(len2);
        if (skipped < len2) {
            byte[] bytes = new byte[len2 - skipped];
            in2.readFully(bytes);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out2) throws IOException {
        if (((AbstractConfigValue)this.value).resolveStatus() != ResolveStatus.RESOLVED) {
            throw new NotSerializableException("tried to serialize a value with unresolved substitutions, need to Config#resolve() first, see API docs");
        }
        FieldOut field = new FieldOut(SerializedField.ROOT_VALUE);
        SerializedConfigValue.writeValue(field.data, this.value, null);
        SerializedConfigValue.writeField(out2, field);
        field = new FieldOut(SerializedField.ROOT_WAS_CONFIG);
        field.data.writeBoolean(this.wasConfig);
        SerializedConfigValue.writeField(out2, field);
        SerializedConfigValue.writeEndMarker(out2);
    }

    @Override
    public void readExternal(ObjectInput in2) throws IOException, ClassNotFoundException {
        SerializedField code;
        while ((code = SerializedConfigValue.readCode(in2)) != SerializedField.END_MARKER) {
            if (code == SerializedField.ROOT_VALUE) {
                in2.readInt();
                this.value = SerializedConfigValue.readValue(in2, null);
                continue;
            }
            if (code == SerializedField.ROOT_WAS_CONFIG) {
                in2.readInt();
                this.wasConfig = in2.readBoolean();
                continue;
            }
            SerializedConfigValue.skipField(in2);
        }
        return;
    }

    private static ConfigException shouldNotBeUsed() {
        return new ConfigException.BugOrBroken(SerializedConfigValue.class.getName() + " should not exist outside of serialization");
    }

    @Override
    public ConfigValueType valueType() {
        throw SerializedConfigValue.shouldNotBeUsed();
    }

    @Override
    public Object unwrapped() {
        throw SerializedConfigValue.shouldNotBeUsed();
    }

    @Override
    protected SerializedConfigValue newCopy(ConfigOrigin origin) {
        throw SerializedConfigValue.shouldNotBeUsed();
    }

    @Override
    public final String toString() {
        return this.getClass().getSimpleName() + "(value=" + this.value + ",wasConfig=" + this.wasConfig + ")";
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof SerializedConfigValue) {
            return this.canEqual(other) && this.wasConfig == ((SerializedConfigValue)other).wasConfig && this.value.equals(((SerializedConfigValue)other).value);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int h2 = 41 * (41 + this.value.hashCode());
        h2 = 41 * (h2 + (this.wasConfig ? 1 : 0));
        return h2;
    }

    private static class FieldOut {
        final SerializedField code;
        final ByteArrayOutputStream bytes;
        final DataOutput data;

        FieldOut(SerializedField code) {
            this.code = code;
            this.bytes = new ByteArrayOutputStream();
            this.data = new DataOutputStream(this.bytes);
        }
    }

    private static enum SerializedValueType {
        NULL(ConfigValueType.NULL),
        BOOLEAN(ConfigValueType.BOOLEAN),
        INT(ConfigValueType.NUMBER),
        LONG(ConfigValueType.NUMBER),
        DOUBLE(ConfigValueType.NUMBER),
        STRING(ConfigValueType.STRING),
        LIST(ConfigValueType.LIST),
        OBJECT(ConfigValueType.OBJECT);

        ConfigValueType configType;

        private SerializedValueType(ConfigValueType configType) {
            this.configType = configType;
        }

        static SerializedValueType forInt(int b2) {
            if (b2 < SerializedValueType.values().length) {
                return SerializedValueType.values()[b2];
            }
            return null;
        }

        static SerializedValueType forValue(ConfigValue value2) {
            ConfigValueType t = value2.valueType();
            if (t == ConfigValueType.NUMBER) {
                if (value2 instanceof ConfigInt) {
                    return INT;
                }
                if (value2 instanceof ConfigLong) {
                    return LONG;
                }
                if (value2 instanceof ConfigDouble) {
                    return DOUBLE;
                }
            } else {
                for (SerializedValueType st2 : SerializedValueType.values()) {
                    if (st2.configType != t) continue;
                    return st2;
                }
            }
            throw new ConfigException.BugOrBroken("don't know how to serialize " + value2);
        }
    }

    static enum SerializedField {
        UNKNOWN,
        END_MARKER,
        ROOT_VALUE,
        ROOT_WAS_CONFIG,
        VALUE_DATA,
        VALUE_ORIGIN,
        ORIGIN_DESCRIPTION,
        ORIGIN_LINE_NUMBER,
        ORIGIN_END_LINE_NUMBER,
        ORIGIN_TYPE,
        ORIGIN_URL,
        ORIGIN_COMMENTS,
        ORIGIN_NULL_URL,
        ORIGIN_NULL_COMMENTS,
        ORIGIN_RESOURCE,
        ORIGIN_NULL_RESOURCE;


        static SerializedField forInt(int b2) {
            if (b2 < SerializedField.values().length) {
                return SerializedField.values()[b2];
            }
            return UNKNOWN;
        }
    }
}

