/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;

@GwtCompatible(emulated=true)
public final class Shorts {
    public static final int BYTES = 2;
    public static final short MAX_POWER_OF_TWO = 16384;

    private Shorts() {
    }

    public static int hashCode(short value2) {
        return value2;
    }

    public static short checkedCast(long value2) {
        short result2 = (short)value2;
        Preconditions.checkArgument((long)result2 == value2, "Out of range: %s", value2);
        return result2;
    }

    public static short saturatedCast(long value2) {
        if (value2 > 32767L) {
            return Short.MAX_VALUE;
        }
        if (value2 < -32768L) {
            return Short.MIN_VALUE;
        }
        return (short)value2;
    }

    public static int compare(short a2, short b2) {
        return a2 - b2;
    }

    public static boolean contains(short[] array, short target) {
        for (short value2 : array) {
            if (value2 != target) continue;
            return true;
        }
        return false;
    }

    public static int indexOf(short[] array, short target) {
        return Shorts.indexOf(array, target, 0, array.length);
    }

    private static int indexOf(short[] array, short target, int start2, int end2) {
        for (int i = start2; i < end2; ++i) {
            if (array[i] != target) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(short[] array, short[] target) {
        Preconditions.checkNotNull(array, "array");
        Preconditions.checkNotNull(target, "target");
        if (target.length == 0) {
            return 0;
        }
        block0: for (int i = 0; i < array.length - target.length + 1; ++i) {
            for (int j = 0; j < target.length; ++j) {
                if (array[i + j] != target[j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(short[] array, short target) {
        return Shorts.lastIndexOf(array, target, 0, array.length);
    }

    private static int lastIndexOf(short[] array, short target, int start2, int end2) {
        for (int i = end2 - 1; i >= start2; --i) {
            if (array[i] != target) continue;
            return i;
        }
        return -1;
    }

    public static short min(short ... array) {
        Preconditions.checkArgument(array.length > 0);
        short min2 = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (array[i] >= min2) continue;
            min2 = array[i];
        }
        return min2;
    }

    public static short max(short ... array) {
        Preconditions.checkArgument(array.length > 0);
        short max2 = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (array[i] <= max2) continue;
            max2 = array[i];
        }
        return max2;
    }

    public static short[] concat(short[] ... arrays) {
        int length2 = 0;
        for (short[] array : arrays) {
            length2 += array.length;
        }
        short[] result2 = new short[length2];
        int pos = 0;
        for (short[] array : arrays) {
            System.arraycopy(array, 0, result2, pos, array.length);
            pos += array.length;
        }
        return result2;
    }

    @GwtIncompatible(value="doesn't work")
    public static byte[] toByteArray(short value2) {
        return new byte[]{(byte)(value2 >> 8), (byte)value2};
    }

    @GwtIncompatible(value="doesn't work")
    public static short fromByteArray(byte[] bytes) {
        Preconditions.checkArgument(bytes.length >= 2, "array too small: %s < %s", bytes.length, 2);
        return Shorts.fromBytes(bytes[0], bytes[1]);
    }

    @GwtIncompatible(value="doesn't work")
    public static short fromBytes(byte b1, byte b2) {
        return (short)(b1 << 8 | b2 & 0xFF);
    }

    public static short[] ensureCapacity(short[] array, int minLength2, int padding) {
        Preconditions.checkArgument(minLength2 >= 0, "Invalid minLength: %s", minLength2);
        Preconditions.checkArgument(padding >= 0, "Invalid padding: %s", padding);
        return array.length < minLength2 ? Shorts.copyOf(array, minLength2 + padding) : array;
    }

    private static short[] copyOf(short[] original, int length2) {
        short[] copy2 = new short[length2];
        System.arraycopy(original, 0, copy2, 0, Math.min(original.length, length2));
        return copy2;
    }

    public static String join(String separator, short ... array) {
        Preconditions.checkNotNull(separator);
        if (array.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(array.length * 6);
        builder.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            builder.append(separator).append(array[i]);
        }
        return builder.toString();
    }

    public static Comparator<short[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static short[] toArray(Collection<? extends Number> collection) {
        if (collection instanceof ShortArrayAsList) {
            return ((ShortArrayAsList)collection).toShortArray();
        }
        Object[] boxedArray = collection.toArray();
        int len2 = boxedArray.length;
        short[] array = new short[len2];
        for (int i = 0; i < len2; ++i) {
            array[i] = ((Number)Preconditions.checkNotNull(boxedArray[i])).shortValue();
        }
        return array;
    }

    public static List<Short> asList(short ... backingArray) {
        if (backingArray.length == 0) {
            return Collections.emptyList();
        }
        return new ShortArrayAsList(backingArray);
    }

    @GwtCompatible
    private static class ShortArrayAsList
    extends AbstractList<Short>
    implements RandomAccess,
    Serializable {
        final short[] array;
        final int start;
        final int end;
        private static final long serialVersionUID = 0L;

        ShortArrayAsList(short[] array) {
            this(array, 0, array.length);
        }

        ShortArrayAsList(short[] array, int start2, int end2) {
            this.array = array;
            this.start = start2;
            this.end = end2;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Short get(int index2) {
            Preconditions.checkElementIndex(index2, this.size());
            return this.array[this.start + index2];
        }

        @Override
        public boolean contains(Object target) {
            return target instanceof Short && Shorts.indexOf(this.array, (Short)target, this.start, this.end) != -1;
        }

        @Override
        public int indexOf(Object target) {
            int i;
            if (target instanceof Short && (i = Shorts.indexOf(this.array, (Short)target, this.start, this.end)) >= 0) {
                return i - this.start;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object target) {
            int i;
            if (target instanceof Short && (i = Shorts.lastIndexOf(this.array, (Short)target, this.start, this.end)) >= 0) {
                return i - this.start;
            }
            return -1;
        }

        @Override
        public Short set(int index2, Short element2) {
            Preconditions.checkElementIndex(index2, this.size());
            short oldValue = this.array[this.start + index2];
            this.array[this.start + index2] = Preconditions.checkNotNull(element2);
            return oldValue;
        }

        @Override
        public List<Short> subList(int fromIndex, int toIndex) {
            int size2 = this.size();
            Preconditions.checkPositionIndexes(fromIndex, toIndex, size2);
            if (fromIndex == toIndex) {
                return Collections.emptyList();
            }
            return new ShortArrayAsList(this.array, this.start + fromIndex, this.start + toIndex);
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof ShortArrayAsList) {
                ShortArrayAsList that2 = (ShortArrayAsList)object;
                int size2 = this.size();
                if (that2.size() != size2) {
                    return false;
                }
                for (int i = 0; i < size2; ++i) {
                    if (this.array[this.start + i] == that2.array[that2.start + i]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            int result2 = 1;
            for (int i = this.start; i < this.end; ++i) {
                result2 = 31 * result2 + Shorts.hashCode(this.array[i]);
            }
            return result2;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder(this.size() * 6);
            builder.append('[').append(this.array[this.start]);
            for (int i = this.start + 1; i < this.end; ++i) {
                builder.append(", ").append(this.array[i]);
            }
            return builder.append(']').toString();
        }

        short[] toShortArray() {
            int size2 = this.size();
            short[] result2 = new short[size2];
            System.arraycopy(this.array, this.start, result2, 0, size2);
            return result2;
        }
    }

    private static enum LexicographicalComparator implements Comparator<short[]>
    {
        INSTANCE;


        @Override
        public int compare(short[] left2, short[] right2) {
            int minLength2 = Math.min(left2.length, right2.length);
            for (int i = 0; i < minLength2; ++i) {
                int result2 = Shorts.compare(left2[i], right2[i]);
                if (result2 == 0) continue;
                return result2;
            }
            return left2.length - right2.length;
        }
    }
}

