/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.primitives.AndroidInteger;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import javax.annotation.CheckForNull;

@GwtCompatible(emulated=true)
public final class Ints {
    public static final int BYTES = 4;
    public static final int MAX_POWER_OF_TWO = 0x40000000;

    private Ints() {
    }

    public static int hashCode(int value2) {
        return value2;
    }

    public static int checkedCast(long value2) {
        int result2 = (int)value2;
        Preconditions.checkArgument((long)result2 == value2, "Out of range: %s", value2);
        return result2;
    }

    public static int saturatedCast(long value2) {
        if (value2 > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (value2 < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)value2;
    }

    public static int compare(int a2, int b2) {
        return a2 < b2 ? -1 : (a2 > b2 ? 1 : 0);
    }

    public static boolean contains(int[] array, int target) {
        for (int value2 : array) {
            if (value2 != target) continue;
            return true;
        }
        return false;
    }

    public static int indexOf(int[] array, int target) {
        return Ints.indexOf(array, target, 0, array.length);
    }

    private static int indexOf(int[] array, int target, int start2, int end2) {
        for (int i = start2; i < end2; ++i) {
            if (array[i] != target) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(int[] array, int[] target) {
        Preconditions.checkNotNull(array, "array");
        Preconditions.checkNotNull(target, "target");
        if (target.length == 0) {
            return 0;
        }
        block0: for (int i = 0; i < array.length - target.length + 1; ++i) {
            for (int j = 0; j < target.length; ++j) {
                if (array[i + j] != target[j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(int[] array, int target) {
        return Ints.lastIndexOf(array, target, 0, array.length);
    }

    private static int lastIndexOf(int[] array, int target, int start2, int end2) {
        for (int i = end2 - 1; i >= start2; --i) {
            if (array[i] != target) continue;
            return i;
        }
        return -1;
    }

    public static int min(int ... array) {
        Preconditions.checkArgument(array.length > 0);
        int min2 = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (array[i] >= min2) continue;
            min2 = array[i];
        }
        return min2;
    }

    public static int max(int ... array) {
        Preconditions.checkArgument(array.length > 0);
        int max2 = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (array[i] <= max2) continue;
            max2 = array[i];
        }
        return max2;
    }

    public static int[] concat(int[] ... arrays) {
        int length2 = 0;
        for (int[] array : arrays) {
            length2 += array.length;
        }
        int[] result2 = new int[length2];
        int pos = 0;
        for (int[] array : arrays) {
            System.arraycopy(array, 0, result2, pos, array.length);
            pos += array.length;
        }
        return result2;
    }

    @GwtIncompatible(value="doesn't work")
    public static byte[] toByteArray(int value2) {
        return new byte[]{(byte)(value2 >> 24), (byte)(value2 >> 16), (byte)(value2 >> 8), (byte)value2};
    }

    @GwtIncompatible(value="doesn't work")
    public static int fromByteArray(byte[] bytes) {
        Preconditions.checkArgument(bytes.length >= 4, "array too small: %s < %s", bytes.length, 4);
        return Ints.fromBytes(bytes[0], bytes[1], bytes[2], bytes[3]);
    }

    @GwtIncompatible(value="doesn't work")
    public static int fromBytes(byte b1, byte b2, byte b3, byte b4) {
        return b1 << 24 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 8 | b4 & 0xFF;
    }

    public static int[] ensureCapacity(int[] array, int minLength2, int padding) {
        Preconditions.checkArgument(minLength2 >= 0, "Invalid minLength: %s", minLength2);
        Preconditions.checkArgument(padding >= 0, "Invalid padding: %s", padding);
        return array.length < minLength2 ? Ints.copyOf(array, minLength2 + padding) : array;
    }

    private static int[] copyOf(int[] original, int length2) {
        int[] copy2 = new int[length2];
        System.arraycopy(original, 0, copy2, 0, Math.min(original.length, length2));
        return copy2;
    }

    public static String join(String separator, int ... array) {
        Preconditions.checkNotNull(separator);
        if (array.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(array.length * 5);
        builder.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            builder.append(separator).append(array[i]);
        }
        return builder.toString();
    }

    public static Comparator<int[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static int[] toArray(Collection<? extends Number> collection) {
        if (collection instanceof IntArrayAsList) {
            return ((IntArrayAsList)collection).toIntArray();
        }
        Object[] boxedArray = collection.toArray();
        int len2 = boxedArray.length;
        int[] array = new int[len2];
        for (int i = 0; i < len2; ++i) {
            array[i] = ((Number)Preconditions.checkNotNull(boxedArray[i])).intValue();
        }
        return array;
    }

    public static List<Integer> asList(int ... backingArray) {
        if (backingArray.length == 0) {
            return Collections.emptyList();
        }
        return new IntArrayAsList(backingArray);
    }

    @CheckForNull
    @Beta
    @GwtIncompatible(value="TODO")
    public static Integer tryParse(String string2) {
        return AndroidInteger.tryParse(string2, 10);
    }

    @GwtCompatible
    private static class IntArrayAsList
    extends AbstractList<Integer>
    implements RandomAccess,
    Serializable {
        final int[] array;
        final int start;
        final int end;
        private static final long serialVersionUID = 0L;

        IntArrayAsList(int[] array) {
            this(array, 0, array.length);
        }

        IntArrayAsList(int[] array, int start2, int end2) {
            this.array = array;
            this.start = start2;
            this.end = end2;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Integer get(int index2) {
            Preconditions.checkElementIndex(index2, this.size());
            return this.array[this.start + index2];
        }

        @Override
        public boolean contains(Object target) {
            return target instanceof Integer && Ints.indexOf(this.array, (Integer)target, this.start, this.end) != -1;
        }

        @Override
        public int indexOf(Object target) {
            int i;
            if (target instanceof Integer && (i = Ints.indexOf(this.array, (Integer)target, this.start, this.end)) >= 0) {
                return i - this.start;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object target) {
            int i;
            if (target instanceof Integer && (i = Ints.lastIndexOf(this.array, (Integer)target, this.start, this.end)) >= 0) {
                return i - this.start;
            }
            return -1;
        }

        @Override
        public Integer set(int index2, Integer element2) {
            Preconditions.checkElementIndex(index2, this.size());
            int oldValue = this.array[this.start + index2];
            this.array[this.start + index2] = Preconditions.checkNotNull(element2);
            return oldValue;
        }

        @Override
        public List<Integer> subList(int fromIndex, int toIndex) {
            int size2 = this.size();
            Preconditions.checkPositionIndexes(fromIndex, toIndex, size2);
            if (fromIndex == toIndex) {
                return Collections.emptyList();
            }
            return new IntArrayAsList(this.array, this.start + fromIndex, this.start + toIndex);
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof IntArrayAsList) {
                IntArrayAsList that2 = (IntArrayAsList)object;
                int size2 = this.size();
                if (that2.size() != size2) {
                    return false;
                }
                for (int i = 0; i < size2; ++i) {
                    if (this.array[this.start + i] == that2.array[that2.start + i]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            int result2 = 1;
            for (int i = this.start; i < this.end; ++i) {
                result2 = 31 * result2 + Ints.hashCode(this.array[i]);
            }
            return result2;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder(this.size() * 5);
            builder.append('[').append(this.array[this.start]);
            for (int i = this.start + 1; i < this.end; ++i) {
                builder.append(", ").append(this.array[i]);
            }
            return builder.append(']').toString();
        }

        int[] toIntArray() {
            int size2 = this.size();
            int[] result2 = new int[size2];
            System.arraycopy(this.array, this.start, result2, 0, size2);
            return result2;
        }
    }

    private static enum LexicographicalComparator implements Comparator<int[]>
    {
        INSTANCE;


        @Override
        public int compare(int[] left2, int[] right2) {
            int minLength2 = Math.min(left2.length, right2.length);
            for (int i = 0; i < minLength2; ++i) {
                int result2 = Ints.compare(left2[i], right2[i]);
                if (result2 == 0) continue;
                return result2;
            }
            return left2.length - right2.length;
        }
    }
}

