/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.math.IntMath;
import com.google.common.math.MathPreconditions;
import java.math.RoundingMode;

@GwtCompatible(emulated=true)
public final class LongMath {
    @VisibleForTesting
    static final long MAX_POWER_OF_SQRT2_UNSIGNED = -5402926248376769404L;
    @VisibleForTesting
    static final byte[] maxLog10ForLeadingZeros = new byte[]{19, 18, 18, 18, 18, 17, 17, 17, 16, 16, 16, 15, 15, 15, 15, 14, 14, 14, 13, 13, 13, 12, 12, 12, 12, 11, 11, 11, 10, 10, 10, 9, 9, 9, 9, 8, 8, 8, 7, 7, 7, 6, 6, 6, 6, 5, 5, 5, 4, 4, 4, 3, 3, 3, 3, 2, 2, 2, 1, 1, 1, 0, 0, 0};
    @GwtIncompatible(value="TODO")
    @VisibleForTesting
    static final long[] powersOf10 = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};
    @GwtIncompatible(value="TODO")
    @VisibleForTesting
    static final long[] halfPowersOf10 = new long[]{3L, 31L, 316L, 3162L, 31622L, 316227L, 3162277L, 31622776L, 316227766L, 3162277660L, 31622776601L, 316227766016L, 3162277660168L, 31622776601683L, 316227766016837L, 3162277660168379L, 31622776601683793L, 316227766016837933L, 3162277660168379331L};
    @GwtIncompatible(value="TODO")
    @VisibleForTesting
    static final long FLOOR_SQRT_MAX_LONG = 3037000499L;
    static final long[] factorials = new long[]{1L, 1L, 2L, 6L, 24L, 120L, 720L, 5040L, 40320L, 362880L, 3628800L, 39916800L, 479001600L, 6227020800L, 87178291200L, 1307674368000L, 20922789888000L, 355687428096000L, 6402373705728000L, 121645100408832000L, 2432902008176640000L};
    static final int[] biggestBinomials = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, 3810779, 121977, 16175, 4337, 1733, 887, 534, 361, 265, 206, 169, 143, 125, 111, 101, 94, 88, 83, 79, 76, 74, 72, 70, 69, 68, 67, 67, 66, 66, 66, 66};
    @VisibleForTesting
    static final int[] biggestSimpleBinomials = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, 2642246, 86251, 11724, 3218, 1313, 684, 419, 287, 214, 169, 139, 119, 105, 95, 87, 81, 76, 73, 70, 68, 66, 64, 63, 62, 62, 61, 61, 61};

    public static boolean isPowerOfTwo(long x) {
        return x > 0L & (x & x - 1L) == 0L;
    }

    public static int log2(long x, RoundingMode mode2) {
        MathPreconditions.checkPositive("x", x);
        switch (mode2) {
            case UNNECESSARY: {
                MathPreconditions.checkRoundingUnnecessary(LongMath.isPowerOfTwo(x));
            }
            case DOWN: 
            case FLOOR: {
                return 63 - Long.numberOfLeadingZeros(x);
            }
            case UP: 
            case CEILING: {
                return 64 - Long.numberOfLeadingZeros(x - 1L);
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                int leadingZeros = Long.numberOfLeadingZeros(x);
                long cmp = -5402926248376769404L >>> leadingZeros;
                int logFloor = 63 - leadingZeros;
                return x <= cmp ? logFloor : logFloor + 1;
            }
        }
        throw new AssertionError((Object)"impossible");
    }

    @GwtIncompatible(value="TODO")
    public static int log10(long x, RoundingMode mode2) {
        MathPreconditions.checkPositive("x", x);
        if (LongMath.fitsInInt(x)) {
            return IntMath.log10((int)x, mode2);
        }
        int logFloor = LongMath.log10Floor(x);
        long floorPow = powersOf10[logFloor];
        switch (mode2) {
            case UNNECESSARY: {
                MathPreconditions.checkRoundingUnnecessary(x == floorPow);
            }
            case DOWN: 
            case FLOOR: {
                return logFloor;
            }
            case UP: 
            case CEILING: {
                return x == floorPow ? logFloor : logFloor + 1;
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                return x <= halfPowersOf10[logFloor] ? logFloor : logFloor + 1;
            }
        }
        throw new AssertionError();
    }

    @GwtIncompatible(value="TODO")
    static int log10Floor(long x) {
        byte y2 = maxLog10ForLeadingZeros[Long.numberOfLeadingZeros(x)];
        long sgn = x - powersOf10[y2] >>> 63;
        return y2 - (int)sgn;
    }

    @GwtIncompatible(value="TODO")
    public static long pow(long b2, int k) {
        MathPreconditions.checkNonNegative("exponent", k);
        if (-2L <= b2 && b2 <= 2L) {
            switch ((int)b2) {
                case 0: {
                    return k == 0 ? 1L : 0L;
                }
                case 1: {
                    return 1L;
                }
                case -1: {
                    return (k & 1) == 0 ? 1L : -1L;
                }
                case 2: {
                    return k < 64 ? 1L << k : 0L;
                }
                case -2: {
                    if (k < 64) {
                        return (k & 1) == 0 ? 1L << k : -(1L << k);
                    }
                    return 0L;
                }
            }
            throw new AssertionError();
        }
        long accum = 1L;
        while (true) {
            switch (k) {
                case 0: {
                    return accum;
                }
                case 1: {
                    return accum * b2;
                }
            }
            accum *= (k & 1) == 0 ? 1L : b2;
            b2 *= b2;
            k >>= 1;
        }
    }

    @GwtIncompatible(value="TODO")
    public static long sqrt(long x, RoundingMode mode2) {
        MathPreconditions.checkNonNegative("x", x);
        if (LongMath.fitsInInt(x)) {
            return IntMath.sqrt((int)x, mode2);
        }
        long sqrtFloor = LongMath.sqrtFloor(x);
        switch (mode2) {
            case UNNECESSARY: {
                MathPreconditions.checkRoundingUnnecessary(sqrtFloor * sqrtFloor == x);
            }
            case DOWN: 
            case FLOOR: {
                return sqrtFloor;
            }
            case UP: 
            case CEILING: {
                return sqrtFloor * sqrtFloor == x ? sqrtFloor : sqrtFloor + 1L;
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                long halfSquare = sqrtFloor * sqrtFloor + sqrtFloor;
                return halfSquare >= x | halfSquare < 0L ? sqrtFloor : sqrtFloor + 1L;
            }
        }
        throw new AssertionError();
    }

    @GwtIncompatible(value="TODO")
    private static long sqrtFloor(long x) {
        long guess = (long)Math.sqrt(x);
        long guessSquared = guess * guess;
        if (x - guessSquared >= guess + guess + 1L) {
            ++guess;
        } else if (x < guessSquared) {
            --guess;
        }
        return guess;
    }

    @GwtIncompatible(value="TODO")
    public static long divide(long p, long q, RoundingMode mode2) {
        boolean increment2;
        Preconditions.checkNotNull(mode2);
        long div2 = p / q;
        long rem = p - q * div2;
        if (rem == 0L) {
            return div2;
        }
        int signum = 1 | (int)((p ^ q) >> 63);
        switch (mode2) {
            case UNNECESSARY: {
                MathPreconditions.checkRoundingUnnecessary(rem == 0L);
            }
            case DOWN: {
                increment2 = false;
                break;
            }
            case UP: {
                increment2 = true;
                break;
            }
            case CEILING: {
                increment2 = signum > 0;
                break;
            }
            case FLOOR: {
                increment2 = signum < 0;
                break;
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                long absRem = Math.abs(rem);
                long cmpRemToHalfDivisor = absRem - (Math.abs(q) - absRem);
                if (cmpRemToHalfDivisor == 0L) {
                    increment2 = mode2 == RoundingMode.HALF_UP | mode2 == RoundingMode.HALF_EVEN & (div2 & 1L) != 0L;
                    break;
                }
                increment2 = cmpRemToHalfDivisor > 0L;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return increment2 ? div2 + (long)signum : div2;
    }

    @GwtIncompatible(value="TODO")
    public static int mod(long x, int m) {
        return (int)LongMath.mod(x, (long)m);
    }

    @GwtIncompatible(value="TODO")
    public static long mod(long x, long m) {
        if (m <= 0L) {
            throw new ArithmeticException("Modulus " + m + " must be > 0");
        }
        long result2 = x % m;
        return result2 >= 0L ? result2 : result2 + m;
    }

    public static long gcd(long a2, long b2) {
        MathPreconditions.checkNonNegative("a", a2);
        MathPreconditions.checkNonNegative("b", b2);
        if (a2 == 0L) {
            return b2;
        }
        if (b2 == 0L) {
            return a2;
        }
        int aTwos = Long.numberOfTrailingZeros(a2);
        a2 >>= aTwos;
        int bTwos = Long.numberOfTrailingZeros(b2);
        b2 >>= bTwos;
        while (a2 != b2) {
            long delta2 = a2 - b2;
            long minDeltaOrZero = delta2 & delta2 >> 63;
            a2 = delta2 - minDeltaOrZero - minDeltaOrZero;
            b2 += minDeltaOrZero;
            a2 >>= Long.numberOfTrailingZeros(a2);
        }
        return a2 << Math.min(aTwos, bTwos);
    }

    @GwtIncompatible(value="TODO")
    public static long checkedAdd(long a2, long b2) {
        long result2 = a2 + b2;
        MathPreconditions.checkNoOverflow((a2 ^ b2) < 0L | (a2 ^ result2) >= 0L);
        return result2;
    }

    @GwtIncompatible(value="TODO")
    public static long checkedSubtract(long a2, long b2) {
        long result2 = a2 - b2;
        MathPreconditions.checkNoOverflow((a2 ^ b2) >= 0L | (a2 ^ result2) >= 0L);
        return result2;
    }

    @GwtIncompatible(value="TODO")
    public static long checkedMultiply(long a2, long b2) {
        int leadingZeros = Long.numberOfLeadingZeros(a2) + Long.numberOfLeadingZeros(a2 ^ 0xFFFFFFFFFFFFFFFFL) + Long.numberOfLeadingZeros(b2) + Long.numberOfLeadingZeros(b2 ^ 0xFFFFFFFFFFFFFFFFL);
        if (leadingZeros > 65) {
            return a2 * b2;
        }
        MathPreconditions.checkNoOverflow(leadingZeros >= 64);
        MathPreconditions.checkNoOverflow(a2 >= 0L | b2 != Long.MIN_VALUE);
        long result2 = a2 * b2;
        MathPreconditions.checkNoOverflow(a2 == 0L || result2 / a2 == b2);
        return result2;
    }

    @GwtIncompatible(value="TODO")
    public static long checkedPow(long b2, int k) {
        MathPreconditions.checkNonNegative("exponent", k);
        if (b2 >= -2L & b2 <= 2L) {
            switch ((int)b2) {
                case 0: {
                    return k == 0 ? 1L : 0L;
                }
                case 1: {
                    return 1L;
                }
                case -1: {
                    return (k & 1) == 0 ? 1L : -1L;
                }
                case 2: {
                    MathPreconditions.checkNoOverflow(k < 63);
                    return 1L << k;
                }
                case -2: {
                    MathPreconditions.checkNoOverflow(k < 64);
                    return (k & 1) == 0 ? 1L << k : -1L << k;
                }
            }
            throw new AssertionError();
        }
        long accum = 1L;
        while (true) {
            switch (k) {
                case 0: {
                    return accum;
                }
                case 1: {
                    return LongMath.checkedMultiply(accum, b2);
                }
            }
            if ((k & 1) != 0) {
                accum = LongMath.checkedMultiply(accum, b2);
            }
            if ((k >>= 1) <= 0) continue;
            MathPreconditions.checkNoOverflow(b2 <= 3037000499L);
            b2 *= b2;
        }
    }

    @GwtIncompatible(value="TODO")
    public static long factorial(int n) {
        MathPreconditions.checkNonNegative("n", n);
        return n < factorials.length ? factorials[n] : Long.MAX_VALUE;
    }

    public static long binomial(int n, int k) {
        MathPreconditions.checkNonNegative("n", n);
        MathPreconditions.checkNonNegative("k", k);
        Preconditions.checkArgument(k <= n, "k (%s) > n (%s)", k, n);
        if (k > n >> 1) {
            k = n - k;
        }
        switch (k) {
            case 0: {
                return 1L;
            }
            case 1: {
                return n;
            }
        }
        if (n < factorials.length) {
            return factorials[n] / (factorials[k] * factorials[n - k]);
        }
        if (k >= biggestBinomials.length || n > biggestBinomials[k]) {
            return Long.MAX_VALUE;
        }
        if (k < biggestSimpleBinomials.length && n <= biggestSimpleBinomials[k]) {
            long result2 = n--;
            for (int i = 2; i <= k; ++i) {
                result2 *= (long)n;
                result2 /= (long)i;
                --n;
            }
            return result2;
        }
        int nBits = LongMath.log2(n, RoundingMode.CEILING);
        long result3 = 1L;
        long numerator = n--;
        long denominator = 1L;
        int numeratorBits = nBits;
        int i = 2;
        while (i <= k) {
            if (numeratorBits + nBits < 63) {
                numerator *= (long)n;
                denominator *= (long)i;
                numeratorBits += nBits;
            } else {
                result3 = LongMath.multiplyFraction(result3, numerator, denominator);
                numerator = n;
                denominator = i;
                numeratorBits = nBits;
            }
            ++i;
            --n;
        }
        return LongMath.multiplyFraction(result3, numerator, denominator);
    }

    static long multiplyFraction(long x, long numerator, long denominator) {
        if (x == 1L) {
            return numerator / denominator;
        }
        long commonDivisor = LongMath.gcd(x, denominator);
        return (x /= commonDivisor) * (numerator / (denominator /= commonDivisor));
    }

    @GwtIncompatible(value="TODO")
    static boolean fitsInInt(long x) {
        return (long)((int)x) == x;
    }

    public static long mean(long x, long y2) {
        return (x & y2) + ((x ^ y2) >> 1);
    }

    private LongMath() {
    }
}

