/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.security.MessageDigest;
import javax.annotation.Nullable;

@Beta
public abstract class HashCode {
    private static final char[] hexDigits = "0123456789abcdef".toCharArray();

    HashCode() {
    }

    public abstract int asInt();

    public abstract long asLong();

    public abstract long padToLong();

    public abstract byte[] asBytes();

    public int writeBytesTo(byte[] dest, int offset, int maxLength2) {
        byte[] hash2 = this.asBytes();
        maxLength2 = Ints.min(maxLength2, hash2.length);
        Preconditions.checkPositionIndexes(offset, offset + maxLength2, dest.length);
        System.arraycopy(hash2, 0, dest, offset, maxLength2);
        return maxLength2;
    }

    public abstract int bits();

    public boolean equals(@Nullable Object object) {
        if (object instanceof HashCode) {
            HashCode that2 = (HashCode)object;
            return MessageDigest.isEqual(this.asBytes(), that2.asBytes());
        }
        return false;
    }

    public int hashCode() {
        return this.asInt();
    }

    public String toString() {
        byte[] bytes = this.asBytes();
        StringBuilder sb = new StringBuilder(2 * bytes.length);
        for (byte b2 : bytes) {
            sb.append(hexDigits[b2 >> 4 & 0xF]).append(hexDigits[b2 & 0xF]);
        }
        return sb.toString();
    }
}

