/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Array;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.SortedMap;
import java.util.SortedSet;

@GwtCompatible(emulated=true)
class Platform {
    static <T> T[] clone(T[] array) {
        return (Object[])array.clone();
    }

    static <T> T[] newArray(T[] reference, int length2) {
        Class<?> type = reference.getClass().getComponentType();
        Object[] result2 = (Object[])Array.newInstance(type, length2);
        return result2;
    }

    static MapMaker tryWeakKeys(MapMaker mapMaker) {
        return mapMaker.weakKeys();
    }

    static <K, V1, V2> SortedMap<K, V2> mapsTransformEntriesSortedMap(SortedMap<K, V1> fromMap, Maps.EntryTransformer<? super K, ? super V1, V2> transformer) {
        return fromMap instanceof NavigableMap ? Maps.transformEntries((NavigableMap)fromMap, transformer) : Maps.transformEntriesIgnoreNavigable(fromMap, transformer);
    }

    static <K, V> SortedMap<K, V> mapsAsMapSortedSet(SortedSet<K> set2, Function<? super K, V> function2) {
        return set2 instanceof NavigableSet ? Maps.asMap((NavigableSet)set2, function2) : Maps.asMapSortedIgnoreNavigable(set2, function2);
    }

    static <E> SortedSet<E> setsFilterSortedSet(SortedSet<E> set2, Predicate<? super E> predicate) {
        return set2 instanceof NavigableSet ? Sets.filter((NavigableSet)set2, predicate) : Sets.filterSortedIgnoreNavigable(set2, predicate);
    }

    static <K, V> SortedMap<K, V> mapsFilterSortedMap(SortedMap<K, V> map2, Predicate<? super Map.Entry<K, V>> predicate) {
        return map2 instanceof NavigableMap ? Maps.filterEntries((NavigableMap)map2, predicate) : Maps.filterSortedIgnoreNavigable(map2, predicate);
    }

    private Platform() {
    }
}

