/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.AllEqualOrdering;
import com.google.common.collect.ByFunctionOrdering;
import com.google.common.collect.ComparatorOrdering;
import com.google.common.collect.CompoundOrdering;
import com.google.common.collect.ExplicitOrdering;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.LexicographicalOrdering;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.NaturalOrdering;
import com.google.common.collect.NullsFirstOrdering;
import com.google.common.collect.NullsLastOrdering;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.Platform;
import com.google.common.collect.ReverseOrdering;
import com.google.common.collect.UsingToStringOrdering;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

@GwtCompatible
public abstract class Ordering<T>
implements Comparator<T> {
    static final int LEFT_IS_GREATER = 1;
    static final int RIGHT_IS_GREATER = -1;

    @GwtCompatible(serializable=true)
    public static <C extends Comparable> Ordering<C> natural() {
        return NaturalOrdering.INSTANCE;
    }

    @GwtCompatible(serializable=true)
    public static <T> Ordering<T> from(Comparator<T> comparator) {
        return comparator instanceof Ordering ? (Ordering<T>)comparator : new ComparatorOrdering<T>(comparator);
    }

    @Deprecated
    @GwtCompatible(serializable=true)
    public static <T> Ordering<T> from(Ordering<T> ordering2) {
        return Preconditions.checkNotNull(ordering2);
    }

    @GwtCompatible(serializable=true)
    public static <T> Ordering<T> explicit(List<T> valuesInOrder) {
        return new ExplicitOrdering<T>(valuesInOrder);
    }

    @GwtCompatible(serializable=true)
    public static <T> Ordering<T> explicit(T leastValue, T ... remainingValuesInOrder) {
        return Ordering.explicit(Lists.asList(leastValue, remainingValuesInOrder));
    }

    @GwtCompatible(serializable=true)
    public static Ordering<Object> allEqual() {
        return AllEqualOrdering.INSTANCE;
    }

    @GwtCompatible(serializable=true)
    public static Ordering<Object> usingToString() {
        return UsingToStringOrdering.INSTANCE;
    }

    public static Ordering<Object> arbitrary() {
        return ArbitraryOrderingHolder.ARBITRARY_ORDERING;
    }

    protected Ordering() {
    }

    @GwtCompatible(serializable=true)
    public <S extends T> Ordering<S> reverse() {
        return new ReverseOrdering(this);
    }

    @GwtCompatible(serializable=true)
    public <S extends T> Ordering<S> nullsFirst() {
        return new NullsFirstOrdering(this);
    }

    @GwtCompatible(serializable=true)
    public <S extends T> Ordering<S> nullsLast() {
        return new NullsLastOrdering(this);
    }

    @GwtCompatible(serializable=true)
    public <F> Ordering<F> onResultOf(Function<F, ? extends T> function2) {
        return new ByFunctionOrdering<F, T>(function2, this);
    }

    @GwtCompatible(serializable=true)
    public <U extends T> Ordering<U> compound(Comparator<? super U> secondaryComparator) {
        return new CompoundOrdering<U>(this, Preconditions.checkNotNull(secondaryComparator));
    }

    @GwtCompatible(serializable=true)
    public static <T> Ordering<T> compound(Iterable<? extends Comparator<? super T>> comparators) {
        return new CompoundOrdering(comparators);
    }

    @GwtCompatible(serializable=true)
    public <S extends T> Ordering<Iterable<S>> lexicographical() {
        return new LexicographicalOrdering(this);
    }

    @Override
    public abstract int compare(@Nullable T var1, @Nullable T var2);

    public <E extends T> E min(Iterator<E> iterator2) {
        E minSoFar = iterator2.next();
        while (iterator2.hasNext()) {
            minSoFar = this.min(minSoFar, iterator2.next());
        }
        return minSoFar;
    }

    public <E extends T> E min(Iterable<E> iterable2) {
        return this.min(iterable2.iterator());
    }

    public <E extends T> E min(@Nullable E a2, @Nullable E b2) {
        return this.compare(a2, b2) <= 0 ? a2 : b2;
    }

    public <E extends T> E min(@Nullable E a2, @Nullable E b2, @Nullable E c, E ... rest) {
        E minSoFar = this.min(this.min(a2, b2), c);
        for (E r : rest) {
            minSoFar = this.min(minSoFar, r);
        }
        return minSoFar;
    }

    public <E extends T> E max(Iterator<E> iterator2) {
        E maxSoFar = iterator2.next();
        while (iterator2.hasNext()) {
            maxSoFar = this.max(maxSoFar, iterator2.next());
        }
        return maxSoFar;
    }

    public <E extends T> E max(Iterable<E> iterable2) {
        return this.max(iterable2.iterator());
    }

    public <E extends T> E max(@Nullable E a2, @Nullable E b2) {
        return this.compare(a2, b2) >= 0 ? a2 : b2;
    }

    public <E extends T> E max(@Nullable E a2, @Nullable E b2, @Nullable E c, E ... rest) {
        E maxSoFar = this.max(this.max(a2, b2), c);
        for (E r : rest) {
            maxSoFar = this.max(maxSoFar, r);
        }
        return maxSoFar;
    }

    public <E extends T> List<E> leastOf(Iterable<E> iterable2, int k) {
        Collection collection;
        if (iterable2 instanceof Collection && (long)(collection = (Collection)iterable2).size() <= 2L * (long)k) {
            Object[] array = collection.toArray();
            Arrays.sort(array, this);
            if (array.length > k) {
                array = ObjectArrays.arraysCopyOf(array, k);
            }
            return Collections.unmodifiableList(Arrays.asList(array));
        }
        return this.leastOf(iterable2.iterator(), k);
    }

    public <E extends T> List<E> leastOf(Iterator<E> elements, int k) {
        E e;
        Preconditions.checkNotNull(elements);
        Preconditions.checkArgument(k >= 0, "k (%s) must be nonnegative", k);
        if (k == 0 || !elements.hasNext()) {
            return ImmutableList.of();
        }
        if (k >= 0x3FFFFFFF) {
            ArrayList<E> list2 = Lists.newArrayList(elements);
            Collections.sort(list2, this);
            if (list2.size() > k) {
                list2.subList(k, list2.size()).clear();
            }
            list2.trimToSize();
            return Collections.unmodifiableList(list2);
        }
        int bufferCap = k * 2;
        Object[] buffer2 = new Object[bufferCap];
        Object threshold = elements.next();
        buffer2[0] = threshold;
        int bufferSize = 1;
        while (bufferSize < k && elements.hasNext()) {
            e = elements.next();
            buffer2[bufferSize++] = e;
            threshold = this.max(threshold, e);
        }
        while (elements.hasNext()) {
            e = elements.next();
            if (this.compare(e, threshold) >= 0) continue;
            buffer2[bufferSize++] = e;
            if (bufferSize != bufferCap) continue;
            int left2 = 0;
            int right2 = bufferCap - 1;
            int minThresholdPosition = 0;
            while (left2 < right2) {
                int pivotIndex = left2 + right2 + 1 >>> 1;
                int pivotNewIndex = this.partition(buffer2, left2, right2, pivotIndex);
                if (pivotNewIndex > k) {
                    right2 = pivotNewIndex - 1;
                    continue;
                }
                if (pivotNewIndex >= k) break;
                left2 = Math.max(pivotNewIndex, left2 + 1);
                minThresholdPosition = pivotNewIndex;
            }
            bufferSize = k;
            threshold = buffer2[minThresholdPosition];
            for (int i = minThresholdPosition + 1; i < bufferSize; ++i) {
                threshold = this.max(threshold, buffer2[i]);
            }
        }
        Arrays.sort(buffer2, 0, bufferSize, this);
        bufferSize = Math.min(bufferSize, k);
        return Collections.unmodifiableList(Arrays.asList(ObjectArrays.arraysCopyOf(buffer2, bufferSize)));
    }

    private <E extends T> int partition(E[] values2, int left2, int right2, int pivotIndex) {
        E pivotValue = values2[pivotIndex];
        values2[pivotIndex] = values2[right2];
        values2[right2] = pivotValue;
        int storeIndex = left2;
        for (int i = left2; i < right2; ++i) {
            if (this.compare(values2[i], pivotValue) >= 0) continue;
            ObjectArrays.swap(values2, storeIndex, i);
            ++storeIndex;
        }
        ObjectArrays.swap(values2, right2, storeIndex);
        return storeIndex;
    }

    public <E extends T> List<E> greatestOf(Iterable<E> iterable2, int k) {
        return this.reverse().leastOf(iterable2, k);
    }

    public <E extends T> List<E> greatestOf(Iterator<E> iterator2, int k) {
        return this.reverse().leastOf(iterator2, k);
    }

    public <E extends T> List<E> sortedCopy(Iterable<E> iterable2) {
        Object[] array = Iterables.toArray(iterable2);
        Arrays.sort(array, this);
        return Lists.newArrayList(Arrays.asList(array));
    }

    public <E extends T> ImmutableList<E> immutableSortedCopy(Iterable<E> iterable2) {
        Object[] elements;
        for (Object e : elements = Iterables.toArray(iterable2)) {
            Preconditions.checkNotNull(e);
        }
        Arrays.sort(elements, this);
        return ImmutableList.asImmutableList(elements);
    }

    public boolean isOrdered(Iterable<? extends T> iterable2) {
        Iterator<T> it = iterable2.iterator();
        if (it.hasNext()) {
            T prev = it.next();
            while (it.hasNext()) {
                T next2 = it.next();
                if (this.compare(prev, next2) > 0) {
                    return false;
                }
                prev = next2;
            }
        }
        return true;
    }

    public boolean isStrictlyOrdered(Iterable<? extends T> iterable2) {
        Iterator<T> it = iterable2.iterator();
        if (it.hasNext()) {
            T prev = it.next();
            while (it.hasNext()) {
                T next2 = it.next();
                if (this.compare(prev, next2) >= 0) {
                    return false;
                }
                prev = next2;
            }
        }
        return true;
    }

    public int binarySearch(List<? extends T> sortedList, @Nullable T key) {
        return Collections.binarySearch(sortedList, key, this);
    }

    @VisibleForTesting
    static class IncomparableValueException
    extends ClassCastException {
        final Object value;
        private static final long serialVersionUID = 0L;

        IncomparableValueException(Object value2) {
            super("Cannot compare value: " + value2);
            this.value = value2;
        }
    }

    @VisibleForTesting
    static class ArbitraryOrdering
    extends Ordering<Object> {
        private Map<Object, Integer> uids = Platform.tryWeakKeys(new MapMaker()).makeComputingMap(new Function<Object, Integer>(){
            final AtomicInteger counter = new AtomicInteger(0);

            @Override
            public Integer apply(Object from2) {
                return this.counter.getAndIncrement();
            }
        });

        ArbitraryOrdering() {
        }

        @Override
        public int compare(Object left2, Object right2) {
            int rightCode;
            if (left2 == right2) {
                return 0;
            }
            if (left2 == null) {
                return -1;
            }
            if (right2 == null) {
                return 1;
            }
            int leftCode = this.identityHashCode(left2);
            if (leftCode != (rightCode = this.identityHashCode(right2))) {
                return leftCode < rightCode ? -1 : 1;
            }
            int result2 = this.uids.get(left2).compareTo(this.uids.get(right2));
            if (result2 == 0) {
                throw new AssertionError();
            }
            return result2;
        }

        public String toString() {
            return "Ordering.arbitrary()";
        }

        int identityHashCode(Object object) {
            return System.identityHashCode(object);
        }
    }

    private static class ArbitraryOrderingHolder {
        static final Ordering<Object> ARBITRARY_ORDERING = new ArbitraryOrdering();

        private ArbitraryOrderingHolder() {
        }
    }
}

