/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.CartesianList;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.TransformedListIterator;
import com.google.common.primitives.Ints;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nullable;

@GwtCompatible(emulated=true)
public final class Lists {
    private Lists() {
    }

    @GwtCompatible(serializable=true)
    public static <E> ArrayList<E> newArrayList() {
        return new ArrayList();
    }

    @GwtCompatible(serializable=true)
    public static <E> ArrayList<E> newArrayList(E ... elements) {
        Preconditions.checkNotNull(elements);
        int capacity = Lists.computeArrayListCapacity(elements.length);
        ArrayList list2 = new ArrayList(capacity);
        Collections.addAll(list2, elements);
        return list2;
    }

    @VisibleForTesting
    static int computeArrayListCapacity(int arraySize) {
        Preconditions.checkArgument(arraySize >= 0);
        return Ints.saturatedCast(5L + (long)arraySize + (long)(arraySize / 10));
    }

    @GwtCompatible(serializable=true)
    public static <E> ArrayList<E> newArrayList(Iterable<? extends E> elements) {
        Preconditions.checkNotNull(elements);
        return elements instanceof Collection ? new ArrayList<E>(Collections2.cast(elements)) : Lists.newArrayList(elements.iterator());
    }

    @GwtCompatible(serializable=true)
    public static <E> ArrayList<E> newArrayList(Iterator<? extends E> elements) {
        Preconditions.checkNotNull(elements);
        ArrayList<E> list2 = Lists.newArrayList();
        while (elements.hasNext()) {
            list2.add(elements.next());
        }
        return list2;
    }

    @GwtCompatible(serializable=true)
    public static <E> ArrayList<E> newArrayListWithCapacity(int initialArraySize) {
        Preconditions.checkArgument(initialArraySize >= 0);
        return new ArrayList(initialArraySize);
    }

    @GwtCompatible(serializable=true)
    public static <E> ArrayList<E> newArrayListWithExpectedSize(int estimatedSize) {
        return new ArrayList(Lists.computeArrayListCapacity(estimatedSize));
    }

    @GwtCompatible(serializable=true)
    public static <E> LinkedList<E> newLinkedList() {
        return new LinkedList();
    }

    @GwtCompatible(serializable=true)
    public static <E> LinkedList<E> newLinkedList(Iterable<? extends E> elements) {
        LinkedList<E> list2 = Lists.newLinkedList();
        for (E element2 : elements) {
            list2.add(element2);
        }
        return list2;
    }

    @GwtIncompatible(value="CopyOnWriteArrayList")
    public static <E> CopyOnWriteArrayList<E> newCopyOnWriteArrayList() {
        return new CopyOnWriteArrayList();
    }

    @GwtIncompatible(value="CopyOnWriteArrayList")
    public static <E> CopyOnWriteArrayList<E> newCopyOnWriteArrayList(Iterable<? extends E> elements) {
        Collection<? extends E> elementsCollection = elements instanceof Collection ? Collections2.cast(elements) : Lists.newArrayList(elements);
        return new CopyOnWriteArrayList<E>(elementsCollection);
    }

    public static <E> List<E> asList(@Nullable E first2, E[] rest) {
        return new OnePlusArrayList<E>(first2, rest);
    }

    public static <E> List<E> asList(@Nullable E first2, @Nullable E second2, E[] rest) {
        return new TwoPlusArrayList<E>(first2, second2, rest);
    }

    static <B> List<List<B>> cartesianProduct(List<? extends List<? extends B>> lists) {
        return CartesianList.create(lists);
    }

    static <B> List<List<B>> cartesianProduct(List<? extends B> ... lists) {
        return Lists.cartesianProduct(Arrays.asList(lists));
    }

    public static <F, T> List<T> transform(List<F> fromList2, Function<? super F, ? extends T> function2) {
        return fromList2 instanceof RandomAccess ? new TransformingRandomAccessList<F, T>(fromList2, function2) : new TransformingSequentialList<F, T>(fromList2, function2);
    }

    public static <T> List<List<T>> partition(List<T> list2, int size2) {
        Preconditions.checkNotNull(list2);
        Preconditions.checkArgument(size2 > 0);
        return list2 instanceof RandomAccess ? new RandomAccessPartition<T>(list2, size2) : new Partition<T>(list2, size2);
    }

    @Beta
    public static ImmutableList<Character> charactersOf(String string2) {
        return new StringAsImmutableList(Preconditions.checkNotNull(string2));
    }

    @Beta
    public static List<Character> charactersOf(CharSequence sequence2) {
        return new CharSequenceAsList(Preconditions.checkNotNull(sequence2));
    }

    public static <T> List<T> reverse(List<T> list2) {
        if (list2 instanceof ReverseList) {
            return ((ReverseList)list2).getForwardList();
        }
        if (list2 instanceof RandomAccess) {
            return new RandomAccessReverseList<T>(list2);
        }
        return new ReverseList<T>(list2);
    }

    static int hashCodeImpl(List<?> list2) {
        int hashCode2 = 1;
        for (Object o : list2) {
            hashCode2 = 31 * hashCode2 + (o == null ? 0 : o.hashCode());
            hashCode2 = ~(~hashCode2);
        }
        return hashCode2;
    }

    static boolean equalsImpl(List<?> list2, @Nullable Object object) {
        if (object == Preconditions.checkNotNull(list2)) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List o = (List)object;
        return list2.size() == o.size() && Iterators.elementsEqual(list2.iterator(), o.iterator());
    }

    static <E> boolean addAllImpl(List<E> list2, int index2, Iterable<? extends E> elements) {
        boolean changed = false;
        ListIterator<E> listIterator = list2.listIterator(index2);
        for (E e : elements) {
            listIterator.add(e);
            changed = true;
        }
        return changed;
    }

    static int indexOfImpl(List<?> list2, @Nullable Object element2) {
        ListIterator<?> listIterator = list2.listIterator();
        while (listIterator.hasNext()) {
            if (!Objects.equal(element2, listIterator.next())) continue;
            return listIterator.previousIndex();
        }
        return -1;
    }

    static int lastIndexOfImpl(List<?> list2, @Nullable Object element2) {
        ListIterator<?> listIterator = list2.listIterator(list2.size());
        while (listIterator.hasPrevious()) {
            if (!Objects.equal(element2, listIterator.previous())) continue;
            return listIterator.nextIndex();
        }
        return -1;
    }

    static <E> ListIterator<E> listIteratorImpl(List<E> list2, int index2) {
        return new AbstractListWrapper<E>(list2).listIterator(index2);
    }

    static <E> List<E> subListImpl(List<E> list2, int fromIndex, int toIndex) {
        AbstractListWrapper wrapper = list2 instanceof RandomAccess ? new RandomAccessListWrapper<E>((List)list2){
            private static final long serialVersionUID = 0L;

            @Override
            public ListIterator<E> listIterator(int index2) {
                return this.backingList.listIterator(index2);
            }
        } : new AbstractListWrapper<E>((List)list2){
            private static final long serialVersionUID = 0L;

            @Override
            public ListIterator<E> listIterator(int index2) {
                return this.backingList.listIterator(index2);
            }
        };
        return wrapper.subList(fromIndex, toIndex);
    }

    static <T> List<T> cast(Iterable<T> iterable2) {
        return (List)iterable2;
    }

    private static class RandomAccessListWrapper<E>
    extends AbstractListWrapper<E>
    implements RandomAccess {
        RandomAccessListWrapper(List<E> backingList) {
            super(backingList);
        }
    }

    private static class AbstractListWrapper<E>
    extends AbstractList<E> {
        final List<E> backingList;

        AbstractListWrapper(List<E> backingList) {
            this.backingList = Preconditions.checkNotNull(backingList);
        }

        @Override
        public void add(int index2, E element2) {
            this.backingList.add(index2, element2);
        }

        @Override
        public boolean addAll(int index2, Collection<? extends E> c) {
            return this.backingList.addAll(index2, c);
        }

        @Override
        public E get(int index2) {
            return this.backingList.get(index2);
        }

        @Override
        public E remove(int index2) {
            return this.backingList.remove(index2);
        }

        @Override
        public E set(int index2, E element2) {
            return this.backingList.set(index2, element2);
        }

        @Override
        public boolean contains(Object o) {
            return this.backingList.contains(o);
        }

        @Override
        public int size() {
            return this.backingList.size();
        }
    }

    private static class RandomAccessReverseList<T>
    extends ReverseList<T>
    implements RandomAccess {
        RandomAccessReverseList(List<T> forwardList) {
            super(forwardList);
        }
    }

    private static class ReverseList<T>
    extends AbstractList<T> {
        private final List<T> forwardList;

        ReverseList(List<T> forwardList) {
            this.forwardList = Preconditions.checkNotNull(forwardList);
        }

        List<T> getForwardList() {
            return this.forwardList;
        }

        private int reverseIndex(int index2) {
            int size2 = this.size();
            Preconditions.checkElementIndex(index2, size2);
            return size2 - 1 - index2;
        }

        private int reversePosition(int index2) {
            int size2 = this.size();
            Preconditions.checkPositionIndex(index2, size2);
            return size2 - index2;
        }

        @Override
        public void add(int index2, @Nullable T element2) {
            this.forwardList.add(this.reversePosition(index2), element2);
        }

        @Override
        public void clear() {
            this.forwardList.clear();
        }

        @Override
        public T remove(int index2) {
            return this.forwardList.remove(this.reverseIndex(index2));
        }

        @Override
        protected void removeRange(int fromIndex, int toIndex) {
            this.subList(fromIndex, toIndex).clear();
        }

        @Override
        public T set(int index2, @Nullable T element2) {
            return this.forwardList.set(this.reverseIndex(index2), element2);
        }

        @Override
        public T get(int index2) {
            return this.forwardList.get(this.reverseIndex(index2));
        }

        @Override
        public boolean isEmpty() {
            return this.forwardList.isEmpty();
        }

        @Override
        public int size() {
            return this.forwardList.size();
        }

        @Override
        public boolean contains(@Nullable Object o) {
            return this.forwardList.contains(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.forwardList.containsAll(c);
        }

        @Override
        public List<T> subList(int fromIndex, int toIndex) {
            Preconditions.checkPositionIndexes(fromIndex, toIndex, this.size());
            return Lists.reverse(this.forwardList.subList(this.reversePosition(toIndex), this.reversePosition(fromIndex)));
        }

        @Override
        public int indexOf(@Nullable Object o) {
            int index2 = this.forwardList.lastIndexOf(o);
            return index2 >= 0 ? this.reverseIndex(index2) : -1;
        }

        @Override
        public int lastIndexOf(@Nullable Object o) {
            int index2 = this.forwardList.indexOf(o);
            return index2 >= 0 ? this.reverseIndex(index2) : -1;
        }

        @Override
        public Iterator<T> iterator() {
            return this.listIterator();
        }

        @Override
        public ListIterator<T> listIterator(int index2) {
            int start2 = this.reversePosition(index2);
            final ListIterator<T> forwardIterator = this.forwardList.listIterator(start2);
            return new ListIterator<T>(){
                boolean canRemove;
                boolean canSet;

                @Override
                public void add(T e) {
                    forwardIterator.add(e);
                    forwardIterator.previous();
                    this.canRemove = false;
                    this.canSet = false;
                }

                @Override
                public boolean hasNext() {
                    return forwardIterator.hasPrevious();
                }

                @Override
                public boolean hasPrevious() {
                    return forwardIterator.hasNext();
                }

                @Override
                public T next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.canRemove = true;
                    this.canSet = true;
                    return forwardIterator.previous();
                }

                @Override
                public int nextIndex() {
                    return ReverseList.this.reversePosition(forwardIterator.nextIndex());
                }

                @Override
                public T previous() {
                    if (!this.hasPrevious()) {
                        throw new NoSuchElementException();
                    }
                    this.canRemove = true;
                    this.canSet = true;
                    return forwardIterator.next();
                }

                @Override
                public int previousIndex() {
                    return this.nextIndex() - 1;
                }

                @Override
                public void remove() {
                    Preconditions.checkState(this.canRemove);
                    forwardIterator.remove();
                    this.canSet = false;
                    this.canRemove = false;
                }

                @Override
                public void set(T e) {
                    Preconditions.checkState(this.canSet);
                    forwardIterator.set(e);
                }
            };
        }
    }

    private static final class CharSequenceAsList
    extends AbstractList<Character> {
        private final CharSequence sequence;

        CharSequenceAsList(CharSequence sequence2) {
            this.sequence = sequence2;
        }

        @Override
        public Character get(int index2) {
            Preconditions.checkElementIndex(index2, this.size());
            return Character.valueOf(this.sequence.charAt(index2));
        }

        @Override
        public boolean contains(@Nullable Object o) {
            return this.indexOf(o) >= 0;
        }

        @Override
        public int indexOf(@Nullable Object o) {
            if (o instanceof Character) {
                char c = ((Character)o).charValue();
                for (int i = 0; i < this.sequence.length(); ++i) {
                    if (this.sequence.charAt(i) != c) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public int lastIndexOf(@Nullable Object o) {
            if (o instanceof Character) {
                char c = ((Character)o).charValue();
                for (int i = this.sequence.length() - 1; i >= 0; --i) {
                    if (this.sequence.charAt(i) != c) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public int size() {
            return this.sequence.length();
        }

        @Override
        public List<Character> subList(int fromIndex, int toIndex) {
            Preconditions.checkPositionIndexes(fromIndex, toIndex, this.size());
            return Lists.charactersOf(this.sequence.subSequence(fromIndex, toIndex));
        }

        @Override
        public int hashCode() {
            int hash2 = 1;
            for (int i = 0; i < this.sequence.length(); ++i) {
                hash2 = hash2 * 31 + this.sequence.charAt(i);
            }
            return hash2;
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (!(o instanceof List)) {
                return false;
            }
            List list2 = (List)o;
            int n = this.sequence.length();
            if (n != list2.size()) {
                return false;
            }
            Iterator iterator2 = list2.iterator();
            for (int i = 0; i < n; ++i) {
                Object elem = iterator2.next();
                if (elem instanceof Character && ((Character)elem).charValue() == this.sequence.charAt(i)) continue;
                return false;
            }
            return true;
        }
    }

    private static final class StringAsImmutableList
    extends ImmutableList<Character> {
        private final String string;
        int hash = 0;

        StringAsImmutableList(String string2) {
            this.string = string2;
        }

        @Override
        public int indexOf(@Nullable Object object) {
            return object instanceof Character ? this.string.indexOf(((Character)object).charValue()) : -1;
        }

        @Override
        public int lastIndexOf(@Nullable Object object) {
            return object instanceof Character ? this.string.lastIndexOf(((Character)object).charValue()) : -1;
        }

        @Override
        public ImmutableList<Character> subList(int fromIndex, int toIndex) {
            Preconditions.checkPositionIndexes(fromIndex, toIndex, this.size());
            return Lists.charactersOf(this.string.substring(fromIndex, toIndex));
        }

        @Override
        boolean isPartialView() {
            return false;
        }

        @Override
        public Character get(int index2) {
            Preconditions.checkElementIndex(index2, this.size());
            return Character.valueOf(this.string.charAt(index2));
        }

        @Override
        public int size() {
            return this.string.length();
        }

        @Override
        public boolean equals(@Nullable Object obj2) {
            if (!(obj2 instanceof List)) {
                return false;
            }
            List list2 = (List)obj2;
            int n = this.string.length();
            if (n != list2.size()) {
                return false;
            }
            Iterator iterator2 = list2.iterator();
            for (int i = 0; i < n; ++i) {
                Object elem = iterator2.next();
                if (elem instanceof Character && ((Character)elem).charValue() == this.string.charAt(i)) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            int h2 = this.hash;
            if (h2 == 0) {
                h2 = 1;
                for (int i = 0; i < this.string.length(); ++i) {
                    h2 = h2 * 31 + this.string.charAt(i);
                }
                this.hash = h2;
            }
            return h2;
        }
    }

    private static class RandomAccessPartition<T>
    extends Partition<T>
    implements RandomAccess {
        RandomAccessPartition(List<T> list2, int size2) {
            super(list2, size2);
        }
    }

    private static class Partition<T>
    extends AbstractList<List<T>> {
        final List<T> list;
        final int size;

        Partition(List<T> list2, int size2) {
            this.list = list2;
            this.size = size2;
        }

        @Override
        public List<T> get(int index2) {
            int listSize = this.size();
            Preconditions.checkElementIndex(index2, listSize);
            int start2 = index2 * this.size;
            int end2 = Math.min(start2 + this.size, this.list.size());
            return this.list.subList(start2, end2);
        }

        @Override
        public int size() {
            int result2 = this.list.size() / this.size;
            if (result2 * this.size != this.list.size()) {
                ++result2;
            }
            return result2;
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }
    }

    private static class TransformingRandomAccessList<F, T>
    extends AbstractList<T>
    implements RandomAccess,
    Serializable {
        final List<F> fromList;
        final Function<? super F, ? extends T> function;
        private static final long serialVersionUID = 0L;

        TransformingRandomAccessList(List<F> fromList2, Function<? super F, ? extends T> function2) {
            this.fromList = Preconditions.checkNotNull(fromList2);
            this.function = Preconditions.checkNotNull(function2);
        }

        @Override
        public void clear() {
            this.fromList.clear();
        }

        @Override
        public T get(int index2) {
            return this.function.apply(this.fromList.get(index2));
        }

        @Override
        public boolean isEmpty() {
            return this.fromList.isEmpty();
        }

        @Override
        public T remove(int index2) {
            return this.function.apply(this.fromList.remove(index2));
        }

        @Override
        public int size() {
            return this.fromList.size();
        }
    }

    private static class TransformingSequentialList<F, T>
    extends AbstractSequentialList<T>
    implements Serializable {
        final List<F> fromList;
        final Function<? super F, ? extends T> function;
        private static final long serialVersionUID = 0L;

        TransformingSequentialList(List<F> fromList2, Function<? super F, ? extends T> function2) {
            this.fromList = Preconditions.checkNotNull(fromList2);
            this.function = Preconditions.checkNotNull(function2);
        }

        @Override
        public void clear() {
            this.fromList.clear();
        }

        @Override
        public int size() {
            return this.fromList.size();
        }

        @Override
        public ListIterator<T> listIterator(int index2) {
            return new TransformedListIterator<F, T>(this.fromList.listIterator(index2)){

                @Override
                T transform(F from2) {
                    return TransformingSequentialList.this.function.apply(from2);
                }
            };
        }
    }

    private static class TwoPlusArrayList<E>
    extends AbstractList<E>
    implements Serializable,
    RandomAccess {
        final E first;
        final E second;
        final E[] rest;
        private static final long serialVersionUID = 0L;

        TwoPlusArrayList(@Nullable E first2, @Nullable E second2, E[] rest) {
            this.first = first2;
            this.second = second2;
            this.rest = Preconditions.checkNotNull(rest);
        }

        @Override
        public int size() {
            return this.rest.length + 2;
        }

        @Override
        public E get(int index2) {
            switch (index2) {
                case 0: {
                    return this.first;
                }
                case 1: {
                    return this.second;
                }
            }
            Preconditions.checkElementIndex(index2, this.size());
            return this.rest[index2 - 2];
        }
    }

    private static class OnePlusArrayList<E>
    extends AbstractList<E>
    implements Serializable,
    RandomAccess {
        final E first;
        final E[] rest;
        private static final long serialVersionUID = 0L;

        OnePlusArrayList(@Nullable E first2, E[] rest) {
            this.first = first2;
            this.rest = Preconditions.checkNotNull(rest);
        }

        @Override
        public int size() {
            return this.rest.length + 1;
        }

        @Override
        public E get(int index2) {
            Preconditions.checkElementIndex(index2, this.size());
            return index2 == 0 ? this.first : this.rest[index2 - 1];
        }
    }
}

