/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Collections2;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.Nullable;

@GwtCompatible(emulated=true)
public final class Iterables {
    private Iterables() {
    }

    public static <T> Iterable<T> unmodifiableIterable(Iterable<T> iterable2) {
        Preconditions.checkNotNull(iterable2);
        if (iterable2 instanceof UnmodifiableIterable || iterable2 instanceof ImmutableCollection) {
            return iterable2;
        }
        return new UnmodifiableIterable(iterable2);
    }

    @Deprecated
    public static <E> Iterable<E> unmodifiableIterable(ImmutableCollection<E> iterable2) {
        return Preconditions.checkNotNull(iterable2);
    }

    public static int size(Iterable<?> iterable2) {
        return iterable2 instanceof Collection ? ((Collection)iterable2).size() : Iterators.size(iterable2.iterator());
    }

    public static boolean contains(Iterable<?> iterable2, @Nullable Object element2) {
        if (iterable2 instanceof Collection) {
            Collection collection = (Collection)iterable2;
            return Collections2.safeContains(collection, element2);
        }
        return Iterators.contains(iterable2.iterator(), element2);
    }

    public static boolean removeAll(Iterable<?> removeFrom, Collection<?> elementsToRemove) {
        return removeFrom instanceof Collection ? ((Collection)removeFrom).removeAll(Preconditions.checkNotNull(elementsToRemove)) : Iterators.removeAll(removeFrom.iterator(), elementsToRemove);
    }

    public static boolean retainAll(Iterable<?> removeFrom, Collection<?> elementsToRetain) {
        return removeFrom instanceof Collection ? ((Collection)removeFrom).retainAll(Preconditions.checkNotNull(elementsToRetain)) : Iterators.retainAll(removeFrom.iterator(), elementsToRetain);
    }

    public static <T> boolean removeIf(Iterable<T> removeFrom, Predicate<? super T> predicate) {
        if (removeFrom instanceof RandomAccess && removeFrom instanceof List) {
            return Iterables.removeIfFromRandomAccessList((List)removeFrom, Preconditions.checkNotNull(predicate));
        }
        return Iterators.removeIf(removeFrom.iterator(), predicate);
    }

    private static <T> boolean removeIfFromRandomAccessList(List<T> list2, Predicate<? super T> predicate) {
        int from2;
        int to2 = 0;
        for (from2 = 0; from2 < list2.size(); ++from2) {
            T element2 = list2.get(from2);
            if (predicate.apply(element2)) continue;
            if (from2 > to2) {
                try {
                    list2.set(to2, element2);
                }
                catch (UnsupportedOperationException e) {
                    Iterables.slowRemoveIfForRemainingElements(list2, predicate, to2, from2);
                    return true;
                }
            }
            ++to2;
        }
        list2.subList(to2, list2.size()).clear();
        return from2 != to2;
    }

    private static <T> void slowRemoveIfForRemainingElements(List<T> list2, Predicate<? super T> predicate, int to2, int from2) {
        int n;
        for (n = list2.size() - 1; n > from2; --n) {
            if (!predicate.apply(list2.get(n))) continue;
            list2.remove(n);
        }
        for (n = from2 - 1; n >= to2; --n) {
            list2.remove(n);
        }
    }

    public static boolean elementsEqual(Iterable<?> iterable1, Iterable<?> iterable2) {
        if (iterable1 instanceof Collection && iterable2 instanceof Collection) {
            Collection collection1 = (Collection)iterable1;
            Collection collection2 = (Collection)iterable2;
            if (collection1.size() != collection2.size()) {
                return false;
            }
        }
        return Iterators.elementsEqual(iterable1.iterator(), iterable2.iterator());
    }

    public static String toString(Iterable<?> iterable2) {
        return Iterators.toString(iterable2.iterator());
    }

    public static <T> T getOnlyElement(Iterable<T> iterable2) {
        return Iterators.getOnlyElement(iterable2.iterator());
    }

    @Nullable
    public static <T> T getOnlyElement(Iterable<? extends T> iterable2, @Nullable T defaultValue) {
        return Iterators.getOnlyElement(iterable2.iterator(), defaultValue);
    }

    @GwtIncompatible(value="Array.newInstance(Class, int)")
    public static <T> T[] toArray(Iterable<? extends T> iterable2, Class<T> type) {
        Collection<T> collection = Iterables.toCollection(iterable2);
        T[] array = ObjectArrays.newArray(type, collection.size());
        return collection.toArray(array);
    }

    static Object[] toArray(Iterable<?> iterable2) {
        return Iterables.toCollection(iterable2).toArray();
    }

    private static <E> Collection<E> toCollection(Iterable<E> iterable2) {
        return iterable2 instanceof Collection ? (ArrayList<E>)iterable2 : Lists.newArrayList(iterable2.iterator());
    }

    public static <T> boolean addAll(Collection<T> addTo, Iterable<? extends T> elementsToAdd) {
        if (elementsToAdd instanceof Collection) {
            Collection<? extends T> c = Collections2.cast(elementsToAdd);
            return addTo.addAll(c);
        }
        return Iterators.addAll(addTo, elementsToAdd.iterator());
    }

    public static int frequency(Iterable<?> iterable2, @Nullable Object element2) {
        if (iterable2 instanceof Multiset) {
            return ((Multiset)iterable2).count(element2);
        }
        if (iterable2 instanceof Set) {
            return ((Set)iterable2).contains(element2) ? 1 : 0;
        }
        return Iterators.frequency(iterable2.iterator(), element2);
    }

    public static <T> Iterable<T> cycle(final Iterable<T> iterable2) {
        Preconditions.checkNotNull(iterable2);
        return new FluentIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.cycle(iterable2);
            }

            @Override
            public String toString() {
                return iterable2.toString() + " (cycled)";
            }
        };
    }

    public static <T> Iterable<T> cycle(T ... elements) {
        return Iterables.cycle(Lists.newArrayList(elements));
    }

    public static <T> Iterable<T> concat(Iterable<? extends T> a2, Iterable<? extends T> b2) {
        Preconditions.checkNotNull(a2);
        Preconditions.checkNotNull(b2);
        return Iterables.concat(Arrays.asList(a2, b2));
    }

    public static <T> Iterable<T> concat(Iterable<? extends T> a2, Iterable<? extends T> b2, Iterable<? extends T> c) {
        Preconditions.checkNotNull(a2);
        Preconditions.checkNotNull(b2);
        Preconditions.checkNotNull(c);
        return Iterables.concat(Arrays.asList(a2, b2, c));
    }

    public static <T> Iterable<T> concat(Iterable<? extends T> a2, Iterable<? extends T> b2, Iterable<? extends T> c, Iterable<? extends T> d) {
        Preconditions.checkNotNull(a2);
        Preconditions.checkNotNull(b2);
        Preconditions.checkNotNull(c);
        Preconditions.checkNotNull(d);
        return Iterables.concat(Arrays.asList(a2, b2, c, d));
    }

    public static <T> Iterable<T> concat(Iterable<? extends T> ... inputs) {
        return Iterables.concat(ImmutableList.copyOf(inputs));
    }

    public static <T> Iterable<T> concat(final Iterable<? extends Iterable<? extends T>> inputs) {
        Preconditions.checkNotNull(inputs);
        return new FluentIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.concat(Iterables.iterators(inputs));
            }
        };
    }

    private static <T> UnmodifiableIterator<Iterator<? extends T>> iterators(Iterable<? extends Iterable<? extends T>> iterables) {
        final Iterator<? extends Iterable<? extends T>> iterableIterator = iterables.iterator();
        return new UnmodifiableIterator<Iterator<? extends T>>(){

            @Override
            public boolean hasNext() {
                return iterableIterator.hasNext();
            }

            @Override
            public Iterator<? extends T> next() {
                return ((Iterable)iterableIterator.next()).iterator();
            }
        };
    }

    public static <T> Iterable<List<T>> partition(final Iterable<T> iterable2, final int size2) {
        Preconditions.checkNotNull(iterable2);
        Preconditions.checkArgument(size2 > 0);
        return new FluentIterable<List<T>>(){

            @Override
            public Iterator<List<T>> iterator() {
                return Iterators.partition(iterable2.iterator(), size2);
            }
        };
    }

    public static <T> Iterable<List<T>> paddedPartition(final Iterable<T> iterable2, final int size2) {
        Preconditions.checkNotNull(iterable2);
        Preconditions.checkArgument(size2 > 0);
        return new FluentIterable<List<T>>(){

            @Override
            public Iterator<List<T>> iterator() {
                return Iterators.paddedPartition(iterable2.iterator(), size2);
            }
        };
    }

    public static <T> Iterable<T> filter(final Iterable<T> unfiltered, final Predicate<? super T> predicate) {
        Preconditions.checkNotNull(unfiltered);
        Preconditions.checkNotNull(predicate);
        return new FluentIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.filter(unfiltered.iterator(), predicate);
            }
        };
    }

    @GwtIncompatible(value="Class.isInstance")
    public static <T> Iterable<T> filter(final Iterable<?> unfiltered, final Class<T> type) {
        Preconditions.checkNotNull(unfiltered);
        Preconditions.checkNotNull(type);
        return new FluentIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.filter(unfiltered.iterator(), type);
            }
        };
    }

    public static <T> boolean any(Iterable<T> iterable2, Predicate<? super T> predicate) {
        return Iterators.any(iterable2.iterator(), predicate);
    }

    public static <T> boolean all(Iterable<T> iterable2, Predicate<? super T> predicate) {
        return Iterators.all(iterable2.iterator(), predicate);
    }

    public static <T> T find(Iterable<T> iterable2, Predicate<? super T> predicate) {
        return Iterators.find(iterable2.iterator(), predicate);
    }

    @Nullable
    public static <T> T find(Iterable<? extends T> iterable2, Predicate<? super T> predicate, @Nullable T defaultValue) {
        return Iterators.find(iterable2.iterator(), predicate, defaultValue);
    }

    public static <T> Optional<T> tryFind(Iterable<T> iterable2, Predicate<? super T> predicate) {
        return Iterators.tryFind(iterable2.iterator(), predicate);
    }

    public static <T> int indexOf(Iterable<T> iterable2, Predicate<? super T> predicate) {
        return Iterators.indexOf(iterable2.iterator(), predicate);
    }

    public static <F, T> Iterable<T> transform(final Iterable<F> fromIterable2, final Function<? super F, ? extends T> function2) {
        Preconditions.checkNotNull(fromIterable2);
        Preconditions.checkNotNull(function2);
        return new FluentIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.transform(fromIterable2.iterator(), function2);
            }
        };
    }

    public static <T> T get(Iterable<T> iterable2, int position) {
        Preconditions.checkNotNull(iterable2);
        if (iterable2 instanceof List) {
            return (T)((List)iterable2).get(position);
        }
        if (iterable2 instanceof Collection) {
            Collection collection = (Collection)iterable2;
            Preconditions.checkElementIndex(position, collection.size());
        } else {
            Iterables.checkNonnegativeIndex(position);
        }
        return Iterators.get(iterable2.iterator(), position);
    }

    private static void checkNonnegativeIndex(int position) {
        if (position < 0) {
            throw new IndexOutOfBoundsException("position cannot be negative: " + position);
        }
    }

    @Nullable
    public static <T> T get(Iterable<? extends T> iterable2, int position, @Nullable T defaultValue) {
        Preconditions.checkNotNull(iterable2);
        Iterables.checkNonnegativeIndex(position);
        try {
            return Iterables.get(iterable2, position);
        }
        catch (IndexOutOfBoundsException e) {
            return defaultValue;
        }
    }

    @Nullable
    public static <T> T getFirst(Iterable<? extends T> iterable2, @Nullable T defaultValue) {
        return Iterators.getNext(iterable2.iterator(), defaultValue);
    }

    public static <T> T getLast(Iterable<T> iterable2) {
        if (iterable2 instanceof List) {
            List list2 = (List)iterable2;
            if (list2.isEmpty()) {
                throw new NoSuchElementException();
            }
            return Iterables.getLastInNonemptyList(list2);
        }
        if (iterable2 instanceof SortedSet) {
            SortedSet sortedSet = (SortedSet)iterable2;
            return (T)sortedSet.last();
        }
        return Iterators.getLast(iterable2.iterator());
    }

    @Nullable
    public static <T> T getLast(Iterable<? extends T> iterable2, @Nullable T defaultValue) {
        Collection<T> collection;
        if (iterable2 instanceof Collection && (collection = Collections2.cast(iterable2)).isEmpty()) {
            return defaultValue;
        }
        if (iterable2 instanceof List) {
            List<? extends T> list2 = Lists.cast(iterable2);
            return Iterables.getLastInNonemptyList(list2);
        }
        if (iterable2 instanceof SortedSet) {
            SortedSet<T> sortedSet = Sets.cast(iterable2);
            return sortedSet.last();
        }
        return Iterators.getLast(iterable2.iterator(), defaultValue);
    }

    private static <T> T getLastInNonemptyList(List<T> list2) {
        return list2.get(list2.size() - 1);
    }

    public static <T> Iterable<T> skip(final Iterable<T> iterable2, final int numberToSkip) {
        Preconditions.checkNotNull(iterable2);
        Preconditions.checkArgument(numberToSkip >= 0, "number to skip cannot be negative");
        if (iterable2 instanceof List) {
            final List list2 = (List)iterable2;
            return new FluentIterable<T>(){

                @Override
                public Iterator<T> iterator() {
                    return numberToSkip >= list2.size() ? Iterators.emptyIterator() : list2.subList(numberToSkip, list2.size()).iterator();
                }
            };
        }
        return new FluentIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                final Iterator iterator2 = iterable2.iterator();
                Iterators.advance(iterator2, numberToSkip);
                return new Iterator<T>(){
                    boolean atStart = true;

                    @Override
                    public boolean hasNext() {
                        return iterator2.hasNext();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public T next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        try {
                            Object e = iterator2.next();
                            return e;
                        }
                        finally {
                            this.atStart = false;
                        }
                    }

                    @Override
                    public void remove() {
                        if (this.atStart) {
                            throw new IllegalStateException();
                        }
                        iterator2.remove();
                    }
                };
            }
        };
    }

    public static <T> Iterable<T> limit(final Iterable<T> iterable2, final int limitSize) {
        Preconditions.checkNotNull(iterable2);
        Preconditions.checkArgument(limitSize >= 0, "limit is negative");
        return new FluentIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.limit(iterable2.iterator(), limitSize);
            }
        };
    }

    public static <T> Iterable<T> consumingIterable(final Iterable<T> iterable2) {
        if (iterable2 instanceof Queue) {
            return new FluentIterable<T>(){

                @Override
                public Iterator<T> iterator() {
                    return new ConsumingQueueIterator((Queue)iterable2);
                }
            };
        }
        Preconditions.checkNotNull(iterable2);
        return new FluentIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.consumingIterator(iterable2.iterator());
            }
        };
    }

    public static boolean isEmpty(Iterable<?> iterable2) {
        if (iterable2 instanceof Collection) {
            return ((Collection)iterable2).isEmpty();
        }
        return !iterable2.iterator().hasNext();
    }

    @Beta
    public static <T> Iterable<T> mergeSorted(final Iterable<? extends Iterable<? extends T>> iterables, final Comparator<? super T> comparator) {
        Preconditions.checkNotNull(iterables, "iterables");
        Preconditions.checkNotNull(comparator, "comparator");
        FluentIterable iterable2 = new FluentIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.mergeSorted(Iterables.transform(iterables, Iterables.toIterator()), comparator);
            }
        };
        return new UnmodifiableIterable(iterable2);
    }

    private static <T> Function<Iterable<? extends T>, Iterator<? extends T>> toIterator() {
        return new Function<Iterable<? extends T>, Iterator<? extends T>>(){

            @Override
            public Iterator<? extends T> apply(Iterable<? extends T> iterable2) {
                return iterable2.iterator();
            }
        };
    }

    private static class ConsumingQueueIterator<T>
    extends AbstractIterator<T> {
        private final Queue<T> queue;

        private ConsumingQueueIterator(Queue<T> queue) {
            this.queue = queue;
        }

        @Override
        public T computeNext() {
            try {
                return this.queue.remove();
            }
            catch (NoSuchElementException e) {
                return this.endOfData();
            }
        }
    }

    private static final class UnmodifiableIterable<T>
    extends FluentIterable<T> {
        private final Iterable<T> iterable;

        private UnmodifiableIterable(Iterable<T> iterable2) {
            this.iterable = iterable2;
        }

        @Override
        public Iterator<T> iterator() {
            return Iterators.unmodifiableIterator(this.iterable.iterator());
        }

        @Override
        public String toString() {
            return this.iterable.toString();
        }
    }
}

