/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.AbstractMultiset;
import com.google.common.collect.Collections2;
import com.google.common.collect.ForwardingIterator;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.GenericMapMaker;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.Serialization;
import com.google.common.math.IntMath;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

public final class ConcurrentHashMultiset<E>
extends AbstractMultiset<E>
implements Serializable {
    private final transient ConcurrentMap<E, AtomicInteger> countMap;
    private transient EntrySet entrySet;
    private static final long serialVersionUID = 1L;

    public static <E> ConcurrentHashMultiset<E> create() {
        return new ConcurrentHashMultiset(new ConcurrentHashMap());
    }

    public static <E> ConcurrentHashMultiset<E> create(Iterable<? extends E> elements) {
        ConcurrentHashMultiset<E> multiset = ConcurrentHashMultiset.create();
        Iterables.addAll(multiset, elements);
        return multiset;
    }

    @Beta
    public static <E> ConcurrentHashMultiset<E> create(GenericMapMaker<? super E, ? super Number> mapMaker) {
        return new ConcurrentHashMultiset(mapMaker.makeMap());
    }

    @VisibleForTesting
    ConcurrentHashMultiset(ConcurrentMap<E, AtomicInteger> countMap) {
        Preconditions.checkArgument(countMap.isEmpty());
        this.countMap = countMap;
    }

    @Override
    public int count(@Nullable Object element2) {
        AtomicInteger existingCounter = Maps.safeGet(this.countMap, element2);
        return existingCounter == null ? 0 : existingCounter.get();
    }

    @Override
    public int size() {
        long sum2 = 0L;
        for (AtomicInteger value2 : this.countMap.values()) {
            sum2 += (long)value2.get();
        }
        return Ints.saturatedCast(sum2);
    }

    @Override
    public Object[] toArray() {
        return this.snapshot().toArray();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return this.snapshot().toArray(array);
    }

    private List<E> snapshot() {
        ArrayList<E> list2 = Lists.newArrayListWithExpectedSize(this.size());
        for (Multiset.Entry<E> entry : this.entrySet()) {
            E element2 = entry.getElement();
            for (int i = entry.getCount(); i > 0; --i) {
                list2.add(element2);
            }
        }
        return list2;
    }

    @Override
    public int add(E element2, int occurrences) {
        AtomicInteger existingCounter;
        AtomicInteger newCounter;
        Preconditions.checkNotNull(element2);
        if (occurrences == 0) {
            return this.count(element2);
        }
        Preconditions.checkArgument(occurrences > 0, "Invalid occurrences: %s", occurrences);
        do {
            int oldValue;
            if ((existingCounter = Maps.safeGet(this.countMap, element2)) == null && (existingCounter = this.countMap.putIfAbsent(element2, new AtomicInteger(occurrences))) == null) {
                return 0;
            }
            while ((oldValue = existingCounter.get()) != 0) {
                try {
                    int newValue = IntMath.checkedAdd(oldValue, occurrences);
                    if (!existingCounter.compareAndSet(oldValue, newValue)) continue;
                    return oldValue;
                }
                catch (ArithmeticException overflow) {
                    throw new IllegalArgumentException("Overflow adding " + occurrences + " occurrences to a count of " + oldValue);
                }
            }
        } while (this.countMap.putIfAbsent(element2, newCounter = new AtomicInteger(occurrences)) != null && !this.countMap.replace(element2, existingCounter, newCounter));
        return 0;
    }

    @Override
    public int remove(@Nullable Object element2, int occurrences) {
        int oldValue;
        if (occurrences == 0) {
            return this.count(element2);
        }
        Preconditions.checkArgument(occurrences > 0, "Invalid occurrences: %s", occurrences);
        AtomicInteger existingCounter = Maps.safeGet(this.countMap, element2);
        if (existingCounter == null) {
            return 0;
        }
        while ((oldValue = existingCounter.get()) != 0) {
            int newValue = Math.max(0, oldValue - occurrences);
            if (!existingCounter.compareAndSet(oldValue, newValue)) continue;
            if (newValue == 0) {
                this.countMap.remove(element2, existingCounter);
            }
            return oldValue;
        }
        return 0;
    }

    public boolean removeExactly(@Nullable Object element2, int occurrences) {
        int newValue;
        int oldValue;
        if (occurrences == 0) {
            return true;
        }
        Preconditions.checkArgument(occurrences > 0, "Invalid occurrences: %s", occurrences);
        AtomicInteger existingCounter = Maps.safeGet(this.countMap, element2);
        if (existingCounter == null) {
            return false;
        }
        do {
            if ((oldValue = existingCounter.get()) >= occurrences) continue;
            return false;
        } while (!existingCounter.compareAndSet(oldValue, newValue = oldValue - occurrences));
        if (newValue == 0) {
            this.countMap.remove(element2, existingCounter);
        }
        return true;
    }

    @Override
    public int setCount(E element2, int count2) {
        int oldValue;
        AtomicInteger existingCounter;
        Preconditions.checkNotNull(element2);
        Multisets.checkNonnegative(count2, "count");
        block0: while (true) {
            if ((existingCounter = Maps.safeGet(this.countMap, element2)) == null) {
                if (count2 == 0) {
                    return 0;
                }
                existingCounter = this.countMap.putIfAbsent(element2, new AtomicInteger(count2));
                if (existingCounter == null) {
                    return 0;
                }
            }
            do {
                if ((oldValue = existingCounter.get()) != 0) continue;
                if (count2 == 0) {
                    return 0;
                }
                AtomicInteger newCounter = new AtomicInteger(count2);
                if (this.countMap.putIfAbsent(element2, newCounter) != null && !this.countMap.replace(element2, existingCounter, newCounter)) continue block0;
                return 0;
            } while (!existingCounter.compareAndSet(oldValue, count2));
            break;
        }
        if (count2 == 0) {
            this.countMap.remove(element2, existingCounter);
        }
        return oldValue;
    }

    @Override
    public boolean setCount(E element2, int expectedOldCount, int newCount) {
        Preconditions.checkNotNull(element2);
        Multisets.checkNonnegative(expectedOldCount, "oldCount");
        Multisets.checkNonnegative(newCount, "newCount");
        AtomicInteger existingCounter = Maps.safeGet(this.countMap, element2);
        if (existingCounter == null) {
            if (expectedOldCount != 0) {
                return false;
            }
            if (newCount == 0) {
                return true;
            }
            return this.countMap.putIfAbsent(element2, new AtomicInteger(newCount)) == null;
        }
        int oldValue = existingCounter.get();
        if (oldValue == expectedOldCount) {
            if (oldValue == 0) {
                if (newCount == 0) {
                    this.countMap.remove(element2, existingCounter);
                    return true;
                }
                AtomicInteger newCounter = new AtomicInteger(newCount);
                return this.countMap.putIfAbsent(element2, newCounter) == null || this.countMap.replace(element2, existingCounter, newCounter);
            }
            if (existingCounter.compareAndSet(oldValue, newCount)) {
                if (newCount == 0) {
                    this.countMap.remove(element2, existingCounter);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    Set<E> createElementSet() {
        final Set delegate = this.countMap.keySet();
        return new ForwardingSet<E>(){

            @Override
            protected Set<E> delegate() {
                return delegate;
            }

            @Override
            public boolean contains(@Nullable Object object) {
                return object != null && Collections2.safeContains(delegate, object);
            }

            @Override
            public boolean containsAll(Collection<?> collection) {
                return this.standardContainsAll(collection);
            }

            @Override
            public boolean remove(Object object) {
                return object != null && Collections2.safeRemove(delegate, object);
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                return this.standardRemoveAll(c);
            }
        };
    }

    @Override
    public Set<Multiset.Entry<E>> entrySet() {
        EntrySet result2 = this.entrySet;
        if (result2 == null) {
            this.entrySet = result2 = new EntrySet();
        }
        return result2;
    }

    @Override
    int distinctElements() {
        return this.countMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.countMap.isEmpty();
    }

    @Override
    Iterator<Multiset.Entry<E>> entryIterator() {
        final AbstractIterator readOnlyIterator = new AbstractIterator<Multiset.Entry<E>>(){
            private Iterator<Map.Entry<E, AtomicInteger>> mapEntries;
            {
                this.mapEntries = ConcurrentHashMultiset.this.countMap.entrySet().iterator();
            }

            @Override
            protected Multiset.Entry<E> computeNext() {
                Map.Entry mapEntry;
                int count2;
                do {
                    if (this.mapEntries.hasNext()) continue;
                    return (Multiset.Entry)this.endOfData();
                } while ((count2 = (mapEntry = this.mapEntries.next()).getValue().get()) == 0);
                return Multisets.immutableEntry(mapEntry.getKey(), count2);
            }
        };
        return new ForwardingIterator<Multiset.Entry<E>>(){
            private Multiset.Entry<E> last;

            @Override
            protected Iterator<Multiset.Entry<E>> delegate() {
                return readOnlyIterator;
            }

            @Override
            public Multiset.Entry<E> next() {
                this.last = (Multiset.Entry)super.next();
                return this.last;
            }

            @Override
            public void remove() {
                Preconditions.checkState(this.last != null);
                ConcurrentHashMultiset.this.setCount(this.last.getElement(), 0);
                this.last = null;
            }
        };
    }

    @Override
    public void clear() {
        this.countMap.clear();
    }

    private void writeObject(ObjectOutputStream stream2) throws IOException {
        stream2.defaultWriteObject();
        stream2.writeObject(this.countMap);
    }

    private void readObject(ObjectInputStream stream2) throws IOException, ClassNotFoundException {
        stream2.defaultReadObject();
        ConcurrentMap deserializedCountMap = (ConcurrentMap)stream2.readObject();
        FieldSettersHolder.COUNT_MAP_FIELD_SETTER.set(this, deserializedCountMap);
    }

    private class EntrySet
    extends AbstractMultiset.EntrySet {
        private EntrySet() {
        }

        @Override
        ConcurrentHashMultiset<E> multiset() {
            return ConcurrentHashMultiset.this;
        }

        @Override
        public Object[] toArray() {
            return this.snapshot().toArray();
        }

        @Override
        public <T> T[] toArray(T[] array) {
            return this.snapshot().toArray(array);
        }

        private List<Multiset.Entry<E>> snapshot() {
            ArrayList list2 = Lists.newArrayListWithExpectedSize(this.size());
            Iterators.addAll(list2, this.iterator());
            return list2;
        }
    }

    private static class FieldSettersHolder {
        static final Serialization.FieldSetter<ConcurrentHashMultiset> COUNT_MAP_FIELD_SETTER = Serialization.getFieldSetter(ConcurrentHashMultiset.class, "countMap");

        private FieldSettersHolder() {
        }
    }
}

