/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.util.Comparator;
import javax.annotation.Nullable;

@GwtCompatible
public abstract class ComparisonChain {
    private static final ComparisonChain ACTIVE = new ComparisonChain(){

        public ComparisonChain compare(Comparable left2, Comparable right2) {
            return this.classify(left2.compareTo(right2));
        }

        @Override
        public <T> ComparisonChain compare(@Nullable T left2, @Nullable T right2, Comparator<T> comparator) {
            return this.classify(comparator.compare(left2, right2));
        }

        @Override
        public ComparisonChain compare(int left2, int right2) {
            return this.classify(Ints.compare(left2, right2));
        }

        @Override
        public ComparisonChain compare(long left2, long right2) {
            return this.classify(Longs.compare(left2, right2));
        }

        @Override
        public ComparisonChain compare(float left2, float right2) {
            return this.classify(Float.compare(left2, right2));
        }

        @Override
        public ComparisonChain compare(double left2, double right2) {
            return this.classify(Double.compare(left2, right2));
        }

        @Override
        public ComparisonChain compareTrueFirst(boolean left2, boolean right2) {
            return this.classify(Booleans.compare(right2, left2));
        }

        @Override
        public ComparisonChain compareFalseFirst(boolean left2, boolean right2) {
            return this.classify(Booleans.compare(left2, right2));
        }

        ComparisonChain classify(int result2) {
            return result2 < 0 ? LESS : (result2 > 0 ? GREATER : ACTIVE);
        }

        @Override
        public int result() {
            return 0;
        }
    };
    private static final ComparisonChain LESS = new InactiveComparisonChain(-1);
    private static final ComparisonChain GREATER = new InactiveComparisonChain(1);

    private ComparisonChain() {
    }

    public static ComparisonChain start() {
        return ACTIVE;
    }

    public abstract ComparisonChain compare(Comparable<?> var1, Comparable<?> var2);

    public abstract <T> ComparisonChain compare(@Nullable T var1, @Nullable T var2, Comparator<T> var3);

    public abstract ComparisonChain compare(int var1, int var2);

    public abstract ComparisonChain compare(long var1, long var3);

    public abstract ComparisonChain compare(float var1, float var2);

    public abstract ComparisonChain compare(double var1, double var3);

    public abstract ComparisonChain compareTrueFirst(boolean var1, boolean var2);

    public abstract ComparisonChain compareFalseFirst(boolean var1, boolean var2);

    @Deprecated
    public final ComparisonChain compare(boolean left2, boolean right2) {
        return this.compareFalseFirst(left2, right2);
    }

    public abstract int result();

    private static final class InactiveComparisonChain
    extends ComparisonChain {
        final int result;

        InactiveComparisonChain(int result2) {
            this.result = result2;
        }

        public ComparisonChain compare(@Nullable Comparable left2, @Nullable Comparable right2) {
            return this;
        }

        @Override
        public <T> ComparisonChain compare(@Nullable T left2, @Nullable T right2, @Nullable Comparator<T> comparator) {
            return this;
        }

        @Override
        public ComparisonChain compare(int left2, int right2) {
            return this;
        }

        @Override
        public ComparisonChain compare(long left2, long right2) {
            return this;
        }

        @Override
        public ComparisonChain compare(float left2, float right2) {
            return this;
        }

        @Override
        public ComparisonChain compare(double left2, double right2) {
            return this;
        }

        @Override
        public ComparisonChain compareTrueFirst(boolean left2, boolean right2) {
            return this;
        }

        @Override
        public ComparisonChain compareFalseFirst(boolean left2, boolean right2) {
            return this;
        }

        @Override
        public int result() {
            return this.result;
        }
    }
}

