/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import zmq.Command;
import zmq.Ctx;
import zmq.IEngine;
import zmq.IOThread;
import zmq.Own;
import zmq.Pipe;
import zmq.SessionBase;
import zmq.SocketBase;

public abstract class ZObject {
    private final Ctx ctx;
    private final int tid;

    protected ZObject(Ctx ctx, int tid) {
        this.ctx = ctx;
        this.tid = tid;
    }

    protected ZObject(ZObject parent2) {
        this(parent2.ctx, parent2.tid);
    }

    protected int getTid() {
        return this.tid;
    }

    protected Ctx getCtx() {
        return this.ctx;
    }

    protected void processCommand(Command cmd) {
        switch (cmd.type()) {
            case ACTIVATE_READ: {
                this.processActivateRead();
                break;
            }
            case ACTIVATE_WRITE: {
                this.processActivateWrite((Long)cmd.arg);
                break;
            }
            case STOP: {
                this.processStop();
                break;
            }
            case PLUG: {
                this.processPlug();
                this.processSeqnum();
                break;
            }
            case OWN: {
                this.processOwn((Own)cmd.arg);
                this.processSeqnum();
                break;
            }
            case ATTACH: {
                this.processAttach((IEngine)cmd.arg);
                this.processSeqnum();
                break;
            }
            case BIND: {
                this.processBind((Pipe)cmd.arg);
                this.processSeqnum();
                break;
            }
            case HICCUP: {
                this.processHiccup(cmd.arg);
                break;
            }
            case PIPE_TERM: {
                this.processPipeTerm();
                break;
            }
            case PIPE_TERM_ACK: {
                this.processPipeTermAck();
                break;
            }
            case TERM_REQ: {
                this.processTermReq((Own)cmd.arg);
                break;
            }
            case TERM: {
                this.processTerm((Integer)cmd.arg);
                break;
            }
            case TERM_ACK: {
                this.processTermAck();
                break;
            }
            case REAP: {
                this.processReap((SocketBase)cmd.arg);
                break;
            }
            case REAPED: {
                this.processReaped();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    protected boolean registerEndpoint(String addr, Ctx.Endpoint endpoint) {
        return this.ctx.registerEndpoint(addr, endpoint);
    }

    protected void unregisterEndpoints(SocketBase socket) {
        this.ctx.unregisterEndpoints(socket);
    }

    protected Ctx.Endpoint findEndpoint(String addr) {
        return this.ctx.findEndpoint(addr);
    }

    protected void destroySocket(SocketBase socket) {
        this.ctx.destroySocket(socket);
    }

    protected IOThread chooseIoThread(long affinity) {
        return this.ctx.chooseIoThread(affinity);
    }

    protected void sendStop() {
        Command cmd = new Command(this, Command.Type.STOP);
        this.ctx.sendCommand(this.tid, cmd);
    }

    protected void sendPlug(Own destination) {
        this.sendPlug(destination, true);
    }

    protected void sendPlug(Own destination, boolean incSeqnum) {
        if (incSeqnum) {
            destination.incSeqnum();
        }
        Command cmd = new Command(destination, Command.Type.PLUG);
        this.sendCommand(cmd);
    }

    protected void sendOwn(Own destination, Own object) {
        destination.incSeqnum();
        Command cmd = new Command(destination, Command.Type.OWN, object);
        this.sendCommand(cmd);
    }

    protected void sendAttach(SessionBase destination, IEngine engine) {
        this.sendAttach(destination, engine, true);
    }

    protected void sendAttach(SessionBase destination, IEngine engine, boolean incSeqnum) {
        if (incSeqnum) {
            destination.incSeqnum();
        }
        Command cmd = new Command(destination, Command.Type.ATTACH, engine);
        this.sendCommand(cmd);
    }

    protected void sendBind(Own destination, Pipe pipe) {
        this.sendBind(destination, pipe, true);
    }

    protected void sendBind(Own destination, Pipe pipe, boolean incSeqnum) {
        if (incSeqnum) {
            destination.incSeqnum();
        }
        Command cmd = new Command(destination, Command.Type.BIND, pipe);
        this.sendCommand(cmd);
    }

    protected void sendActivateRead(Pipe destination) {
        Command cmd = new Command(destination, Command.Type.ACTIVATE_READ);
        this.sendCommand(cmd);
    }

    protected void sendActivateWrite(Pipe destination, long msgsRead) {
        Command cmd = new Command(destination, Command.Type.ACTIVATE_WRITE, msgsRead);
        this.sendCommand(cmd);
    }

    protected void sendHiccup(Pipe destination, Object pipe) {
        Command cmd = new Command(destination, Command.Type.HICCUP, pipe);
        this.sendCommand(cmd);
    }

    protected void sendPipeTerm(Pipe destination) {
        Command cmd = new Command(destination, Command.Type.PIPE_TERM);
        this.sendCommand(cmd);
    }

    protected void sendPipeTermAck(Pipe destination) {
        Command cmd = new Command(destination, Command.Type.PIPE_TERM_ACK);
        this.sendCommand(cmd);
    }

    protected void sendTermReq(Own destination, Own object) {
        Command cmd = new Command(destination, Command.Type.TERM_REQ, object);
        this.sendCommand(cmd);
    }

    protected void sendTerm(Own destination, int linger) {
        Command cmd = new Command(destination, Command.Type.TERM, linger);
        this.sendCommand(cmd);
    }

    protected void sendTermAck(Own destination) {
        Command cmd = new Command(destination, Command.Type.TERM_ACK);
        this.sendCommand(cmd);
    }

    protected void sendReap(SocketBase socket) {
        Command cmd = new Command(this.ctx.getReaper(), Command.Type.REAP, socket);
        this.sendCommand(cmd);
    }

    protected void sendReaped() {
        Command cmd = new Command(this.ctx.getReaper(), Command.Type.REAPED);
        this.sendCommand(cmd);
    }

    protected void sendDone() {
        Command cmd = new Command(null, Command.Type.DONE);
        this.ctx.sendCommand(0, cmd);
    }

    protected void processStop() {
        throw new UnsupportedOperationException();
    }

    protected void processPlug() {
        throw new UnsupportedOperationException();
    }

    protected void processOwn(Own object) {
        throw new UnsupportedOperationException();
    }

    protected void processAttach(IEngine engine) {
        throw new UnsupportedOperationException();
    }

    protected void processBind(Pipe pipe) {
        throw new UnsupportedOperationException();
    }

    protected void processActivateRead() {
        throw new UnsupportedOperationException();
    }

    protected void processActivateWrite(long msgsRead) {
        throw new UnsupportedOperationException();
    }

    protected void processHiccup(Object hiccupPipe) {
        throw new UnsupportedOperationException();
    }

    protected void processPipeTerm() {
        throw new UnsupportedOperationException();
    }

    protected void processPipeTermAck() {
        throw new UnsupportedOperationException();
    }

    protected void processTermReq(Own object) {
        throw new UnsupportedOperationException();
    }

    protected void processTerm(int linger) {
        throw new UnsupportedOperationException();
    }

    protected void processTermAck() {
        throw new UnsupportedOperationException();
    }

    protected void processReap(SocketBase socket) {
        throw new UnsupportedOperationException();
    }

    protected void processReaped() {
        throw new UnsupportedOperationException();
    }

    protected void processSeqnum() {
        throw new UnsupportedOperationException();
    }

    private void sendCommand(Command cmd) {
        this.ctx.sendCommand(cmd.destination().getTid(), cmd);
    }
}

