/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import zmq.Address;
import zmq.Ctx;
import zmq.Dist;
import zmq.FQ;
import zmq.IOThread;
import zmq.Msg;
import zmq.Options;
import zmq.Pipe;
import zmq.SessionBase;
import zmq.SocketBase;
import zmq.Trie;

public class XSub
extends SocketBase {
    private final FQ fq;
    private final Dist dist;
    private final Trie subscriptions;
    private boolean hashMessage;
    private Msg message;
    private boolean more;
    private static Trie.ITrieHandler sendSubscription = new Trie.ITrieHandler(){

        @Override
        public void added(byte[] data, int size2, Object arg) {
            Pipe pipe = (Pipe)arg;
            Msg msg = new Msg(size2 + 1);
            msg.put((byte)1).put(data, 0, size2);
            boolean sent = pipe.write(msg);
        }
    };

    public XSub(Ctx parent2, int tid, int sid) {
        super(parent2, tid, sid);
        this.options.type = 10;
        this.hashMessage = false;
        this.more = false;
        this.options.linger = 0;
        this.fq = new FQ();
        this.dist = new Dist();
        this.subscriptions = new Trie();
    }

    @Override
    protected void xattachPipe(Pipe pipe, boolean icanhasall) {
        assert (pipe != null);
        this.fq.attach(pipe);
        this.dist.attach(pipe);
        this.subscriptions.apply(sendSubscription, pipe);
        pipe.flush();
    }

    @Override
    protected void xreadActivated(Pipe pipe) {
        this.fq.activated(pipe);
    }

    @Override
    protected void xwriteActivated(Pipe pipe) {
        this.dist.activated(pipe);
    }

    @Override
    protected void xpipeTerminated(Pipe pipe) {
        this.fq.terminated(pipe);
        this.dist.terminated(pipe);
    }

    @Override
    protected void xhiccuped(Pipe pipe) {
        this.subscriptions.apply(sendSubscription, pipe);
        pipe.flush();
    }

    @Override
    protected boolean xsend(Msg msg) {
        byte[] data = msg.data();
        if (data.length < 1 || data[0] != 0 && data[0] != 1) {
            throw new IllegalArgumentException("subscription flag");
        }
        if (data[0] == 1) {
            this.subscriptions.add(data, 1);
            return this.dist.sendToAll(msg);
        }
        if (this.subscriptions.rm(data, 1)) {
            return this.dist.sendToAll(msg);
        }
        return true;
    }

    @Override
    protected boolean xhasOut() {
        return true;
    }

    @Override
    protected Msg xrecv() {
        Msg msg = null;
        if (this.hashMessage) {
            msg = this.message;
            this.hashMessage = false;
            this.more = msg.hasMore();
            return msg;
        }
        block0: while (true) {
            if ((msg = this.fq.recv(this.errno)) == null) {
                return null;
            }
            if (this.more || !this.options.filter || this.match(msg)) {
                this.more = msg.hasMore();
                return msg;
            }
            do {
                if (!msg.hasMore()) continue block0;
                msg = this.fq.recv(this.errno);
            } while ($assertionsDisabled || msg != null);
            break;
        }
        throw new AssertionError();
    }

    @Override
    protected boolean xhasIn() {
        if (this.more) {
            return true;
        }
        if (this.hashMessage) {
            return true;
        }
        block0: while (true) {
            this.message = this.fq.recv(this.errno);
            if (this.message == null) {
                return false;
            }
            if (!this.options.filter || this.match(this.message)) {
                this.hashMessage = true;
                return true;
            }
            do {
                if (!this.message.hasMore()) continue block0;
                this.message = this.fq.recv(this.errno);
            } while ($assertionsDisabled || this.message != null);
            break;
        }
        throw new AssertionError();
    }

    private boolean match(Msg msg) {
        return this.subscriptions.check(msg.buf());
    }

    public static class XSubSession
    extends SessionBase {
        public XSubSession(IOThread ioThread, boolean connect, SocketBase socket, Options options2, Address addr) {
            super(ioThread, connect, socket, options2, addr);
        }
    }
}

