/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.nio.ByteBuffer;
import zmq.DecoderBase;
import zmq.IMsgSink;
import zmq.Msg;

public class V1Decoder
extends DecoderBase {
    private static final int ONE_BYTE_SIZE_READY = 0;
    private static final int EIGHT_BYTE_SIZE_READY = 1;
    private static final int FLAGS_READY = 2;
    private static final int MESSAGE_READY = 3;
    private final byte[] tmpbuf;
    private final ByteBuffer tmpbufWrap;
    private Msg inProgress;
    private IMsgSink msgSink;
    private final long maxmsgsize;
    private int msgFlags;

    public V1Decoder(int bufsize, long maxmsgsize, IMsgSink session) {
        super(bufsize);
        this.maxmsgsize = maxmsgsize;
        this.msgSink = session;
        this.tmpbuf = new byte[8];
        this.tmpbufWrap = ByteBuffer.wrap(this.tmpbuf);
        this.tmpbufWrap.limit(1);
        this.nextStep(this.tmpbufWrap, 2);
    }

    @Override
    public void setMsgSink(IMsgSink msgSink) {
        this.msgSink = msgSink;
    }

    @Override
    protected boolean next() {
        switch (this.state()) {
            case 0: {
                return this.oneByteSizeReady();
            }
            case 1: {
                return this.eightByteSizeReady();
            }
            case 2: {
                return this.flagsReady();
            }
            case 3: {
                return this.messageReady();
            }
        }
        return false;
    }

    private boolean oneByteSizeReady() {
        int size2 = this.tmpbuf[0];
        if (size2 < 0) {
            size2 = 0xFF & size2;
        }
        if (this.maxmsgsize >= 0L && (long)size2 > this.maxmsgsize) {
            this.decodingError();
            return false;
        }
        this.inProgress = this.getMsgAllocator().allocate(size2);
        this.inProgress.setFlags(this.msgFlags);
        this.nextStep(this.inProgress, 3);
        return true;
    }

    private boolean eightByteSizeReady() {
        this.tmpbufWrap.position(0);
        this.tmpbufWrap.limit(8);
        long msgSize = this.tmpbufWrap.getLong(0);
        if (this.maxmsgsize >= 0L && msgSize > this.maxmsgsize) {
            this.decodingError();
            return false;
        }
        if (msgSize > Integer.MAX_VALUE) {
            this.decodingError();
            return false;
        }
        this.inProgress = this.getMsgAllocator().allocate((int)msgSize);
        this.inProgress.setFlags(this.msgFlags);
        this.nextStep(this.inProgress, 3);
        return true;
    }

    private boolean flagsReady() {
        this.msgFlags = 0;
        byte first2 = this.tmpbuf[0];
        if ((first2 & 1) > 0) {
            this.msgFlags |= 1;
        }
        this.tmpbufWrap.position(0);
        if ((first2 & 2) > 0) {
            this.tmpbufWrap.limit(8);
            this.nextStep(this.tmpbufWrap, 1);
        } else {
            this.tmpbufWrap.limit(1);
            this.nextStep(this.tmpbufWrap, 0);
        }
        return true;
    }

    private boolean messageReady() {
        if (this.msgSink == null) {
            return false;
        }
        int rc = this.msgSink.pushMsg(this.inProgress);
        if (rc != 0) {
            if (rc != 35) {
                this.decodingError();
            }
            return false;
        }
        this.tmpbufWrap.position(0);
        this.tmpbufWrap.limit(1);
        this.nextStep(this.tmpbufWrap, 2);
        return true;
    }
}

