/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.security.SecureRandom;

class Utils {
    private static SecureRandom random = new SecureRandom();

    private Utils() {
    }

    public static int generateRandom() {
        return random.nextInt();
    }

    public static void tuneTcpSocket(SocketChannel ch) throws SocketException {
        Utils.tuneTcpSocket(ch.socket());
    }

    public static void tuneTcpSocket(Socket fd) throws SocketException {
        try {
            fd.setTcpNoDelay(true);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    public static void tuneTcpKeepalives(SocketChannel ch, int tcpKeepalive, int tcpKeepaliveCnt, int tcpKeepaliveIdle, int tcpKeepaliveIntvl) throws SocketException {
        Utils.tuneTcpKeepalives(ch.socket(), tcpKeepalive, tcpKeepaliveCnt, tcpKeepaliveIdle, tcpKeepaliveIntvl);
    }

    public static void tuneTcpKeepalives(Socket fd, int tcpKeepalive, int tcpKeepaliveCnt, int tcpKeepaliveIdle, int tcpKeepaliveIntvl) throws SocketException {
        if (tcpKeepalive == 1) {
            fd.setKeepAlive(true);
        } else if (tcpKeepalive == 0) {
            fd.setKeepAlive(false);
        }
    }

    public static void unblockSocket(SelectableChannel s) throws IOException {
        s.configureBlocking(false);
    }

    public static <T> T[] realloc(Class<T> klass, T[] src, int size2, boolean ended) {
        Object[] dest;
        if (size2 > src.length) {
            dest = (Object[])Array.newInstance(klass, size2);
            if (ended) {
                System.arraycopy(src, 0, dest, 0, src.length);
            } else {
                System.arraycopy(src, 0, dest, size2 - src.length, src.length);
            }
        } else if (size2 < src.length) {
            dest = (Object[])Array.newInstance(klass, size2);
            if (ended) {
                System.arraycopy(src, src.length - size2, dest, 0, size2);
            } else {
                System.arraycopy(src, 0, dest, 0, size2);
            }
        } else {
            dest = src;
        }
        return dest;
    }

    public static byte[] bytes(ByteBuffer buf) {
        byte[] d = new byte[buf.limit()];
        buf.get(d);
        return d;
    }

    public static byte[] realloc(byte[] src, int size2) {
        byte[] dest = new byte[size2];
        if (src != null) {
            System.arraycopy(src, 0, dest, 0, src.length);
        }
        return dest;
    }

    public static boolean delete(File path2) {
        File[] files;
        if (!path2.exists()) {
            return false;
        }
        boolean ret = true;
        if (path2.isDirectory() && (files = path2.listFiles()) != null) {
            for (File f2 : files) {
                ret = ret && Utils.delete(f2);
            }
        }
        return ret && path2.delete();
    }
}

