/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.io.IOException;
import java.net.Socket;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import zmq.Address;
import zmq.IOObject;
import zmq.IOThread;
import zmq.IPollEvents;
import zmq.Options;
import zmq.Own;
import zmq.SessionBase;
import zmq.SocketBase;
import zmq.StreamEngine;
import zmq.TcpAddress;
import zmq.Utils;
import zmq.ZError;

public class TcpListener
extends Own
implements IPollEvents {
    private static boolean isWindows;
    private final TcpAddress address;
    private ServerSocketChannel handle;
    private SocketBase socket;
    private String endpoint;
    private final IOObject ioObject;

    public TcpListener(IOThread ioThread, SocketBase socket, Options options2) {
        super(ioThread, options2);
        this.ioObject = new IOObject(ioThread);
        this.address = new TcpAddress();
        this.handle = null;
        this.socket = socket;
    }

    @Override
    public void destroy() {
        assert (this.handle == null);
    }

    @Override
    protected void processPlug() {
        this.ioObject.setHandler(this);
        this.ioObject.addHandle(this.handle);
        this.ioObject.setPollAccept(this.handle);
    }

    @Override
    protected void processTerm(int linger) {
        this.ioObject.setHandler(this);
        this.ioObject.removeHandle(this.handle);
        this.close();
        super.processTerm(linger);
    }

    @Override
    public void acceptEvent() {
        SocketChannel fd = null;
        try {
            fd = this.accept();
            Utils.tuneTcpSocket(fd);
            Utils.tuneTcpKeepalives(fd, this.options.tcpKeepAlive, this.options.tcpKeepAliveCnt, this.options.tcpKeepAliveIdle, this.options.tcpKeepAliveIntvl);
        }
        catch (IOException e2) {
            this.socket.eventAcceptFailed(this.endpoint, ZError.exccode(e2));
            return;
        }
        StreamEngine engine = null;
        try {
            engine = new StreamEngine(fd, this.options, this.endpoint);
        }
        catch (ZError.InstantiationException e3) {
            this.socket.eventAcceptFailed(this.endpoint, 22);
            return;
        }
        IOThread ioThread = this.chooseIoThread(this.options.affinity);
        SessionBase session = SessionBase.create(ioThread, false, this.socket, this.options, new Address(fd.socket().getRemoteSocketAddress()));
        session.incSeqnum();
        this.launchChild(session);
        this.sendAttach(session, engine, false);
        this.socket.eventAccepted(this.endpoint, fd);
    }

    private void close() {
        if (this.handle == null) {
            return;
        }
        try {
            this.handle.close();
            this.socket.eventClosed(this.endpoint, this.handle);
        }
        catch (IOException e2) {
            this.socket.eventCloseFailed(this.endpoint, ZError.exccode(e2));
        }
        this.handle = null;
    }

    public String getAddress() {
        return this.address.toString();
    }

    public int setAddress(String addr) {
        this.address.resolve(addr, this.options.ipv4only > 0);
        try {
            this.handle = ServerSocketChannel.open();
            this.handle.configureBlocking(false);
            if (!isWindows) {
                this.handle.socket().setReuseAddress(true);
            }
            this.handle.socket().bind(this.address.address(), this.options.backlog);
        }
        catch (IOException e2) {
            this.close();
            return 48;
        }
        this.endpoint = this.address.toString();
        this.socket.eventListening(this.endpoint, this.handle);
        return 0;
    }

    private SocketChannel accept() {
        Socket sock = null;
        try {
            sock = this.handle.socket().accept();
        }
        catch (IOException e2) {
            return null;
        }
        if (!this.options.tcpAcceptFilters.isEmpty()) {
            boolean matched = false;
            for (TcpAddress.TcpAddressMask am : this.options.tcpAcceptFilters) {
                if (!am.matchAddress(this.address.address())) continue;
                matched = true;
                break;
            }
            if (!matched) {
                try {
                    sock.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
        }
        return sock.getChannel();
    }

    @Override
    public void inEvent() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void outEvent() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void connectEvent() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void timerEvent(int id2) {
        throw new UnsupportedOperationException();
    }

    static {
        String os = System.getProperty("os.name").toLowerCase();
        isWindows = os.indexOf("win") >= 0;
    }
}

