/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import zmq.Address;
import zmq.Ctx;
import zmq.IOThread;
import zmq.Msg;
import zmq.Options;
import zmq.SocketBase;
import zmq.XSub;
import zmq.ZMQ;

public class Sub
extends XSub {
    public Sub(Ctx parent2, int tid, int sid) {
        super(parent2, tid, sid);
        this.options.type = 2;
        this.options.filter = true;
    }

    @Override
    public boolean xsetsockopt(int option2, Object optval) {
        byte[] val;
        if (option2 != 6 && option2 != 7) {
            return false;
        }
        if (optval instanceof String) {
            val = ((String)optval).getBytes(ZMQ.CHARSET);
        } else if (optval instanceof byte[]) {
            val = (byte[])optval;
        } else {
            throw new IllegalArgumentException();
        }
        Msg msg = new Msg(val.length + 1);
        if (option2 == 6) {
            msg.put((byte)1);
        } else {
            msg.put((byte)0);
        }
        msg.put(val);
        boolean rc = super.xsend(msg);
        if (!rc) {
            throw new IllegalStateException("Failed to send subscribe/unsubscribe message");
        }
        return true;
    }

    @Override
    protected boolean xsend(Msg msg) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean xhasOut() {
        return false;
    }

    public static class SubSession
    extends XSub.XSubSession {
        public SubSession(IOThread ioThread, boolean connect, SocketBase socket, Options options2, Address addr) {
            super(ioThread, connect, socket, options2, addr);
        }
    }
}

