/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;
import zmq.Config;
import zmq.Decoder;
import zmq.DecoderBase;
import zmq.Encoder;
import zmq.EncoderBase;
import zmq.IEngine;
import zmq.IMsgSink;
import zmq.IMsgSource;
import zmq.IOObject;
import zmq.IOThread;
import zmq.IPollEvents;
import zmq.Msg;
import zmq.Options;
import zmq.SessionBase;
import zmq.SocketBase;
import zmq.Transfer;
import zmq.Utils;
import zmq.V1Decoder;
import zmq.V1Encoder;
import zmq.ZError;

public class StreamEngine
implements IEngine,
IPollEvents,
IMsgSink {
    private static final int GREETING_SIZE = 12;
    private boolean ioEnabled;
    private SocketChannel handle;
    private ByteBuffer inbuf;
    private int insize;
    private DecoderBase decoder;
    private Transfer outbuf;
    private int outsize;
    private EncoderBase encoder;
    private boolean handshaking;
    private final ByteBuffer greeting;
    private final ByteBuffer greetingOutputBuffer;
    private SessionBase session;
    private Options options;
    private String endpoint;
    private boolean plugged;
    private SocketBase socket;
    private IOObject ioObject;

    public StreamEngine(SocketChannel handle2, Options options2, String endpoint) {
        this.handle = handle2;
        this.inbuf = null;
        this.insize = 0;
        this.ioEnabled = false;
        this.outbuf = null;
        this.outsize = 0;
        this.handshaking = true;
        this.session = null;
        this.options = options2;
        this.plugged = false;
        this.endpoint = endpoint;
        this.socket = null;
        this.greeting = ByteBuffer.allocate(12).order(ByteOrder.BIG_ENDIAN);
        this.greetingOutputBuffer = ByteBuffer.allocate(12).order(ByteOrder.BIG_ENDIAN);
        this.encoder = null;
        this.decoder = null;
        try {
            Utils.unblockSocket(this.handle);
            if (this.options.sndbuf != 0) {
                this.handle.socket().setSendBufferSize(this.options.sndbuf);
            }
            if (this.options.rcvbuf != 0) {
                this.handle.socket().setReceiveBufferSize(this.options.rcvbuf);
            }
        }
        catch (IOException e2) {
            throw new ZError.IOException(e2);
        }
    }

    private DecoderBase newDecoder(int size2, long max2, SessionBase session, int version2) {
        DecoderBase decoder;
        if (this.options.decoder == null) {
            decoder = version2 == 1 ? new V1Decoder(size2, max2, session) : new Decoder(size2, max2);
        } else {
            try {
                if (version2 == 0) {
                    Constructor<? extends DecoderBase> dcon = this.options.decoder.getConstructor(Integer.TYPE, Long.TYPE);
                    decoder = dcon.newInstance(size2, max2);
                } else {
                    Constructor<? extends DecoderBase> dcon = this.options.decoder.getConstructor(Integer.TYPE, Long.TYPE, IMsgSink.class, Integer.TYPE);
                    decoder = dcon.newInstance(size2, max2, session, version2);
                }
            }
            catch (SecurityException e2) {
                throw new ZError.InstantiationException(e2);
            }
            catch (NoSuchMethodException e3) {
                throw new ZError.InstantiationException(e3);
            }
            catch (InvocationTargetException e4) {
                throw new ZError.InstantiationException(e4);
            }
            catch (IllegalAccessException e5) {
                throw new ZError.InstantiationException(e5);
            }
            catch (InstantiationException e6) {
                throw new ZError.InstantiationException(e6);
            }
        }
        if (this.options.msgAllocator != null) {
            decoder.setMsgAllocator(this.options.msgAllocator);
        }
        return decoder;
    }

    private EncoderBase newEncoder(int size2, SessionBase session, int version2) {
        if (this.options.encoder == null) {
            if (version2 == 1) {
                return new V1Encoder(size2, session);
            }
            return new Encoder(size2);
        }
        try {
            if (version2 == 0) {
                Constructor<? extends EncoderBase> econ = this.options.encoder.getConstructor(Integer.TYPE);
                return econ.newInstance(size2);
            }
            Constructor<? extends EncoderBase> econ = this.options.encoder.getConstructor(Integer.TYPE, IMsgSource.class, Integer.TYPE);
            return econ.newInstance(size2, session, version2);
        }
        catch (SecurityException e2) {
            throw new ZError.InstantiationException(e2);
        }
        catch (NoSuchMethodException e3) {
            throw new ZError.InstantiationException(e3);
        }
        catch (InvocationTargetException e4) {
            throw new ZError.InstantiationException(e4);
        }
        catch (IllegalAccessException e5) {
            throw new ZError.InstantiationException(e5);
        }
        catch (InstantiationException e6) {
            throw new ZError.InstantiationException(e6);
        }
    }

    public void destroy() {
        assert (!this.plugged);
        if (this.handle != null) {
            try {
                this.handle.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.handle = null;
        }
    }

    @Override
    public void plug(IOThread ioThread, SessionBase session) {
        assert (!this.plugged);
        this.plugged = true;
        assert (this.session == null);
        assert (session != null);
        this.session = session;
        this.socket = this.session.getSocket();
        this.ioObject = new IOObject(null);
        this.ioObject.setHandler(this);
        this.ioObject.plug(ioThread);
        this.ioObject.addHandle(this.handle);
        this.ioEnabled = true;
        this.greetingOutputBuffer.put((byte)-1);
        this.greetingOutputBuffer.putLong(this.options.identitySize + 1);
        this.greetingOutputBuffer.put((byte)127);
        this.ioObject.setPollIn(this.handle);
        boolean custom = false;
        try {
            custom = this.options.encoder != null && this.options.encoder.getDeclaredField("RAW_ENCODER") != null;
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        if (!custom) {
            this.outsize = this.greetingOutputBuffer.position();
            this.greetingOutputBuffer.flip();
            this.outbuf = new Transfer.ByteBufferTransfer(this.greetingOutputBuffer);
            this.ioObject.setPollOut(this.handle);
        }
        this.inEvent();
    }

    private void unplug() {
        assert (this.plugged);
        this.plugged = false;
        if (this.ioEnabled) {
            this.ioObject.removeHandle(this.handle);
            this.ioEnabled = false;
        }
        this.ioObject.unplug();
        if (this.encoder != null) {
            this.encoder.setMsgSource(null);
        }
        if (this.decoder != null) {
            this.decoder.setMsgSink(null);
        }
        this.session = null;
    }

    @Override
    public void terminate() {
        this.unplug();
        this.destroy();
    }

    @Override
    public void inEvent() {
        int processed;
        if (this.handshaking && !this.handshake()) {
            return;
        }
        assert (this.decoder != null);
        boolean disconnection = false;
        if (this.insize == 0) {
            this.inbuf = this.decoder.getBuffer();
            this.insize = this.read(this.inbuf);
            this.inbuf.flip();
            if (this.insize == -1) {
                this.insize = 0;
                disconnection = true;
            }
        }
        if ((processed = this.decoder.processBuffer(this.inbuf, this.insize)) == -1) {
            disconnection = true;
        } else {
            if (processed < this.insize) {
                this.ioObject.resetPollIn(this.handle);
            }
            this.insize -= processed;
        }
        this.session.flush();
        if (disconnection) {
            if (this.decoder.stalled()) {
                this.ioObject.removeHandle(this.handle);
                this.ioEnabled = false;
            } else {
                this.error();
            }
        }
    }

    @Override
    public void outEvent() {
        int nbytes;
        if (this.outsize == 0) {
            if (this.encoder == null) {
                assert (this.handshaking);
                return;
            }
            this.outbuf = this.encoder.getData(null);
            this.outsize = this.outbuf.remaining();
            if (this.outbuf.remaining() == 0) {
                this.ioObject.resetPollOut(this.handle);
                if (this.encoder.isError()) {
                    this.error();
                }
                return;
            }
        }
        if ((nbytes = this.write(this.outbuf)) == -1) {
            this.ioObject.resetPollOut(this.handle);
            return;
        }
        this.outsize -= nbytes;
        if (this.handshaking && this.outsize == 0) {
            this.ioObject.resetPollOut(this.handle);
        }
        if (this.outsize == 0 && this.encoder != null && this.encoder.isError()) {
            this.error();
        }
    }

    @Override
    public void connectEvent() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void acceptEvent() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void timerEvent(int id2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void activateOut() {
        this.ioObject.setPollOut(this.handle);
        this.outEvent();
    }

    @Override
    public void activateIn() {
        if (!this.ioEnabled) {
            this.decoder.processBuffer(this.inbuf, 0);
            assert (!this.decoder.stalled());
            this.session.flush();
            this.error();
            return;
        }
        this.ioObject.setPollIn(this.handle);
        this.ioObject.inEvent();
    }

    private boolean handshake() {
        assert (this.handshaking);
        while (this.greeting.position() < 12) {
            int n = this.read(this.greeting);
            if (n == -1) {
                this.error();
                return false;
            }
            if (n == 0) {
                return false;
            }
            if ((this.greeting.get(0) & 0xFF) != 255) break;
            if (this.greeting.position() < 10) continue;
            if ((this.greeting.get(9) & 1) == 0) break;
            if (this.greetingOutputBuffer.limit() >= 12) continue;
            if (this.outsize == 0) {
                this.ioObject.setPollOut(this.handle);
            }
            int pos = this.greetingOutputBuffer.position();
            this.greetingOutputBuffer.position(10).limit(12);
            this.greetingOutputBuffer.put((byte)1);
            this.greetingOutputBuffer.put((byte)this.options.type);
            this.greetingOutputBuffer.position(pos);
            this.outsize += 2;
        }
        int versionPos = 10;
        if ((this.greeting.get(0) & 0xFF) != 255 || (this.greeting.get(9) & 1) == 0) {
            this.encoder = this.newEncoder(Config.OUT_BATCH_SIZE.getValue(), null, 0);
            this.encoder.setMsgSource(this.session);
            this.decoder = this.newDecoder(Config.IN_BATCH_SIZE.getValue(), this.options.maxMsgSize, null, 0);
            this.decoder.setMsgSink(this.session);
            int headerSize = this.options.identitySize + 1 >= 255 ? 10 : 2;
            ByteBuffer tmp = ByteBuffer.allocate(headerSize);
            this.encoder.getData(tmp);
            if (tmp.remaining() != headerSize) {
                return false;
            }
            this.inbuf = this.greeting;
            this.greeting.flip();
            this.insize = this.greeting.remaining();
            if (this.options.type == 1 || this.options.type == 9) {
                this.decoder.setMsgSink(this);
            }
        } else if (this.greeting.get(10) == 0) {
            this.encoder = this.newEncoder(Config.OUT_BATCH_SIZE.getValue(), null, 0);
            this.encoder.setMsgSource(this.session);
            this.decoder = this.newDecoder(Config.IN_BATCH_SIZE.getValue(), this.options.maxMsgSize, null, 0);
            this.decoder.setMsgSink(this.session);
        } else {
            this.encoder = this.newEncoder(Config.OUT_BATCH_SIZE.getValue(), this.session, 1);
            this.decoder = this.newDecoder(Config.IN_BATCH_SIZE.getValue(), this.options.maxMsgSize, this.session, 1);
        }
        if (this.outsize == 0) {
            this.ioObject.setPollOut(this.handle);
        }
        this.handshaking = false;
        return true;
    }

    @Override
    public int pushMsg(Msg msg) {
        assert (this.options.type == 1 || this.options.type == 9);
        int rc = this.session.pushMsg(msg);
        assert (rc == 0);
        msg = new Msg(new byte[]{1});
        rc = this.session.pushMsg(msg);
        this.session.flush();
        assert (this.decoder != null);
        this.decoder.setMsgSink(this.session);
        return rc;
    }

    private void error() {
        assert (this.session != null);
        this.socket.eventDisconnected(this.endpoint, this.handle);
        this.session.detach();
        this.unplug();
        this.destroy();
    }

    private int write(Transfer buf) {
        int nbytes;
        try {
            nbytes = buf.transferTo(this.handle);
        }
        catch (IOException e2) {
            return -1;
        }
        return nbytes;
    }

    private int read(ByteBuffer buf) {
        int nbytes;
        try {
            nbytes = this.handle.read(buf);
        }
        catch (IOException e2) {
            return -1;
        }
        return nbytes;
    }
}

