/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import zmq.Address;
import zmq.Ctx;
import zmq.IOThread;
import zmq.Msg;
import zmq.Options;
import zmq.Router;
import zmq.SocketBase;

public class Rep
extends Router {
    private boolean sendingReply = false;
    private boolean requestBegins = true;

    public Rep(Ctx parent2, int tid, int sid) {
        super(parent2, tid, sid);
        this.options.type = 4;
    }

    @Override
    protected boolean xsend(Msg msg) {
        if (!this.sendingReply) {
            throw new IllegalStateException("Cannot send another reply");
        }
        boolean more = msg.hasMore();
        boolean rc = super.xsend(msg);
        if (!rc) {
            return rc;
        }
        if (!more) {
            this.sendingReply = false;
        }
        return true;
    }

    @Override
    protected Msg xrecv() {
        if (this.sendingReply) {
            throw new IllegalStateException("Cannot receive another request");
        }
        Msg msg = null;
        if (this.requestBegins) {
            while (true) {
                if ((msg = super.xrecv()) == null) {
                    return null;
                }
                if (msg.hasMore()) {
                    boolean bottom = msg.size() == 0;
                    boolean rc = super.xsend(msg);
                    assert (rc);
                    if (!bottom) continue;
                    break;
                }
                super.rollback();
            }
            this.requestBegins = false;
        }
        if ((msg = super.xrecv()) == null) {
            return null;
        }
        if (!msg.hasMore()) {
            this.sendingReply = true;
            this.requestBegins = true;
        }
        return msg;
    }

    @Override
    protected boolean xhasIn() {
        return !this.sendingReply && super.xhasIn();
    }

    @Override
    protected boolean xhasOut() {
        return this.sendingReply && super.xhasOut();
    }

    public static class RepSession
    extends Router.RouterSession {
        public RepSession(IOThread ioThread, boolean connect, SocketBase socket, Options options2, Address addr) {
            super(ioThread, connect, socket, options2, addr);
        }
    }
}

