/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import zmq.Blob;
import zmq.Config;
import zmq.Msg;
import zmq.YPipe;
import zmq.ZObject;

class Pipe
extends ZObject {
    private YPipe<Msg> inpipe;
    private YPipe<Msg> outpipe;
    private boolean inActive;
    private boolean outActive;
    private int hwm;
    private int lwm;
    private long msgsRead;
    private long msgsWritten;
    private long peersMsgsRead;
    private Pipe peer;
    private IPipeEvents sink;
    private State state;
    private boolean delay;
    private Blob identity;
    private ZObject parent;

    private Pipe(ZObject parent2, YPipe<Msg> inpipe, YPipe<Msg> outpipe, int inhwm, int outhwm, boolean delay2) {
        super(parent2);
        this.inpipe = inpipe;
        this.outpipe = outpipe;
        this.inActive = true;
        this.outActive = true;
        this.hwm = outhwm;
        this.lwm = Pipe.computeLwm(inhwm);
        this.msgsRead = 0L;
        this.msgsWritten = 0L;
        this.peersMsgsRead = 0L;
        this.peer = null;
        this.sink = null;
        this.state = State.ACTIVE;
        this.delay = delay2;
        this.parent = parent2;
    }

    public static void pipepair(ZObject[] parents, Pipe[] pipes, int[] hwms, boolean[] delays) {
        YPipe<Msg> upipe1 = new YPipe<Msg>(Config.MESSAGE_PIPE_GRANULARITY.getValue());
        YPipe<Msg> upipe2 = new YPipe<Msg>(Config.MESSAGE_PIPE_GRANULARITY.getValue());
        pipes[0] = new Pipe(parents[0], upipe1, upipe2, hwms[1], hwms[0], delays[0]);
        pipes[1] = new Pipe(parents[1], upipe2, upipe1, hwms[0], hwms[1], delays[1]);
        pipes[0].setPeer(pipes[1]);
        pipes[1].setPeer(pipes[0]);
    }

    private void setPeer(Pipe peer) {
        assert (peer != null);
        this.peer = peer;
    }

    public void setEventSink(IPipeEvents sink) {
        assert (this.sink == null);
        this.sink = sink;
    }

    public void setIdentity(Blob identity2) {
        this.identity = identity2;
    }

    public Blob getIdentity() {
        return this.identity;
    }

    public boolean checkRead() {
        if (!this.inActive || this.state != State.ACTIVE && this.state != State.PENDING) {
            return false;
        }
        if (!this.inpipe.checkRead()) {
            this.inActive = false;
            return false;
        }
        if (Pipe.isDelimiter(this.inpipe.probe())) {
            Msg msg = this.inpipe.read();
            assert (msg != null);
            this.delimit();
            return false;
        }
        return true;
    }

    public Msg read() {
        if (!this.inActive || this.state != State.ACTIVE && this.state != State.PENDING) {
            return null;
        }
        Msg msg = this.inpipe.read();
        if (msg == null) {
            this.inActive = false;
            return null;
        }
        if (msg.isDelimiter()) {
            this.delimit();
            return null;
        }
        if (!msg.hasMore()) {
            ++this.msgsRead;
        }
        if (this.lwm > 0 && this.msgsRead % (long)this.lwm == 0L) {
            this.sendActivateWrite(this.peer, this.msgsRead);
        }
        return msg;
    }

    public boolean checkWrite() {
        boolean full;
        if (!this.outActive || this.state != State.ACTIVE) {
            return false;
        }
        boolean bl = full = this.hwm > 0 && this.msgsWritten - this.peersMsgsRead == (long)this.hwm;
        if (full) {
            this.outActive = false;
            return false;
        }
        return true;
    }

    public boolean write(Msg msg) {
        if (!this.checkWrite()) {
            return false;
        }
        boolean more = msg.hasMore();
        this.outpipe.write(msg, more);
        if (!more) {
            ++this.msgsWritten;
        }
        return true;
    }

    public void rollback() {
        if (this.outpipe != null) {
            Msg msg;
            while ((msg = this.outpipe.unwrite()) != null) {
                assert ((msg.flags() & 1) > 0);
            }
        }
    }

    public void flush() {
        if (this.state == State.TERMINATING) {
            return;
        }
        if (this.outpipe != null && !this.outpipe.flush()) {
            this.sendActivateRead(this.peer);
        }
    }

    @Override
    protected void processActivateRead() {
        if (!(this.inActive || this.state != State.ACTIVE && this.state != State.PENDING)) {
            this.inActive = true;
            this.sink.readActivated(this);
        }
    }

    @Override
    protected void processActivateWrite(long msgsRead) {
        this.peersMsgsRead = msgsRead;
        if (!this.outActive && this.state == State.ACTIVE) {
            this.outActive = true;
            this.sink.writeActivated(this);
        }
    }

    @Override
    protected void processHiccup(Object pipe) {
        assert (this.outpipe != null);
        this.outpipe.flush();
        while (this.outpipe.read() != null) {
        }
        assert (pipe != null);
        this.outpipe = (YPipe)pipe;
        this.outActive = true;
        if (this.state == State.ACTIVE) {
            this.sink.hiccuped(this);
        }
    }

    @Override
    protected void processPipeTerm() {
        if (this.state == State.ACTIVE) {
            if (!this.delay) {
                this.state = State.TERMINATING;
                this.outpipe = null;
                this.sendPipeTermAck(this.peer);
            } else {
                this.state = State.PENDING;
            }
            return;
        }
        if (this.state == State.DELIMITED) {
            this.state = State.TERMINATING;
            this.outpipe = null;
            this.sendPipeTermAck(this.peer);
            return;
        }
        if (this.state == State.TERMINATED) {
            this.state = State.DOUBLE_TERMINATED;
            this.outpipe = null;
            this.sendPipeTermAck(this.peer);
            return;
        }
        assert (false);
    }

    @Override
    protected void processPipeTermAck() {
        assert (this.sink != null);
        this.sink.pipeTerminated(this);
        if (this.state == State.TERMINATED) {
            this.outpipe = null;
            this.sendPipeTermAck(this.peer);
        } else assert (this.state == State.TERMINATING || this.state == State.DOUBLE_TERMINATED);
        while (this.inpipe.read() != null) {
        }
        this.inpipe = null;
    }

    public void terminate(boolean delay2) {
        this.delay = delay2;
        if (this.state == State.TERMINATED || this.state == State.DOUBLE_TERMINATED) {
            return;
        }
        if (this.state == State.TERMINATING) {
            return;
        }
        if (this.state == State.ACTIVE) {
            this.sendPipeTerm(this.peer);
            this.state = State.TERMINATED;
        } else if (this.state == State.PENDING && !this.delay) {
            this.outpipe = null;
            this.sendPipeTermAck(this.peer);
            this.state = State.TERMINATING;
        } else if (this.state != State.PENDING) {
            if (this.state == State.DELIMITED) {
                this.sendPipeTerm(this.peer);
                this.state = State.TERMINATED;
            } else assert (false);
        }
        this.outActive = false;
        if (this.outpipe != null) {
            this.rollback();
            Msg msg = new Msg();
            msg.initDelimiter();
            this.outpipe.write(msg, false);
            this.flush();
        }
    }

    private static boolean isDelimiter(Msg msg) {
        return msg.isDelimiter();
    }

    private static int computeLwm(int hwm) {
        return hwm > Config.MAX_WM_DELTA.getValue() * 2 ? hwm - Config.MAX_WM_DELTA.getValue() : (hwm + 1) / 2;
    }

    private void delimit() {
        if (this.state == State.ACTIVE) {
            this.state = State.DELIMITED;
            return;
        }
        if (this.state == State.PENDING) {
            this.outpipe = null;
            this.sendPipeTermAck(this.peer);
            this.state = State.TERMINATING;
            return;
        }
        assert (false);
    }

    public void hiccup() {
        if (this.state != State.ACTIVE) {
            return;
        }
        this.inpipe = null;
        this.inpipe = new YPipe(Config.MESSAGE_PIPE_GRANULARITY.getValue());
        this.inActive = true;
        this.sendHiccup(this.peer, this.inpipe);
    }

    public boolean checkHwm() {
        boolean full = this.hwm > 0 && this.msgsWritten - this.peersMsgsRead >= (long)(this.hwm - 1);
        return !full;
    }

    public String toString() {
        return super.toString() + "[" + this.parent + "]";
    }

    static enum State {
        ACTIVE,
        DELIMITED,
        PENDING,
        TERMINATING,
        TERMINATED,
        DOUBLE_TERMINATED;

    }

    static interface IPipeEvents {
        public void readActivated(Pipe var1);

        public void writeActivated(Pipe var1);

        public void hiccuped(Pipe var1);

        public void pipeTerminated(Pipe var1);
    }
}

