/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import zmq.Pipe;
import zmq.Utils;

public class Mtrie {
    private Set<Pipe> pipes = null;
    private int min = 0;
    private int count = 0;
    private int liveNodes = 0;
    private Mtrie[] next = null;

    public boolean add(byte[] prefix, Pipe pipe) {
        return this.addHelper(prefix, 0, pipe);
    }

    public boolean add(byte[] prefix, int start2, Pipe pipe) {
        return this.addHelper(prefix, start2, pipe);
    }

    private boolean addHelper(byte[] prefix, int start2, Pipe pipe) {
        if (prefix == null || prefix.length == start2) {
            boolean result2;
            boolean bl = result2 = this.pipes == null;
            if (this.pipes == null) {
                this.pipes = new HashSet<Pipe>();
            }
            this.pipes.add(pipe);
            return result2;
        }
        int c2 = prefix[start2];
        if (c2 < this.min || c2 >= this.min + this.count) {
            if (this.count == 0) {
                this.min = c2;
                this.count = 1;
                this.next = null;
            } else if (this.count == 1) {
                int oldc = this.min;
                Mtrie oldp = this.next[0];
                this.count = (this.min < c2 ? c2 - this.min : this.min - c2) + 1;
                this.next = new Mtrie[this.count];
                this.min = Math.min(this.min, c2);
                this.next[oldc - this.min] = oldp;
            } else if (this.min < c2) {
                this.count = c2 - this.min + 1;
                this.next = this.realloc(this.next, this.count, true);
            } else {
                this.count = this.min + this.count - c2;
                this.next = this.realloc(this.next, this.count, false);
                this.min = c2;
            }
        }
        if (this.count == 1) {
            if (this.next == null) {
                this.next = new Mtrie[1];
                this.next[0] = new Mtrie();
                ++this.liveNodes;
            }
            return this.next[0].addHelper(prefix, start2 + 1, pipe);
        }
        if (this.next[c2 - this.min] == null) {
            this.next[c2 - this.min] = new Mtrie();
            ++this.liveNodes;
        }
        return this.next[c2 - this.min].addHelper(prefix, start2 + 1, pipe);
    }

    private Mtrie[] realloc(Mtrie[] table, int size2, boolean ended) {
        return Utils.realloc(Mtrie.class, table, size2, ended);
    }

    public boolean rm(Pipe pipe, IMtrieHandler func, Object arg, boolean callOnUniq) {
        return this.rmHelper(pipe, new byte[0], 0, 0, func, arg, callOnUniq);
    }

    private boolean rmHelper(Pipe pipe, byte[] buff, int buffsize, int maxBuffSize, IMtrieHandler func, Object arg, boolean callOnUniq) {
        if (this.pipes != null && this.pipes.remove(pipe)) {
            if (!callOnUniq || this.pipes.isEmpty()) {
                func.invoke(null, buff, buffsize, arg);
            }
            if (this.pipes.isEmpty()) {
                this.pipes = null;
            }
        }
        if (buffsize >= maxBuffSize) {
            maxBuffSize = buffsize + 256;
            buff = Utils.realloc(buff, maxBuffSize);
        }
        if (this.count == 0) {
            return true;
        }
        if (this.count == 1) {
            buff[buffsize] = (byte)this.min;
            this.next[0].rmHelper(pipe, buff, ++buffsize, maxBuffSize, func, arg, callOnUniq);
            if (this.next[0].isRedundant()) {
                this.next = null;
                this.count = 0;
                --this.liveNodes;
                assert (this.liveNodes == 0);
            }
            return true;
        }
        int newMin = this.min + this.count - 1;
        int newMax = this.min;
        for (int c2 = 0; c2 != this.count; ++c2) {
            buff[buffsize] = (byte)(this.min + c2);
            if (this.next[c2] == null) continue;
            this.next[c2].rmHelper(pipe, buff, buffsize + 1, maxBuffSize, func, arg, callOnUniq);
            if (this.next[c2].isRedundant()) {
                this.next[c2] = null;
                assert (this.liveNodes > 0);
                --this.liveNodes;
                continue;
            }
            if (c2 + this.min < newMin) {
                newMin = c2 + this.min;
            }
            if (c2 + this.min <= newMax) continue;
            newMax = c2 + this.min;
        }
        assert (this.count > 1);
        if (this.liveNodes == 0) {
            this.next = null;
            this.count = 0;
        } else if (this.liveNodes == 1) {
            assert (newMin == newMax);
            assert (newMin >= this.min && newMin < this.min + this.count);
            Mtrie node4 = this.next[newMin - this.min];
            assert (node4 != null);
            this.next = null;
            this.next = new Mtrie[]{node4};
            this.count = 1;
            this.min = newMin;
        } else if (newMin > this.min || newMax < this.min + this.count - 1) {
            assert (newMax - newMin + 1 > 1);
            Mtrie[] oldTable = this.next;
            assert (newMin > this.min || newMax < this.min + this.count - 1);
            assert (newMin >= this.min);
            assert (newMax <= this.min + this.count - 1);
            assert (newMax - newMin + 1 < this.count);
            this.count = newMax - newMin + 1;
            this.next = new Mtrie[this.count];
            System.arraycopy(oldTable, newMin - this.min, this.next, 0, this.count);
            this.min = newMin;
        }
        return true;
    }

    public boolean rm(byte[] prefix, int start2, Pipe pipe) {
        return this.rmHelper(prefix, start2, pipe);
    }

    private boolean rmHelper(byte[] prefix, int start2, Pipe pipe) {
        Mtrie nextNode;
        if (prefix == null || prefix.length == start2) {
            if (this.pipes != null) {
                boolean erased = this.pipes.remove(pipe);
                assert (erased);
                if (this.pipes.isEmpty()) {
                    this.pipes = null;
                }
            }
            return this.pipes == null;
        }
        byte c2 = prefix[start2];
        if (this.count == 0 || c2 < this.min || c2 >= this.min + this.count) {
            return false;
        }
        Mtrie mtrie = nextNode = this.count == 1 ? this.next[0] : this.next[c2 - this.min];
        if (nextNode == null) {
            return false;
        }
        boolean ret = nextNode.rmHelper(prefix, start2 + 1, pipe);
        if (nextNode.isRedundant()) {
            assert (this.count > 0);
            if (this.count == 1) {
                this.next = null;
                this.count = 0;
                --this.liveNodes;
                assert (this.liveNodes == 0);
            } else {
                this.next[c2 - this.min] = null;
                assert (this.liveNodes > 1);
                --this.liveNodes;
                if (this.liveNodes == 1) {
                    int i;
                    for (i = 0; i < this.count && this.next[i] == null; ++i) {
                    }
                    assert (i < this.count);
                    this.min += i;
                    this.count = 1;
                    Mtrie old = this.next[i];
                    this.next = new Mtrie[]{old};
                } else if (c2 == this.min) {
                    int i;
                    for (i = 1; i < this.count && this.next[i] == null; ++i) {
                    }
                    assert (i < this.count);
                    this.min += i;
                    this.count -= i;
                    this.next = this.realloc(this.next, this.count, true);
                } else if (c2 == this.min + this.count - 1) {
                    int i;
                    for (i = 1; i < this.count && this.next[this.count - 1 - i] == null; ++i) {
                    }
                    assert (i < this.count);
                    this.count -= i;
                    this.next = this.realloc(this.next, this.count, false);
                }
            }
        }
        return ret;
    }

    public void match(ByteBuffer data, int size2, IMtrieHandler func, Object arg) {
        Mtrie current = this;
        int idx = 0;
        while (true) {
            if (current.pipes != null) {
                for (Pipe it : current.pipes) {
                    func.invoke(it, null, 0, arg);
                }
            }
            if (size2 == 0 || current.count == 0) break;
            byte c2 = data.get(idx);
            if (current.count == 1) {
                if (c2 != current.min) break;
                current = current.next[0];
                ++idx;
                --size2;
                continue;
            }
            if (c2 < current.min || c2 >= current.min + current.count || current.next[c2 - current.min] == null) break;
            current = current.next[c2 - current.min];
            ++idx;
            --size2;
        }
    }

    private boolean isRedundant() {
        return this.pipes == null && this.liveNodes == 0;
    }

    public static interface IMtrieHandler {
        public void invoke(Pipe var1, byte[] var2, int var3, Object var4);
    }
}

