/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.SelectableChannel;
import zmq.Command;
import zmq.Ctx;
import zmq.IPollEvents;
import zmq.Mailbox;
import zmq.Poller;
import zmq.ZObject;

public class IOThread
extends ZObject
implements IPollEvents,
Closeable {
    private final Mailbox mailbox;
    private final SelectableChannel mailboxHandle;
    private final Poller poller;
    final String name;

    public IOThread(Ctx ctx, int tid) {
        super(ctx, tid);
        this.name = "iothread-" + tid;
        this.poller = new Poller(this.name);
        this.mailbox = new Mailbox(this.name);
        this.mailboxHandle = this.mailbox.getFd();
        this.poller.addHandle(this.mailboxHandle, this);
        this.poller.setPollIn(this.mailboxHandle);
    }

    public void start() {
        this.poller.start();
    }

    @Override
    public void close() throws IOException {
        this.poller.destroy();
        this.mailbox.close();
    }

    public void stop() {
        this.sendStop();
    }

    public Mailbox getMailbox() {
        return this.mailbox;
    }

    public int getLoad() {
        return this.poller.getLoad();
    }

    @Override
    public void inEvent() {
        Command cmd;
        while ((cmd = this.mailbox.recv(0L)) != null) {
            cmd.destination().processCommand(cmd);
        }
    }

    @Override
    public void outEvent() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void connectEvent() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void acceptEvent() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void timerEvent(int id2) {
        throw new UnsupportedOperationException();
    }

    public Poller getPoller() {
        assert (this.poller != null);
        return this.poller;
    }

    @Override
    protected void processStop() {
        this.poller.removeHandle(this.mailboxHandle);
        this.poller.stop();
    }
}

