/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.stm.skel;

import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.stm.InTxn;
import scala.concurrent.stm.InTxnEnd;
import scala.concurrent.stm.NestingLevel;
import scala.concurrent.stm.Txn;
import scala.concurrent.stm.Txn$Active$;
import scala.concurrent.stm.Txn$Committed$;
import scala.concurrent.stm.Txn$Committing$;
import scala.concurrent.stm.TxnExecutor;
import scala.concurrent.stm.skel.AbstractInTxn;
import scala.concurrent.stm.skel.AbstractNestingLevel;
import scala.concurrent.stm.skel.CallbackList;
import scala.concurrent.stm.skel.RollbackError$;
import scala.runtime.BoxedUnit;

public abstract class AbstractInTxn$class {
    public static void requireActive(AbstractInTxn $this) {
        Txn.Status status = $this.internalCurrentLevel().status();
        if (Txn$Active$.MODULE$.equals(status)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (status instanceof Txn.RolledBack) {
            throw RollbackError$.MODULE$;
        }
        throw new IllegalStateException(status.toString());
    }

    public static void requireNotDecided(AbstractInTxn $this) {
        Txn.Status status = $this.internalCurrentLevel().status();
        if (status.decided()) {
            if (status instanceof Txn.RolledBack) {
                throw RollbackError$.MODULE$;
            }
            throw new IllegalStateException(status.toString());
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static void requireNotCompleted(AbstractInTxn $this) {
        Txn.Status status = $this.internalCurrentLevel().status();
        if (status.completed()) {
            if (status instanceof Txn.RolledBack) {
                throw RollbackError$.MODULE$;
            }
            throw new IllegalStateException(status.toString());
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static Txn.ExternalDecider externalDecider(AbstractInTxn $this) {
        return $this.scala$concurrent$stm$skel$AbstractInTxn$$_decider();
    }

    public static boolean writeResourcesPresent(AbstractInTxn $this) {
        return $this.scala$concurrent$stm$skel$AbstractInTxn$$_callbacksPresent() && AbstractInTxn$class.writeResourcesPresentImpl($this);
    }

    private static boolean writeResourcesPresentImpl(AbstractInTxn $this) {
        return !$this.scala$concurrent$stm$skel$AbstractInTxn$$_whilePreparingList().isEmpty() || !$this.scala$concurrent$stm$skel$AbstractInTxn$$_whileCommittingList().isEmpty() || $this.externalDecider() != null;
    }

    public static void fireBeforeCommitCallbacks(AbstractInTxn $this) {
        if ($this.scala$concurrent$stm$skel$AbstractInTxn$$_callbacksPresent()) {
            $this.scala$concurrent$stm$skel$AbstractInTxn$$_beforeCommitList().fire($this.internalCurrentLevel(), $this);
        }
    }

    public static void fireWhilePreparingCallbacks(AbstractInTxn $this) {
        if ($this.scala$concurrent$stm$skel$AbstractInTxn$$_callbacksPresent() && !$this.scala$concurrent$stm$skel$AbstractInTxn$$_whilePreparingList().isEmpty()) {
            $this.scala$concurrent$stm$skel$AbstractInTxn$$_whilePreparingList().fire($this.internalCurrentLevel(), $this);
        }
    }

    public static Throwable fireWhileCommittingCallbacks(AbstractInTxn $this, TxnExecutor exec2) {
        return $this.scala$concurrent$stm$skel$AbstractInTxn$$_callbacksPresent() && !$this.scala$concurrent$stm$skel$AbstractInTxn$$_whileCommittingList().isEmpty() ? AbstractInTxn$class.fireWhileCommittingCallbacksImpl($this, exec2) : null;
    }

    /*
     * WARNING - void declaration
     */
    private static Throwable fireWhileCommittingCallbacksImpl(AbstractInTxn $this, TxnExecutor exec2) {
        void var2_2;
        Throwable failure2 = null;
        for (int i = 0; i < $this.scala$concurrent$stm$skel$AbstractInTxn$$_whileCommittingList().size(); ++i) {
            failure2 = AbstractInTxn$class.firePostDecision($this, $this.scala$concurrent$stm$skel$AbstractInTxn$$_whileCommittingList().apply(i), $this, exec2, Txn$Committing$.MODULE$, failure2);
        }
        return var2_2;
    }

    public static void fireAfterCompletionAndThrow(AbstractInTxn $this, Function1[] handlers, TxnExecutor exec2, Txn.Status s, Throwable pendingFailure) {
        Throwable f2;
        Throwable throwable2 = f2 = handlers != null ? $this.fireAfterCompletion(handlers, exec2, s, pendingFailure) : pendingFailure;
        if (f2 == null) {
            return;
        }
        throw f2;
    }

    public static Throwable fireAfterCompletion(AbstractInTxn $this, Function1[] handlers, TxnExecutor exec2, Txn.Status s, Throwable f0) {
        int dj;
        Throwable failure2 = f0;
        int i = 0;
        boolean inOrder = s == Txn$Committed$.MODULE$;
        int j = inOrder ? 0 : handlers.length - 1;
        int n = dj = inOrder ? 1 : -1;
        while (i < handlers.length) {
            failure2 = AbstractInTxn$class.firePostDecision($this, handlers[j], s, exec2, s, failure2);
            ++i;
            j += dj;
        }
        return failure2;
    }

    private static Throwable firePostDecision(AbstractInTxn $this, Function1 handler, Object arg, TxnExecutor exec2, Txn.Status s, Throwable f2) {
        Throwable throwable2;
        try {
            handler.apply(arg);
            throwable2 = f2;
        }
        catch (Throwable throwable3) {
            try {
                exec2.postDecisionFailureHandler().apply((Object)s, (Object)throwable3);
                throwable2 = f2;
            }
            catch (Throwable throwable4) {
                throwable2 = throwable4;
            }
        }
        return throwable2;
    }

    public static void checkpointCallbacks(AbstractInTxn $this) {
        if ($this.scala$concurrent$stm$skel$AbstractInTxn$$_callbacksPresent()) {
            AbstractInTxn$class.checkpointCallbacksImpl($this);
        }
    }

    private static void checkpointCallbacksImpl(AbstractInTxn $this) {
        AbstractNestingLevel level = $this.internalCurrentLevel();
        level._beforeCommitSize_$eq($this.scala$concurrent$stm$skel$AbstractInTxn$$_beforeCommitList().size());
        level._whileValidatingSize_$eq($this.scala$concurrent$stm$skel$AbstractInTxn$$_whileValidatingList().size());
        level._whilePreparingSize_$eq($this.scala$concurrent$stm$skel$AbstractInTxn$$_whilePreparingList().size());
        level._whileCommittingSize_$eq($this.scala$concurrent$stm$skel$AbstractInTxn$$_whileCommittingList().size());
        level._afterCommitSize_$eq($this.scala$concurrent$stm$skel$AbstractInTxn$$_afterCommitList().size());
        level._afterRollbackSize_$eq($this.scala$concurrent$stm$skel$AbstractInTxn$$_afterRollbackList().size());
    }

    public static Function1[] rollbackCallbacks(AbstractInTxn $this) {
        return $this.scala$concurrent$stm$skel$AbstractInTxn$$_callbacksPresent() ? AbstractInTxn$class.rollbackCallbacksImpl($this) : null;
    }

    private static Function1[] rollbackCallbacksImpl(AbstractInTxn $this) {
        AbstractNestingLevel level = $this.internalCurrentLevel();
        $this.scala$concurrent$stm$skel$AbstractInTxn$$_beforeCommitList().size_$eq(level._beforeCommitSize());
        $this.scala$concurrent$stm$skel$AbstractInTxn$$_whileValidatingList().size_$eq(level._whileValidatingSize());
        $this.scala$concurrent$stm$skel$AbstractInTxn$$_whilePreparingList().size_$eq(level._whilePreparingSize());
        $this.scala$concurrent$stm$skel$AbstractInTxn$$_whileCommittingList().size_$eq(level._whileCommittingSize());
        $this.scala$concurrent$stm$skel$AbstractInTxn$$_afterCommitList().size_$eq(level._afterCommitSize());
        return $this.scala$concurrent$stm$skel$AbstractInTxn$$_afterRollbackList().truncate(level._afterRollbackSize());
    }

    public static Function1[] resetCallbacks(AbstractInTxn $this) {
        return $this.scala$concurrent$stm$skel$AbstractInTxn$$_callbacksPresent() ? AbstractInTxn$class.resetCallbacksImpl($this) : null;
    }

    private static Function1[] resetCallbacksImpl(AbstractInTxn $this) {
        $this.scala$concurrent$stm$skel$AbstractInTxn$$_beforeCommitList().size_$eq(0);
        $this.scala$concurrent$stm$skel$AbstractInTxn$$_whileValidatingList().size_$eq(0);
        $this.scala$concurrent$stm$skel$AbstractInTxn$$_whilePreparingList().size_$eq(0);
        $this.scala$concurrent$stm$skel$AbstractInTxn$$_whileCommittingList().size_$eq(0);
        $this.scala$concurrent$stm$skel$AbstractInTxn$$_afterRollbackList().size_$eq(0);
        return $this.scala$concurrent$stm$skel$AbstractInTxn$$_afterCommitList().truncate(0);
    }

    public static void fireWhileValidating(AbstractInTxn $this) {
        int n = $this.scala$concurrent$stm$skel$AbstractInTxn$$_whileValidatingList().size();
        if (n > 0) {
            AbstractInTxn$class.fireWhileValidating($this, n - 1, $this.internalCurrentLevel());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void fireWhileValidating(AbstractInTxn $this, int i, AbstractNestingLevel level) {
        while (i >= 0) {
            Object object;
            if (i < level._whileValidatingSize()) {
                level = level.parLevel();
                continue;
            }
            if (level.status() instanceof Txn.RolledBack) {
                int n = level._whileValidatingSize() - 1;
                level = level.parLevel();
                i = n;
                continue;
            }
            try {
                object = $this.scala$concurrent$stm$skel$AbstractInTxn$$_whileValidatingList().apply(i).apply((Object)level);
            }
            catch (Throwable throwable2) {
                object = level.requestRollback(new Txn.UncaughtExceptionCause(throwable2));
            }
            --i;
        }
        return;
    }

    public static AbstractNestingLevel rootLevel(AbstractInTxn $this) {
        return $this.internalCurrentLevel().root();
    }

    public static void beforeCommit(AbstractInTxn $this, Function1 handler) {
        $this.requireActive();
        $this.scala$concurrent$stm$skel$AbstractInTxn$$_callbacksPresent_$eq(true);
        $this.scala$concurrent$stm$skel$AbstractInTxn$$_beforeCommitList().$plus$eq((Function1<InTxn, BoxedUnit>)handler);
    }

    public static void whileValidating(AbstractInTxn $this, Function1 handler) {
        $this.requireActive();
        $this.scala$concurrent$stm$skel$AbstractInTxn$$_callbacksPresent_$eq(true);
        $this.scala$concurrent$stm$skel$AbstractInTxn$$_whileValidatingList().$plus$eq((Function1<NestingLevel, BoxedUnit>)handler);
    }

    public static void whilePreparing(AbstractInTxn $this, Function1 handler) {
        $this.requireNotDecided();
        $this.scala$concurrent$stm$skel$AbstractInTxn$$_callbacksPresent_$eq(true);
        $this.scala$concurrent$stm$skel$AbstractInTxn$$_whilePreparingList().$plus$eq((Function1<InTxnEnd, BoxedUnit>)handler);
    }

    public static void whileCommitting(AbstractInTxn $this, Function1 handler) {
        $this.requireNotCompleted();
        $this.scala$concurrent$stm$skel$AbstractInTxn$$_callbacksPresent_$eq(true);
        $this.scala$concurrent$stm$skel$AbstractInTxn$$_whileCommittingList().$plus$eq((Function1<InTxnEnd, BoxedUnit>)handler);
    }

    public static void afterCommit(AbstractInTxn $this, Function1 handler) {
        $this.requireNotCompleted();
        $this.scala$concurrent$stm$skel$AbstractInTxn$$_callbacksPresent_$eq(true);
        $this.scala$concurrent$stm$skel$AbstractInTxn$$_afterCommitList().$plus$eq((Function1<Txn.Status, BoxedUnit>)handler);
    }

    public static void afterRollback(AbstractInTxn $this, Function1 handler) {
        try {
            $this.requireNotCompleted();
            $this.scala$concurrent$stm$skel$AbstractInTxn$$_callbacksPresent_$eq(true);
            $this.scala$concurrent$stm$skel$AbstractInTxn$$_afterRollbackList().$plus$eq((Function1<Txn.Status, BoxedUnit>)handler);
            return;
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            if (RollbackError$.MODULE$.equals(throwable3)) {
                handler.apply((Object)$this.internalCurrentLevel().status());
                throw RollbackError$.MODULE$;
            }
            throw throwable2;
        }
    }

    public static void afterCompletion(AbstractInTxn $this, Function1 handler) {
        $this.afterRollback((Function1<Txn.Status, BoxedUnit>)handler);
        $this.scala$concurrent$stm$skel$AbstractInTxn$$_afterCommitList().$plus$eq((Function1<Txn.Status, BoxedUnit>)handler);
    }

    public static void setExternalDecider(AbstractInTxn $this, Txn.ExternalDecider decider) {
        block6: {
            block5: {
                block4: {
                    if ($this.status().decided()) {
                        throw new IllegalArgumentException(new StringBuilder().append((Object)"can't set ExternalDecider after decision, status = ").append((Object)$this.status()).toString());
                    }
                    if ($this.scala$concurrent$stm$skel$AbstractInTxn$$_decider() != null) break block4;
                    $this.scala$concurrent$stm$skel$AbstractInTxn$$_decider_$eq(decider);
                    $this.afterCompletion((Function1<Txn.Status, BoxedUnit>)new Serializable($this, decider){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ AbstractInTxn $outer;
                        private final Txn.ExternalDecider decider$1;

                        public final void apply(Txn.Status status) {
                            Predef$.MODULE$.assert(this.$outer.scala$concurrent$stm$skel$AbstractInTxn$$_decider() == this.decider$1);
                            this.$outer.scala$concurrent$stm$skel$AbstractInTxn$$_decider_$eq(null);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.decider$1 = decider$1;
                        }
                    });
                    break block5;
                }
                Txn.ExternalDecider externalDecider = $this.scala$concurrent$stm$skel$AbstractInTxn$$_decider();
                Txn.ExternalDecider externalDecider2 = decider;
                if (externalDecider != null ? !externalDecider.equals(externalDecider2) : externalDecider2 != null) break block6;
            }
            return;
        }
        throw new IllegalArgumentException("can't set two different ExternalDecider-s in the same top-level atomic block");
    }

    public static void $init$(AbstractInTxn $this) {
        $this.scala$concurrent$stm$skel$AbstractInTxn$$_decider_$eq(null);
        $this.scala$concurrent$stm$skel$AbstractInTxn$$_callbacksPresent_$eq(false);
        $this.scala$concurrent$stm$skel$AbstractInTxn$_setter_$scala$concurrent$stm$skel$AbstractInTxn$$_beforeCommitList_$eq(new CallbackList());
        $this.scala$concurrent$stm$skel$AbstractInTxn$_setter_$scala$concurrent$stm$skel$AbstractInTxn$$_whileValidatingList_$eq(new CallbackList());
        $this.scala$concurrent$stm$skel$AbstractInTxn$_setter_$scala$concurrent$stm$skel$AbstractInTxn$$_whilePreparingList_$eq(new CallbackList());
        $this.scala$concurrent$stm$skel$AbstractInTxn$_setter_$scala$concurrent$stm$skel$AbstractInTxn$$_whileCommittingList_$eq(new CallbackList());
        $this.scala$concurrent$stm$skel$AbstractInTxn$_setter_$scala$concurrent$stm$skel$AbstractInTxn$$_afterCommitList_$eq(new CallbackList());
        $this.scala$concurrent$stm$skel$AbstractInTxn$_setter_$scala$concurrent$stm$skel$AbstractInTxn$$_afterRollbackList_$eq(new CallbackList());
    }
}

