/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.stm.ccstm;

import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.PartialFunction;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.concurrent.stm.InTxn;
import scala.concurrent.stm.MaybeTxn$;
import scala.concurrent.stm.ccstm.CCSTM$;
import scala.concurrent.stm.ccstm.Handle;
import scala.concurrent.stm.ccstm.InTxnImpl;
import scala.concurrent.stm.ccstm.WakeupManager;
import scala.concurrent.stm.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

public final class NonTxn$ {
    public static final NonTxn$ MODULE$;

    static {
        new NonTxn$();
    }

    private void weakAwaitUnowned(Handle<?> handle2, long m0) throws InterruptedException {
        CCSTM$.MODULE$.weakAwaitUnowned(handle2, m0, null);
    }

    private void weakAwaitNewVersion(Handle<?> handle2, long m0) throws InterruptedException {
        long m = 0L;
        int spins = 0;
        do {
            long m2;
            if (CCSTM$.MODULE$.version(m2 = handle2.meta()) != CCSTM$.MODULE$.version(m0)) {
                return;
            }
            if (++spins <= CCSTM$.MODULE$.SpinCount()) continue;
            Thread.yield();
        } while (spins < CCSTM$.MODULE$.SpinCount() + CCSTM$.MODULE$.YieldCount());
        this.weakNoSpinAwaitNewVersion(handle2, m);
    }

    private void weakNoSpinAwaitNewVersion(Handle<?> handle2, long m0) throws InterruptedException {
        WakeupManager.Event event = CCSTM$.MODULE$.wakeupManager().subscribe();
        event.addSource(handle2);
        do {
            long m;
            if (CCSTM$.MODULE$.version(m = handle2.meta()) != CCSTM$.MODULE$.version(m0) || CCSTM$.MODULE$.changing(m)) {
                return;
            }
            if (!CCSTM$.MODULE$.pendingWakeups(m) && !handle2.metaCAS(m, CCSTM$.MODULE$.withPendingWakeups(m))) continue;
            event.await();
            return;
        } while (!event.triggered());
    }

    private boolean weakAwaitNewVersion(Handle<?> handle2, long m0, long nanoDeadline) throws InterruptedException {
        long m = 0L;
        int spins = 0;
        do {
            long m2;
            if (CCSTM$.MODULE$.version(m2 = handle2.meta()) != CCSTM$.MODULE$.version(m0)) {
                return true;
            }
            if (++spins <= CCSTM$.MODULE$.SpinCount()) continue;
            if (System.nanoTime() >= nanoDeadline) {
                return false;
            }
            Thread.yield();
        } while (spins < CCSTM$.MODULE$.SpinCount() + CCSTM$.MODULE$.YieldCount());
        if (CCSTM$.MODULE$.changing(m)) {
            this.weakAwaitUnowned(handle2, m);
            return true;
        }
        return this.weakNoSpinAwaitNewVersion(handle2, m, nanoDeadline);
    }

    private boolean weakNoSpinAwaitNewVersion(Handle<?> handle2, long m0, long nanoDeadline) throws InterruptedException {
        WakeupManager.Event event = CCSTM$.MODULE$.wakeupManager().subscribe();
        event.addSource(handle2);
        do {
            long m;
            if (CCSTM$.MODULE$.version(m = handle2.meta()) != CCSTM$.MODULE$.version(m0) || CCSTM$.MODULE$.changing(m)) {
                return true;
            }
            if (!CCSTM$.MODULE$.pendingWakeups(m) && !handle2.metaCAS(m, CCSTM$.MODULE$.withPendingWakeups(m))) continue;
            return event.tryAwaitUntil(nanoDeadline);
        } while (!event.triggered());
        return true;
    }

    private long acquireLock(Handle<?> handle2, boolean exclusive) throws InterruptedException {
        long mOwned;
        long m0 = 0L;
        long m1 = 0L;
        do {
            m0 = handle2.meta();
            while (CCSTM$.MODULE$.owner(m0) != CCSTM$.MODULE$.unownedSlot()) {
                this.weakAwaitUnowned(handle2, m0);
                m0 = handle2.meta();
            }
            mOwned = CCSTM$.MODULE$.withOwner(m0, CCSTM$.MODULE$.nonTxnSlot());
        } while (!handle2.metaCAS(m0, m1 = exclusive ? CCSTM$.MODULE$.withChanging(mOwned) : mOwned));
        return m1;
    }

    private long tryAcquireExclusiveLock(Handle<?> handle2) {
        long m0 = handle2.meta();
        if (CCSTM$.MODULE$.owner(m0) != CCSTM$.MODULE$.unownedSlot()) {
            return 0L;
        }
        long m1 = CCSTM$.MODULE$.withChanging(CCSTM$.MODULE$.withOwner(m0, CCSTM$.MODULE$.nonTxnSlot()));
        if (handle2.metaCAS(m0, m1)) {
            return m1;
        }
        return 0L;
    }

    private long upgradeLock(Handle<?> handle2, long m0) {
        long before = m0;
        if (!handle2.metaCAS(before, CCSTM$.MODULE$.withChanging(before))) {
            before = CCSTM$.MODULE$.withPendingWakeups(before);
            handle2.meta_$eq(CCSTM$.MODULE$.withChanging(before));
        }
        return CCSTM$.MODULE$.withChanging(before);
    }

    private <T> void commitUpdate(Handle<T> handle2, long m0, T newData) {
        long newVersion = CCSTM$.MODULE$.nonTxnWriteVersion(CCSTM$.MODULE$.version(m0));
        handle2.data_$eq(newData);
        this.releaseLock(handle2, m0, newVersion);
    }

    private void discardLock(Handle<?> handle2, long m0) {
        this.releaseLock(handle2, m0, CCSTM$.MODULE$.version(m0));
    }

    private void releaseLock(Handle<?> handle2, long m0, long newVersion) {
        handle2.meta_$eq(CCSTM$.MODULE$.withCommit(m0, newVersion));
        if (CCSTM$.MODULE$.pendingWakeups(m0)) {
            this.triggerWakeups(handle2);
        }
    }

    private void triggerWakeups(Handle<?> handle2) {
        CCSTM$.MODULE$.wakeupManager().trigger(CCSTM$.MODULE$.wakeupManager().prepareToTrigger(handle2));
    }

    public <T> T get(Handle<T> handle2) throws InterruptedException {
        long m0 = 0L;
        for (int tries = 0; tries < 100; ++tries) {
            m0 = handle2.meta();
            if (CCSTM$.MODULE$.changing(m0)) {
                this.weakAwaitUnowned(handle2, m0);
                continue;
            }
            T v2 = handle2.data();
            long m1 = handle2.meta();
            if (CCSTM$.MODULE$.changingAndVersion(m0) != CCSTM$.MODULE$.changingAndVersion(m1)) continue;
            return v2;
        }
        return this.lockedGet(handle2);
    }

    private <T> T lockedGet(Handle<T> handle2) throws InterruptedException {
        long m0 = this.acquireLock(handle2, false);
        T z2 = handle2.data();
        this.discardLock(handle2, m0);
        return z2;
    }

    public <T> void await(Handle<T> handle2, Function1<T, Object> pred) throws InterruptedException {
        while (true) {
            long m0;
            if (CCSTM$.MODULE$.changing(m0 = handle2.meta())) {
                this.weakAwaitUnowned(handle2, m0);
                continue;
            }
            T v2 = handle2.data();
            long m1 = handle2.meta();
            if (CCSTM$.MODULE$.changingAndVersion(m0) != CCSTM$.MODULE$.changingAndVersion(m1)) continue;
            if (BoxesRunTime.unboxToBoolean((Object)pred.apply(v2))) {
                return;
            }
            this.weakAwaitNewVersion(handle2, m1);
        }
    }

    public <T> boolean tryAwait(Handle<T> handle2, Function1<T, Object> pred, long timeoutNanos) {
        long begin = 0L;
        while (true) {
            long m0;
            if (CCSTM$.MODULE$.changing(m0 = handle2.meta())) {
                if (begin == 0L) {
                    begin = System.nanoTime();
                }
                this.weakAwaitUnowned(handle2, m0);
                continue;
            }
            T v2 = handle2.data();
            long m1 = handle2.meta();
            if (CCSTM$.MODULE$.changingAndVersion(m0) != CCSTM$.MODULE$.changingAndVersion(m1)) continue;
            if (BoxesRunTime.unboxToBoolean((Object)pred.apply(v2))) {
                return true;
            }
            if (timeoutNanos <= 0L) {
                return false;
            }
            if (begin == 0L) {
                begin = System.nanoTime();
            }
            if (!this.weakAwaitNewVersion(handle2, m1, begin + timeoutNanos)) break;
        }
        return false;
    }

    public <T> void set(Handle<T> handle2, T v2) throws InterruptedException {
        long m0 = this.acquireLock(handle2, true);
        this.commitUpdate(handle2, m0, v2);
    }

    public <T> T swap(Handle<T> handle2, T v2) throws InterruptedException {
        long m0 = this.acquireLock(handle2, true);
        T z2 = handle2.data();
        this.commitUpdate(handle2, m0, v2);
        return z2;
    }

    public <T> boolean trySet(Handle<T> handle2, T v2) {
        boolean bl;
        long m0 = this.tryAcquireExclusiveLock(handle2);
        if (m0 == 0L) {
            bl = false;
        } else {
            this.commitUpdate(handle2, m0, v2);
            bl = true;
        }
        return bl;
    }

    public <T> boolean compareAndSet(Handle<T> handle2, T before, T after2) throws InterruptedException {
        boolean success2;
        long m0 = handle2.meta();
        if (CCSTM$.MODULE$.owner(m0) != CCSTM$.MODULE$.unownedSlot()) {
            return this.invisibleCAS(handle2, before, after2);
        }
        long m1 = CCSTM$.MODULE$.withOwner(m0, CCSTM$.MODULE$.nonTxnSlot());
        if (handle2.metaCAS(m0, m1)) {
            success2 = false;
            if (BoxesRunTime.equals(before, handle2.data())) {
                success2 = true;
                long m2 = this.upgradeLock(handle2, m1);
                this.commitUpdate(handle2, m2, after2);
            }
            return success2;
        }
        return this.invisibleCAS(handle2, before, after2);
        finally {
            if (!success2) {
                this.discardLock(handle2, m1);
            }
        }
    }

    private <T> boolean invisibleCAS(Handle<T> handle2, T before, T after2) throws InterruptedException {
        boolean success2;
        long m2;
        long m0 = 0L;
        long m1 = 0L;
        Object v2 = null;
        do {
            m0 = handle2.meta();
            while (CCSTM$.MODULE$.changing(m0)) {
                this.weakAwaitUnowned(handle2, m0);
                m0 = handle2.meta();
            }
            v2 = handle2.data();
            m1 = handle2.meta();
        } while (CCSTM$.MODULE$.changingAndVersion(m0) != CCSTM$.MODULE$.changingAndVersion(m1));
        if (BoxesRunTime.equals(before, v2)) {
            m2 = this.acquireLock(handle2, false);
            success2 = false;
            if (CCSTM$.MODULE$.version(m2) == CCSTM$.MODULE$.version(m1) || BoxesRunTime.equals(before, handle2.data())) {
                success2 = true;
                long m3 = this.upgradeLock(handle2, m2);
                this.commitUpdate(handle2, m3, after2);
            }
            return success2;
        }
        return false;
        finally {
            if (!success2) {
                this.discardLock(handle2, m2);
            }
        }
    }

    public <T, R> boolean compareAndSetIdentity(Handle<T> handle2, R before, T after2) throws InterruptedException {
        long m0 = handle2.meta();
        if (CCSTM$.MODULE$.owner(m0) != CCSTM$.MODULE$.unownedSlot()) {
            return this.invisibleCASI(handle2, before, after2);
        }
        long m1 = CCSTM$.MODULE$.withChanging(CCSTM$.MODULE$.withOwner(m0, CCSTM$.MODULE$.nonTxnSlot()));
        if (handle2.metaCAS(m0, m1)) {
            boolean bl;
            if (before == handle2.data()) {
                this.commitUpdate(handle2, m1, after2);
                bl = true;
            } else {
                this.discardLock(handle2, m1);
                bl = false;
            }
            return bl;
        }
        return this.invisibleCASI(handle2, before, after2);
    }

    private <T, R extends T> boolean invisibleCASI(Handle<T> handle2, R before, T after2) throws InterruptedException {
        boolean bl;
        if (before == this.get(handle2)) {
            long m0 = this.acquireLock(handle2, true);
            if (before == handle2.data()) {
                this.commitUpdate(handle2, m0, after2);
                bl = true;
            } else {
                this.discardLock(handle2, m0);
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public <T> T getAndTransform(Handle<T> handle2, Function1<T, T> f2) throws InterruptedException {
        return this.getAndTransformImpl(handle2, f2, this.acquireLock(handle2, false));
    }

    private <T> T getAndTransformImpl(Handle<T> handle2, Function1<T, T> f2, long m0) {
        T v0 = handle2.data();
        try {
            Object repl = f2.apply(v0);
            long m1 = this.upgradeLock(handle2, m0);
            this.commitUpdate(handle2, m1, repl);
        }
        catch (Throwable throwable2) {
            this.discardLock(handle2, m0);
            throw throwable2;
        }
        return v0;
    }

    public <T> T transformAndGet(Handle<T> handle2, Function1<T, T> f2) throws InterruptedException {
        return this.transformAndGetImpl(handle2, f2, this.acquireLock(handle2, false));
    }

    private <T> T transformAndGetImpl(Handle<T> handle2, Function1<T, T> f2, long m0) {
        Object repl;
        try {
            repl = f2.apply(handle2.data());
            long m1 = this.upgradeLock(handle2, m0);
            this.commitUpdate(handle2, m1, repl);
        }
        catch (Throwable throwable2) {
            this.discardLock(handle2, m0);
            throw throwable2;
        }
        return (T)repl;
    }

    /*
     * WARNING - void declaration
     */
    public <T, V> V transformAndExtract(Handle<T> handle2, Function1<T, Tuple2<T, V>> f2) throws InterruptedException {
        Tuple2 pair2;
        long m0 = this.acquireLock(handle2, false);
        try {
            pair2 = (Tuple2)f2.apply(handle2.data());
            long m1 = this.upgradeLock(handle2, m0);
            this.commitUpdate(handle2, m1, pair2._1());
        }
        catch (Throwable throwable2) {
            void var3_3;
            this.discardLock(handle2, (long)var3_3);
            throw throwable2;
        }
        return (V)pair2._2();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> boolean transformIfDefined(Handle<T> handle2, PartialFunction<T, T> pf) throws InterruptedException {
        long m0;
        block4: {
            if (!pf.isDefinedAt(this.get(handle2))) return false;
            m0 = this.acquireLock(handle2, false);
            T v2 = handle2.data();
            try {
                if (!pf.isDefinedAt(v2)) break block4;
            }
            catch (Throwable throwable2) {
                this.discardLock(handle2, m0);
                throw throwable2;
            }
            try {
                Object repl = pf.apply(v2);
                long m1 = this.upgradeLock(handle2, m0);
                this.commitUpdate(handle2, m1, repl);
                return true;
            }
            catch (Throwable throwable3) {
                this.discardLock(handle2, m0);
                throw throwable3;
            }
        }
        this.discardLock(handle2, m0);
        return false;
    }

    public <A, B, Z> Z transform2(Handle<A> handleA, Handle<B> handleB, Function2<A, B, Tuple3<A, B, Z>> f2) throws InterruptedException {
        LongRef mA0 = LongRef.create((long)0L);
        LongRef mB0 = LongRef.create((long)0L);
        int tries = 0;
        do {
            mA0.elem = this.acquireLock(handleA, true);
            mB0.elem = this.tryAcquireExclusiveLock(handleB);
            if (mB0.elem != 0L) continue;
            this.discardLock(handleA, mA0.elem);
            mA0.elem = 0L;
            Handle<A> handle2 = handleA;
            Handle<B> handle3 = handleB;
            if (!(handle2 != null ? !handle2.equals(handle3) : handle3 != null)) {
                return this.fallbackTransform2(handleA, handleB, f2);
            }
            mB0.elem = this.acquireLock(handleB, true);
            mA0.elem = this.tryAcquireExclusiveLock(handleA);
            if (mA0.elem != 0L) continue;
            this.discardLock(handleB, mB0.elem);
            mB0.elem = 0L;
            if (++tries <= 10) continue;
            return this.fallbackTransform2(handleA, handleB, f2);
        } while (mB0.elem == 0L);
        Tuple3 tuple32 = this.liftedTree1$1(handleA, handleB, f2, mA0, mB0);
        if (tuple32 != null) {
            Tuple3 tuple33;
            Object a2 = tuple32._1();
            Object b = tuple32._2();
            Object z2 = tuple32._3();
            Tuple3 tuple34 = tuple33 = new Tuple3(a2, b, z2);
            Object a3 = tuple34._1();
            Object b2 = tuple34._2();
            Object z3 = tuple34._3();
            handleA.data_$eq(a3);
            handleB.data_$eq(b2);
            long wv = CCSTM$.MODULE$.nonTxnWriteVersion(scala.math.package$.MODULE$.max(CCSTM$.MODULE$.version(mA0.elem), CCSTM$.MODULE$.version(mB0.elem)));
            this.releaseLock(handleA, mA0.elem, wv);
            this.releaseLock(handleB, mB0.elem, wv);
            return (Z)z3;
        }
        throw new MatchError((Object)tuple32);
    }

    private <A, B, Z> Z fallbackTransform2(Handle<A> handleA, Handle<B> handleB, Function2<A, B, Tuple3<A, B, Z>> f2) throws InterruptedException {
        return package$.MODULE$.atomic().apply(new Serializable(handleA, handleB, f2){
            public static final long serialVersionUID = 0L;
            private final Handle handleA$4;
            private final Handle handleB$4;
            private final Function2 f$2;

            public final Z apply(InTxn t) {
                T b0;
                InTxnImpl txn = (InTxnImpl)t;
                T a0 = txn.get(this.handleA$4);
                Tuple3 tuple32 = (Tuple3)this.f$2.apply(a0, b0 = txn.get(this.handleB$4));
                if (tuple32 != null) {
                    Tuple3 tuple33;
                    Object a1 = tuple32._1();
                    Object b1 = tuple32._2();
                    Object z2 = tuple32._3();
                    Tuple3 tuple34 = tuple33 = new Tuple3(a1, b1, z2);
                    Object a12 = tuple34._1();
                    Object b12 = tuple34._2();
                    Object z3 = tuple34._3();
                    txn.set(this.handleA$4, a12);
                    txn.set(this.handleB$4, b12);
                    return (Z)z3;
                }
                throw new MatchError((Object)tuple32);
            }
            {
                this.handleA$4 = handleA$4;
                this.handleB$4 = handleB$4;
                this.f$2 = f$2;
            }
        }, MaybeTxn$.MODULE$.unknown());
    }

    /*
     * WARNING - void declaration
     */
    public <A, B> boolean ccasi(Handle<A> handleA, A a0, Handle<B> handleB, B b0, B b1) throws InterruptedException {
        block0: for (int tries = 0; tries < 10; ++tries) {
            void var7_7;
            A a2;
            long mB0 = this.acquireLock(handleB, true);
            if (b0 != handleB.data()) {
                this.discardLock(handleB, mB0);
                return false;
            }
            long mA0 = handleA.meta();
            while (true) {
                long l;
                if (CCSTM$.MODULE$.changing(mA0)) {
                    this.discardLock(handleB, mB0);
                    this.weakAwaitUnowned(handleA, mA0);
                    continue block0;
                }
                a2 = handleA.data();
                long mA1 = handleA.meta();
                if (CCSTM$.MODULE$.changingAndVersion(l) == CCSTM$.MODULE$.changingAndVersion(mA1)) break;
                l = mA1;
            }
            if (a2 == a0) {
                this.commitUpdate(handleB, (long)var7_7, b1);
                return true;
            }
            this.discardLock(handleB, (long)var7_7);
            return false;
        }
        return BoxesRunTime.unboxToBoolean(package$.MODULE$.atomic().apply(new Serializable(handleA, a0, handleB, b0, b1){
            public static final long serialVersionUID = 0L;
            private final Handle handleA$3;
            private final Object a0$2;
            private final Handle handleB$3;
            private final Object b0$2;
            private final Object b1$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(InTxn t) {
                InTxnImpl txn = (InTxnImpl)t;
                if (txn.get(this.handleA$3) != this.a0$2) return false;
                if (txn.get(this.handleB$3) != this.b0$2) return false;
                txn.set(this.handleB$3, this.b1$1);
                if (!true) return false;
                return true;
            }
            {
                this.handleA$3 = handleA$3;
                this.a0$2 = a0$2;
                this.handleB$3 = handleB$3;
                this.b0$2 = b0$2;
                this.b1$1 = b1$1;
            }
        }, MaybeTxn$.MODULE$.unknown()));
    }

    public <A, B> boolean cci(Handle<A> handleA, A a0, Handle<B> handleB, B b0) throws InterruptedException {
        for (int tries = 0; tries < 10; ++tries) {
            long mA0 = handleA.meta();
            long mB0 = handleB.meta();
            if (!CCSTM$.MODULE$.changing(mA0) && !CCSTM$.MODULE$.changing(mB0)) {
                B b = handleB.data();
                A a2 = handleA.data();
                long mA1 = handleA.meta();
                long mB1 = handleB.meta();
                if (CCSTM$.MODULE$.changingAndVersion(mA0) == CCSTM$.MODULE$.changingAndVersion(mA1) && CCSTM$.MODULE$.changingAndVersion(mB0) == CCSTM$.MODULE$.changingAndVersion(mB1)) {
                    return a0 == a2 && b0 == b;
                }
            }
            if (CCSTM$.MODULE$.changing(mA0)) {
                this.weakAwaitUnowned(handleA, mA0);
            }
            if (!CCSTM$.MODULE$.changing(mB0)) continue;
            this.weakAwaitUnowned(handleB, mB0);
        }
        return BoxesRunTime.unboxToBoolean(package$.MODULE$.atomic().apply(new Serializable(handleA, a0, handleB, b0){
            public static final long serialVersionUID = 0L;
            private final Handle handleA$2;
            private final Object a0$1;
            private final Handle handleB$2;
            private final Object b0$1;

            public final boolean apply(InTxn t) {
                InTxnImpl txn = (InTxnImpl)t;
                return txn.get(this.handleA$2) == this.a0$1 && txn.get(this.handleB$2) == this.b0$1;
            }
            {
                this.handleA$2 = handleA$2;
                this.a0$1 = a0$1;
                this.handleB$2 = handleB$2;
                this.b0$1 = b0$1;
            }
        }, MaybeTxn$.MODULE$.unknown()));
    }

    public int getAndAdd(Handle<Object> handle2, int delta) throws InterruptedException {
        long m0 = this.acquireLock(handle2, true);
        int v0 = BoxesRunTime.unboxToInt((Object)handle2.data());
        this.commitUpdate(handle2, m0, BoxesRunTime.boxToInteger((int)(v0 + delta)));
        return v0;
    }

    private final Tuple3 liftedTree1$1(Handle handleA$1, Handle handleB$1, Function2 f$1, LongRef mA0$1, LongRef mB0$1) {
        try {
            return (Tuple3)f$1.apply(handleA$1.data(), handleB$1.data());
        }
        catch (Throwable throwable2) {
            this.discardLock(handleA$1, mA0$1.elem);
            this.discardLock(handleB$1, mB0$1.elem);
            throw throwable2;
        }
    }

    private NonTxn$() {
        MODULE$ = this;
    }
}

