/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.zeromq.ZFrame;
import org.zeromq.ZMQ;

public class ZMsg
implements Iterable<ZFrame>,
Deque<ZFrame> {
    private ArrayDeque<ZFrame> frames = new ArrayDeque();

    public void destroy() {
        if (this.frames == null) {
            return;
        }
        for (ZFrame f2 : this.frames) {
            f2.destroy();
        }
        this.frames.clear();
        this.frames = null;
    }

    public long contentSize() {
        long size2 = 0L;
        for (ZFrame f2 : this.frames) {
            size2 += (long)f2.size();
        }
        return size2;
    }

    public void addString(String str) {
        if (this.frames == null) {
            this.frames = new ArrayDeque();
        }
        this.frames.add(new ZFrame(str));
    }

    public ZMsg duplicate() {
        if (this.frames != null) {
            ZMsg msg = new ZMsg();
            for (ZFrame f2 : this.frames) {
                msg.add(f2.duplicate());
            }
            return msg;
        }
        return null;
    }

    public void wrap(ZFrame frame) {
        if (frame != null) {
            this.push(new ZFrame(""));
            this.push(frame);
        }
    }

    public ZFrame unwrap() {
        if (this.size() == 0) {
            return null;
        }
        ZFrame f2 = this.pop();
        ZFrame empty2 = this.getFirst();
        if (empty2.hasData() && empty2.size() == 0) {
            empty2 = this.pop();
            empty2.destroy();
        }
        return f2;
    }

    public boolean send(ZMQ.Socket socket) {
        return this.send(socket, true);
    }

    public boolean send(ZMQ.Socket socket, boolean destroy) {
        ZFrame f2;
        if (socket == null) {
            throw new IllegalArgumentException("socket is null");
        }
        if (this.frames == null) {
            throw new IllegalArgumentException("destroyed message");
        }
        if (this.frames.size() == 0) {
            return true;
        }
        boolean ret = true;
        Iterator<ZFrame> i = this.frames.iterator();
        while (i.hasNext() && (ret = (f2 = i.next()).sendAndKeep(socket, i.hasNext() ? 2 : 0))) {
        }
        if (destroy) {
            this.destroy();
        }
        return ret;
    }

    public static ZMsg recvMsg(ZMQ.Socket socket) {
        return ZMsg.recvMsg(socket, 0);
    }

    public static ZMsg recvMsg(ZMQ.Socket socket, int flag) {
        ZFrame f2;
        if (socket == null) {
            throw new IllegalArgumentException("socket is null");
        }
        ZMsg msg = new ZMsg();
        do {
            if ((f2 = ZFrame.recvFrame(socket, flag)) == null) {
                msg.destroy();
                msg = null;
                break;
            }
            msg.add(f2);
        } while (f2.hasMore());
        return msg;
    }

    public static boolean save(ZMsg msg, DataOutputStream file2) {
        if (msg == null) {
            return false;
        }
        try {
            file2.writeInt(msg.size());
            if (msg.size() > 0) {
                for (ZFrame f2 : msg) {
                    file2.writeInt(f2.size());
                    file2.write(f2.getData());
                }
            }
            return true;
        }
        catch (IOException e2) {
            return false;
        }
    }

    public static ZMsg load(DataInputStream file2) {
        if (file2 == null) {
            return null;
        }
        ZMsg rcvMsg = new ZMsg();
        try {
            int msgSize = file2.readInt();
            if (msgSize > 0) {
                int msgNbr = 0;
                while (++msgNbr <= msgSize) {
                    int frameSize = file2.readInt();
                    byte[] data = new byte[frameSize];
                    file2.read(data);
                    rcvMsg.add(new ZFrame(data));
                }
            }
            return rcvMsg;
        }
        catch (IOException e2) {
            return null;
        }
    }

    public static ZMsg newStringMsg(String ... strings) {
        ZMsg msg = new ZMsg();
        for (String data : strings) {
            msg.addString(data);
        }
        return msg;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZMsg zMsg = (ZMsg)o;
        if (this.frames == null || zMsg.frames == null) {
            return false;
        }
        Iterator<ZFrame> e1 = this.frames.iterator();
        Iterator<ZFrame> e2 = zMsg.frames.iterator();
        while (e1.hasNext() && e2.hasNext()) {
            ZFrame o1 = e1.next();
            ZFrame o2 = e2.next();
            if (o1 != null ? o1.equals(o2) : o2 == null) continue;
            return false;
        }
        return !e1.hasNext() && !e2.hasNext();
    }

    @Override
    public int hashCode() {
        if (this.frames == null || this.frames.size() == 0) {
            return 0;
        }
        int result2 = 1;
        for (ZFrame frame : this.frames) {
            result2 = 31 * result2 + (frame == null ? 0 : frame.hashCode());
        }
        return result2;
    }

    public void dump(Appendable out2) {
        if (this.frames == null) {
            return;
        }
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.printf("--------------------------------------\n", new Object[0]);
            for (ZFrame frame : this.frames) {
                pw.printf("[%03d] %s\n", frame.size(), frame.toString());
            }
            out2.append(sw.getBuffer());
            sw.close();
        }
        catch (IOException e2) {
            throw new RuntimeException("Message dump exception " + super.toString(), e2);
        }
    }

    public void dump() {
        this.dump(System.out);
    }

    @Override
    public void addFirst(String stringValue) {
        this.addFirst(new ZFrame(stringValue));
    }

    @Override
    public void addFirst(byte[] data) {
        this.addFirst(new ZFrame(data));
    }

    @Override
    public void addLast(String stringValue) {
        this.addLast(new ZFrame(stringValue));
    }

    @Override
    public void addLast(byte[] data) {
        this.addLast(new ZFrame(data));
    }

    @Override
    public void push(String str) {
        this.push(new ZFrame(str));
    }

    @Override
    public void push(byte[] data) {
        this.push(new ZFrame(data));
    }

    @Override
    public boolean add(String stringValue) {
        return this.add(new ZFrame(stringValue));
    }

    @Override
    public boolean add(byte[] data) {
        return this.add(new ZFrame(data));
    }

    @Override
    public Iterator<ZFrame> iterator() {
        return this.frames.iterator();
    }

    @Override
    public boolean addAll(Collection<? extends ZFrame> arg0) {
        return this.frames.addAll(arg0);
    }

    @Override
    public void clear() {
        this.frames.clear();
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        return this.frames.containsAll(arg0);
    }

    @Override
    public boolean isEmpty() {
        return this.frames.isEmpty();
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        return this.frames.removeAll(arg0);
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        return this.frames.retainAll(arg0);
    }

    @Override
    public Object[] toArray() {
        return this.frames.toArray();
    }

    @Override
    public <T> T[] toArray(T[] arg0) {
        return this.frames.toArray(arg0);
    }

    @Override
    public boolean add(ZFrame e2) {
        if (this.frames == null) {
            this.frames = new ArrayDeque();
        }
        return this.frames.add(e2);
    }

    @Override
    public void addFirst(ZFrame e2) {
        if (this.frames == null) {
            this.frames = new ArrayDeque();
        }
        this.frames.addFirst(e2);
    }

    @Override
    public void addLast(ZFrame e2) {
        if (this.frames == null) {
            this.frames = new ArrayDeque();
        }
        this.frames.addLast(e2);
    }

    @Override
    public boolean contains(Object o) {
        return this.frames.contains(o);
    }

    @Override
    public Iterator<ZFrame> descendingIterator() {
        return this.frames.descendingIterator();
    }

    @Override
    public ZFrame element() {
        return this.frames.element();
    }

    @Override
    public ZFrame getFirst() {
        try {
            return this.frames.getFirst();
        }
        catch (NoSuchElementException e2) {
            return null;
        }
    }

    @Override
    public ZFrame getLast() {
        try {
            return this.frames.getLast();
        }
        catch (NoSuchElementException e2) {
            return null;
        }
    }

    @Override
    public boolean offer(ZFrame e2) {
        if (this.frames == null) {
            this.frames = new ArrayDeque();
        }
        return this.frames.offer(e2);
    }

    @Override
    public boolean offerFirst(ZFrame e2) {
        if (this.frames == null) {
            this.frames = new ArrayDeque();
        }
        return this.frames.offerFirst(e2);
    }

    @Override
    public boolean offerLast(ZFrame e2) {
        if (this.frames == null) {
            this.frames = new ArrayDeque();
        }
        return this.frames.offerLast(e2);
    }

    @Override
    public ZFrame peek() {
        return this.frames.peek();
    }

    @Override
    public ZFrame peekFirst() {
        try {
            return this.frames.peekFirst();
        }
        catch (NoSuchElementException e2) {
            return null;
        }
    }

    @Override
    public ZFrame peekLast() {
        try {
            return this.frames.peekLast();
        }
        catch (NoSuchElementException e2) {
            return null;
        }
    }

    @Override
    public ZFrame poll() {
        return this.frames.poll();
    }

    @Override
    public ZFrame pollFirst() {
        return this.frames.pollFirst();
    }

    @Override
    public ZFrame pollLast() {
        return this.frames.pollLast();
    }

    @Override
    public ZFrame pop() {
        if (this.frames == null) {
            this.frames = new ArrayDeque();
        }
        try {
            return this.frames.pop();
        }
        catch (NoSuchElementException e2) {
            return null;
        }
    }

    public String popString() {
        ZFrame frame = this.pop();
        if (frame == null) {
            return null;
        }
        return frame.toString();
    }

    @Override
    public void push(ZFrame e2) {
        if (this.frames == null) {
            this.frames = new ArrayDeque();
        }
        this.frames.push(e2);
    }

    @Override
    public ZFrame remove() {
        return this.frames.remove();
    }

    @Override
    public boolean remove(Object o) {
        return this.frames.remove(o);
    }

    @Override
    public ZFrame removeFirst() {
        try {
            return this.frames.removeFirst();
        }
        catch (NoSuchElementException e2) {
            return null;
        }
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        return this.frames.removeFirstOccurrence(o);
    }

    @Override
    public ZFrame removeLast() {
        try {
            return this.frames.removeLast();
        }
        catch (NoSuchElementException e2) {
            return null;
        }
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        return this.frames.removeLastOccurrence(o);
    }

    @Override
    public int size() {
        return this.frames.size();
    }

    public String toString() {
        StringBuilder out2 = new StringBuilder("[ ");
        Iterator<ZFrame> frameIterator = this.frames.iterator();
        while (frameIterator.hasNext()) {
            out2.append(frameIterator.next());
            if (!frameIterator.hasNext()) continue;
            out2.append(", ");
        }
        out2.append(" ]");
        return out2.toString();
    }
}

